/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.block.blockentity;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.kurome.ageofmythology.init.AOMBlockEntities;
import com.kurome.ageofmythology.init.AOMBlocks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;

public class RebornDirtBlockEntity
extends BlockEntity {
    private int ticker;
    private int layer;
    private boolean isAreaClearEnough = true;
    private int nextLeafY;
    private int yOffset;
    private float cScale;
    private float rScale;
    private int maxY;
    private int blocksSkipped;
    private int topRadius;
    public static final int MAX_CONVERSION_TIME = 200;
    private int conversionTime = 0;
    private final ResourceKey<Biome> convertingToBiome = Biomes.f_48179_;
    private BlockState topBlockForBiome = Blocks.f_50440_.m_49966_();
    private BlockState middleBlockForBiome = Blocks.f_50493_.m_49966_();
    private BlockState bottomBlockForBiome = Blocks.f_50069_.m_49966_();
    private final List<RecursiveBlockPlacement> recursiveBlockPlacements = new ArrayList<RecursiveBlockPlacement>();
    private boolean needConvert = true;

    public RebornDirtBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)AOMBlockEntities.REBORN_DIRT.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RebornDirtBlockEntity te) {
        RebornDirtBlockEntity.tickGrow(level, pos, state, te);
        RebornDirtBlockEntity.tickBiome(level, pos, state, te);
        RebornDirtBlockEntity.tickTop(level, pos.m_6630_(127 - pos.m_123342_()), state, te);
    }

    public static void tickTop(Level level, BlockPos pos, BlockState state, RebornDirtBlockEntity te) {
        if (level.f_46443_ && level.m_46472_().equals((Object)Level.f_46429_)) {
            return;
        }
        int radius = te.topRadius;
        if (radius > 50) {
            return;
        }
        if (level.m_46467_() % 5L != 0L) {
            return;
        }
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos targetPos;
                if (Math.abs(dx) != radius && Math.abs(dz) != radius || level.m_8055_(targetPos = pos.m_7918_(dx, 0, dz)).m_155947_()) continue;
                level.m_46597_(targetPos, Blocks.f_50440_.m_49966_());
            }
        }
        ++te.topRadius;
    }

    public static void tickGrow(Level level, BlockPos pos, BlockState state, RebornDirtBlockEntity te) {
        ++te.ticker;
        if (te.ticker == 1) {
            te.nextLeafY = pos.m_123342_() + 10 + level.m_213780_().m_188503_(10);
            te.yOffset = level.m_213780_().m_188503_(100);
            te.cScale = level.m_213780_().m_188501_() * 0.25f + 0.125f;
            te.rScale = level.m_213780_().m_188501_() * 0.25f + 0.125f;
            te.maxY = 131;
        }
        if (level.m_5776_()) {
            if (te.ticker < 100) {
                for (int i = 0; i < 20; ++i) {
                    float x = (float)pos.m_123341_() + level.m_213780_().m_188501_() + (float)(level.m_213780_().m_188503_(5) * (level.m_213780_().m_188499_() ? -1 : 1));
                    float z = (float)pos.m_123343_() + level.m_213780_().m_188501_() + (float)(level.m_213780_().m_188503_(5) * (level.m_213780_().m_188499_() ? -1 : 1));
                    BlockState underState = level.m_8055_(BlockPos.m_274561_((double)x, (double)pos.m_7495_().m_123342_(), (double)z));
                    if (!underState.m_280296_()) continue;
                    level.m_7107_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, underState), (double)x, (double)pos.m_123342_(), (double)z, 0.0, 0.0, 0.0);
                }
            }
        } else if (te.ticker > 100 && te.ticker % 2 == 0) {
            int layerYPos = pos.m_123342_() + te.layer;
            if (te.isAreaClearEnough && layerYPos < te.maxY) {
                float circle;
                int dz;
                int dx;
                float x = pos.m_123341_();
                float z = pos.m_123343_();
                float radius = 4.0f + Mth.m_14031_((float)((float)(pos.m_123342_() + te.yOffset) * te.rScale)) * 3.0f;
                x -= Mth.m_14031_((float)((float)(pos.m_123342_() + te.yOffset) * te.cScale)) * radius;
                z -= Mth.m_14089_((float)((float)(pos.m_123342_() + te.yOffset) * te.cScale)) * radius;
                radius = 5.0f + Mth.m_14031_((float)((float)(layerYPos + te.yOffset) * te.rScale)) * 2.5f;
                float cx = x + Mth.m_14031_((float)((float)(layerYPos + te.yOffset) * te.cScale)) * radius;
                float cz = z + Mth.m_14089_((float)((float)(layerYPos + te.yOffset) * te.cScale)) * radius;
                float stalkThickness = 2.5f;
                if (te.maxY - layerYPos < 5) {
                    stalkThickness *= (float)(te.maxY - layerYPos) / 5.0f;
                }
                int minX = Mth.m_14143_((float)(x - radius - stalkThickness));
                int maxX = Mth.m_14167_((float)(x + radius + stalkThickness));
                int minZ = Mth.m_14143_((float)(z - radius - stalkThickness));
                int maxZ = Mth.m_14167_((float)(z + radius + stalkThickness));
                for (dx = minX; dx < maxX; ++dx) {
                    for (dz = minZ; dz < maxZ; ++dz) {
                        circle = ((float)dx - cx) * ((float)dx - cx) + ((float)dz - cz) * ((float)dz - cz);
                        if (!(circle < stalkThickness * stalkThickness)) continue;
                        te.clearBlock(level, new BlockPos(dx, layerYPos, dz));
                        if (!(circle < stalkThickness)) continue;
                        te.clearBlock(level, new BlockPos(dx, layerYPos + 1, dz));
                        if (!(circle < stalkThickness / 2.0f)) continue;
                        te.clearBlock(level, new BlockPos(dx, layerYPos + 2, dz));
                    }
                }
                for (dx = minX; dx < maxX && te.isAreaClearEnough; ++dx) {
                    for (dz = minZ; dz < maxZ && te.isAreaClearEnough; ++dz) {
                        circle = ((float)dx - cx) * ((float)dx - cx) + ((float)dz - cz) * ((float)dz - cz);
                        if (!(circle < stalkThickness * stalkThickness)) continue;
                        te.isAreaClearEnough = te.tryToPlaceStalk(level, new BlockPos(dx, layerYPos, dz), true);
                        if (!(circle < stalkThickness)) continue;
                        te.tryToPlaceStalk(level, new BlockPos(dx, layerYPos + 1, dz), false);
                        if (!(circle < stalkThickness / 2.0f)) continue;
                        te.tryToPlaceStalk(level, new BlockPos(dx, layerYPos + 2, dz), false);
                    }
                }
                te.blocksSkipped = 0;
                if (layerYPos == te.nextLeafY) {
                    boolean wasAnEvenNumber = te.nextLeafY % 2 == 0;
                    float v = radius + (wasAnEvenNumber ? stalkThickness : -stalkThickness);
                    int lx = (int)(x + Mth.m_14031_((float)((float)(layerYPos + te.yOffset) * te.cScale)) * v);
                    int lz = (int)(z + Mth.m_14089_((float)((float)(layerYPos + te.yOffset) * te.cScale)) * v);
                    te.placeLeaves(level, new BlockPos(lx, layerYPos, lz));
                    te.nextLeafY = layerYPos + 5 + level.m_213780_().m_188503_(10);
                    if (te.nextLeafY % 2 == 0 == wasAnEvenNumber) {
                        ++te.nextLeafY;
                    }
                }
                ++te.layer;
            } else {
                level.m_46597_(pos, Blocks.f_50493_.m_49966_());
                level.m_46747_(pos);
            }
        }
    }

    public static void tickBiome(Level level, BlockPos pos, BlockState state, RebornDirtBlockEntity entity) {
        if (entity.needConvert) {
            if (entity.conversionTime < 200) {
                if (entity.conversionTime % 20 == 0 && entity.conversionTime >= 20 && !level.f_46443_) {
                    entity.updateTopAndBottomBlocks();
                    entity.recursivelySpreadBiomeBlocks(new ArrayList<BlockPos>(), entity.m_58899_().m_7495_(), (int)entity.getConversionAreaWidth(), (int)entity.getConversionAreaWidth());
                }
                if (entity.conversionTime == 0) {
                    entity.f_58857_.m_247517_(null, entity.m_58899_(), (SoundEvent)ACSoundRegistry.CONVERSION_CRUCIBLE_CONVERT.get(), SoundSource.BLOCKS);
                    ScreenShake_Entity.ScreenShake((Level)level, (Vec3)entity.m_58899_().m_252807_(), (float)30.0f, (float)0.038f, (int)60, (int)70);
                }
                ++entity.conversionTime;
            } else {
                entity.convertBiome();
                entity.markUpdated();
                entity.conversionTime = 0;
                entity.needConvert = false;
            }
        }
        if (!level.f_46443_ && !entity.recursiveBlockPlacements.isEmpty()) {
            Iterator<RecursiveBlockPlacement> iterator = entity.recursiveBlockPlacements.iterator();
            while (iterator.hasNext()) {
                BlockPos posAbove;
                ServerLevel serverLevel;
                BlockState blockStateAbove;
                RecursiveBlockPlacement recursiveBlockPlacement = iterator.next();
                recursiveBlockPlacement.setPlaceIn(recursiveBlockPlacement.getPlaceIn() - 1);
                if (recursiveBlockPlacement.getPlaceIn() > 0) continue;
                level.m_46597_(recursiveBlockPlacement.getPos(), recursiveBlockPlacement.getToPlace());
                if (level instanceof ServerLevel && (blockStateAbove = (serverLevel = (ServerLevel)level).m_8055_(posAbove = recursiveBlockPlacement.getPos().m_7494_())).m_60795_() && serverLevel.f_46441_.m_188503_(12) == 0) {
                    RandomSource random = serverLevel.f_46441_;
                    Optional optional = serverLevel.m_9598_().m_175515_(Registries.f_256988_).m_203636_(VegetationPlacements.f_195459_);
                    if (optional.isPresent()) {
                        Holder holder = (Holder)optional.get();
                        ((PlacedFeature)holder.m_203334_()).m_226357_((WorldGenLevel)serverLevel, serverLevel.m_7726_().m_8481_(), random, posAbove);
                    }
                }
                iterator.remove();
            }
        }
    }

    public void convertBiome() {
        Optional biomeHolder = this.f_58857_.m_9598_().m_175515_(Registries.f_256952_).m_203636_(this.convertingToBiome);
        if (biomeHolder.isEmpty()) {
            return;
        }
        int width = (int)Math.ceil(this.getConversionAreaWidth() * 0.5f) + 1;
        ArrayList<ChunkAccess> list = new ArrayList<ChunkAccess>();
        BoundingBox biomeConversionBox = new BoundingBox(this.m_58899_().m_123341_() - width, this.m_58899_().m_123342_() - width, this.m_58899_().m_123343_() - width, this.m_58899_().m_123341_() + width, this.m_58899_().m_123342_() + Math.max(width, 128), this.m_58899_().m_123343_() + width);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int k = SectionPos.m_123171_((int)biomeConversionBox.m_162398_()); k <= SectionPos.m_123171_((int)biomeConversionBox.m_162401_()); ++k) {
                for (int l = SectionPos.m_123171_((int)biomeConversionBox.m_162395_()); l <= SectionPos.m_123171_((int)biomeConversionBox.m_162399_()); ++l) {
                    ChunkAccess chunkaccess = serverLevel.m_6522_(l, k, ChunkStatus.f_62326_, false);
                    if (chunkaccess == null) continue;
                    list.add(chunkaccess);
                }
            }
            MutableInt mutableint = new MutableInt(0);
            for (ChunkAccess chunkaccess1 : list) {
                chunkaccess1.m_183442_(RebornDirtBlockEntity.makeResolver(mutableint, chunkaccess1, biomeConversionBox, width, (Holder<Biome>)((Holder)biomeHolder.get())), serverLevel.m_7726_().m_214994_().m_224579_());
                chunkaccess1.m_8092_(true);
            }
            serverLevel.m_7726_().f_8325_.m_274524_(list);
        }
    }

    public float getConversionAreaWidth() {
        return 80.0f;
    }

    private static BiomeResolver makeResolver(MutableInt biomeCounter, ChunkAccess chunkAccess, BoundingBox boundingBox, int width, Holder<Biome> biomeHolder) {
        return (quartX, quartY, quartZ, sampler) -> {
            int i = QuartPos.m_175402_((int)quartX);
            int j = QuartPos.m_175402_((int)quartY);
            int k = QuartPos.m_175402_((int)quartZ);
            Holder holder = chunkAccess.m_203495_(quartX, quartY, quartZ);
            if (boundingBox.m_260866_(i, j, k)) {
                biomeCounter.increment();
                return biomeHolder;
            }
            return holder;
        };
    }

    private boolean isBiomeBlock(BlockState blockState) {
        return blockState.m_60713_(this.topBlockForBiome.m_60734_()) || blockState.m_60713_(this.bottomBlockForBiome.m_60734_()) || blockState.m_60713_(this.middleBlockForBiome.m_60734_());
    }

    public void recursivelySpreadBiomeBlocks(List<BlockPos> crossed, BlockPos to, int maxDistance, int distanceIn) {
        if (distanceIn > 0) {
            if (!this.isBiomeBlock(this.f_58857_.m_8055_(to))) {
                BlockState blockState = this.f_58857_.m_8055_(to.m_7494_()).m_247087_() ? this.topBlockForBiome : (this.f_58857_.m_8055_(to.m_6630_(2)).m_247087_() ? this.middleBlockForBiome : this.bottomBlockForBiome);
                this.recursiveBlockPlacements.add(new RecursiveBlockPlacement(2 * (maxDistance - distanceIn), to, blockState));
            }
            crossed.add(to);
            --distanceIn;
            ArrayList<BlockPos> possibles = new ArrayList<BlockPos>();
            for (Direction direction : Direction.values()) {
                BlockPos offset;
                BlockState state;
                if ((direction == Direction.UP || direction == Direction.DOWN) && this.f_58857_.f_46441_.m_188503_(3) != 0 || (state = this.f_58857_.m_8055_(offset = to.m_121945_(direction))).m_247087_() || crossed.contains(offset) || state.m_204336_(ACTagRegistry.UNMOVEABLE) || this.f_58857_.m_7702_(offset) != null) continue;
                possibles.add(offset);
            }
            if (possibles.size() > 0) {
                this.recursivelySpreadBiomeBlocks(crossed, (BlockPos)Util.m_214621_(possibles, (RandomSource)this.f_58857_.f_46441_), maxDistance, distanceIn);
                this.recursivelySpreadBiomeBlocks(crossed, (BlockPos)Util.m_214621_(possibles, (RandomSource)this.f_58857_.f_46441_), maxDistance, distanceIn);
                this.recursivelySpreadBiomeBlocks(crossed, (BlockPos)Util.m_214621_(possibles, (RandomSource)this.f_58857_.f_46441_), maxDistance, distanceIn);
                this.recursivelySpreadBiomeBlocks(crossed, (BlockPos)Util.m_214621_(possibles, (RandomSource)this.f_58857_.f_46441_), maxDistance, distanceIn);
            }
        }
    }

    private void updateTopAndBottomBlocks() {
        this.topBlockForBiome = Blocks.f_50440_.m_49966_();
        this.middleBlockForBiome = Blocks.f_50493_.m_49966_();
        this.bottomBlockForBiome = Blocks.f_50069_.m_49966_();
    }

    public void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public static BlockState getFallbackTopBlock(Holder<Biome> biome) {
        if (biome.m_203656_(BiomeTags.f_207612_)) {
            return Blocks.f_50134_.m_49966_();
        }
        if (biome.m_203656_(BiomeTags.f_215818_)) {
            return Blocks.f_50259_.m_49966_();
        }
        return Blocks.f_50440_.m_49966_();
    }

    public static BlockState getFallbackMiddleBlock(Holder<Biome> biome) {
        if (biome.m_203656_(BiomeTags.f_207612_)) {
            return Blocks.f_50134_.m_49966_();
        }
        if (biome.m_203656_(BiomeTags.f_215818_)) {
            return Blocks.f_50259_.m_49966_();
        }
        return Blocks.f_50493_.m_49966_();
    }

    public static BlockState getFallbackBottomBlock(Holder<Biome> biome) {
        if (biome.m_203656_(BiomeTags.f_207612_)) {
            return Blocks.f_50134_.m_49966_();
        }
        if (biome.m_203656_(BiomeTags.f_215818_)) {
            return Blocks.f_50259_.m_49966_();
        }
        return Blocks.f_50069_.m_49966_();
    }

    private void placeLeaves(Level world, BlockPos pos) {
        int dz;
        int dx;
        world.m_46597_(pos, Blocks.f_50011_.m_49966_());
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                int distance = Math.abs(dx) + Math.abs(dz) + 1;
                this.tryToPlaceLeaves(world, pos.m_7918_(dx, -1, dz), distance);
                this.tryToPlaceLeaves(world, pos.m_7918_(dx, 1, dz), distance);
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                if ((dx == 2 || dx == -2) && (dz == 2 || dz == -2)) continue;
                this.tryToPlaceLeaves(world, pos.m_7918_(dx, 0, dz), Math.max(Math.abs(dx) + Math.abs(dz), 1));
            }
        }
    }

    private boolean tryToPlaceStalk(Level level, BlockPos pos, boolean checkBlocked) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_() || !state.m_60713_((Block)AOMBlocks.REBORN_DIRT.get()) || state.m_60795_() || state.m_204336_(BlockTags.f_13035_)) {
            level.m_46597_(pos, Blocks.f_50011_.m_49966_());
        }
        return true;
    }

    private boolean clearBlock(Level level, BlockPos pos) {
        RebornDirtBlockEntity.clearBlockOne(level, pos);
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_7494_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_7494_().m_7494_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_7494_().m_7494_().m_7494_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_7494_().m_7494_().m_7494_().m_7494_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_7494_().m_7494_().m_7494_().m_7494_().m_7494_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122024_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122024_().m_122024_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122024_().m_122024_().m_122024_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122024_().m_122024_().m_122024_().m_122024_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122029_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122029_().m_122029_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122029_().m_122029_().m_122029_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122029_().m_122029_().m_122029_().m_122029_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122012_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122012_().m_122012_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122012_().m_122012_().m_122012_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122012_().m_122012_().m_122012_().m_122012_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122019_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122019_().m_122019_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122019_().m_122019_().m_122019_());
        RebornDirtBlockEntity.clearBlockOne(level, pos.m_122019_().m_122019_().m_122019_().m_122019_());
        return true;
    }

    private static boolean clearBlockOne(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60713_((Block)AOMBlocks.REBORN_DIRT.get()) || state.m_60713_(Blocks.f_50011_) || state.m_60713_(Blocks.f_50141_))) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        return true;
    }

    private void tryToPlaceLeaves(Level world, BlockPos pos, int distance) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() || state.m_204336_(BlockTags.f_13035_)) {
            world.m_7731_(pos, Blocks.f_50141_.m_49966_(), 2);
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_("ticker", this.ticker);
        compoundTag.m_128405_("layer", this.layer);
        compoundTag.m_128379_("isAreaClearEnough", this.isAreaClearEnough);
        compoundTag.m_128405_("nextLeafY", this.nextLeafY);
        compoundTag.m_128405_("yOffset", this.yOffset);
        compoundTag.m_128350_("cScale", this.cScale);
        compoundTag.m_128350_("rScale", this.rScale);
        compoundTag.m_128405_("maxY", this.maxY);
        compoundTag.m_128405_("blocksSkipped", this.blocksSkipped);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.ticker = compoundTag.m_128451_("ticker");
        this.layer = compoundTag.m_128451_("layer");
        this.isAreaClearEnough = compoundTag.m_128471_("isAreaClearEnough");
        this.nextLeafY = compoundTag.m_128451_("nextLeafY");
        this.yOffset = compoundTag.m_128451_("yOffset");
        this.cScale = compoundTag.m_128457_("cScale");
        this.rScale = compoundTag.m_128457_("rScale");
        this.maxY = compoundTag.m_128451_("maxY");
        this.blocksSkipped = compoundTag.m_128451_("blocksSkipped");
    }

    private class RecursiveBlockPlacement {
        private int placeIn;
        private final BlockPos pos;
        private final BlockState toPlace;

        public RecursiveBlockPlacement(int placeIn, BlockPos pos, BlockState toPlace) {
            this.placeIn = placeIn;
            this.pos = pos;
            this.toPlace = toPlace;
        }

        public int getPlaceIn() {
            return this.placeIn;
        }

        public void setPlaceIn(int placeIn) {
            this.placeIn = placeIn;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getToPlace() {
            return this.toPlace;
        }
    }
}

