/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.block;

import com.kurome.ageofmythology.block.AOMSkullBlockEntity;
import com.kurome.ageofmythology.enums.MobVariant;
import com.kurome.ageofmythology.init.AOMBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class AOMAbstractSkullBlock
extends BaseEntityBlock {
    private final MobVariant variant;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    protected AOMAbstractSkullBlock(MobVariant variant, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = variant;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!level.m_5776_() && (flag = level.m_276867_(pos)) != (Boolean)state.m_61143_((Property)POWERED)) {
            if (flag) {
                this.playSound(level, pos);
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        this.playSound(level, pos);
        this.createParticle(level, pos);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AOMSkullBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return AOMAbstractSkullBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)AOMBlockEntities.AOMSkull.get()), AOMSkullBlockEntity::tick);
    }

    public MobVariant getVariant() {
        return this.variant;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public void playSound(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (!world.m_5776_() && te instanceof AOMSkullBlockEntity) {
            SoundEvent sound = null;
            float volume = 1.0f;
            float pitch = 0.9f;
            switch (this.variant) {
                case TWILIGHTFOREST_NAGA: {
                    volume = 1.25f;
                    pitch = 1.2f;
                    break;
                }
            }
            if (sound != null) {
                world.m_5594_(null, pos, sound, SoundSource.BLOCKS, volume, world.m_213780_().m_188501_() * 0.1f + pitch);
            }
        }
    }

    public void createParticle(Level level, BlockPos pos) {
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof AOMSkullBlockEntity) {
            RandomSource rand = level.m_213780_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                switch (this.variant) {
                    case TWILIGHTFOREST_NAGA: {
                        for (int daze = 0; daze < 10; ++daze) {
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)pos.m_123341_() + (double)rand.m_188501_() * 0.5 * 2.0, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + (double)rand.m_188501_() * 0.5 * 2.0, 1, 0.0, 0.0, 0.0, rand.m_188583_() * 0.02);
                        }
                        break;
                    }
                }
            }
        }
    }
}

