/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.impl.ice_and_fire;

import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.kurome.ageofmythology.bettermorph.impl.BaseIdentity;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.ice_and_fire.GorgonAbilityConfig;
import com.kurome.ageofmythology.model.Ability;
import com.kurome.ageofmythology.utils.MorphUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class GorgonAbility
extends BaseIdentity<EntityGorgon> {
    private static final GorgonAbility INSTANCE = new GorgonAbility();
    public static HashMap<Integer, Integer> skillCoolDownMap = new HashMap<Integer, Integer>(){
        {
            this.put(0, 30);
        }
    };

    public static GorgonAbility getInstance() {
        return INSTANCE;
    }

    public static int getSkillCoolDown(int animationId) {
        return skillCoolDownMap.getOrDefault(animationId, 60);
    }

    @Override
    public void tick(Player player, EntityGorgon entity) {
        super.tick(player, entity);
        this.aiStep(player, entity);
        AnimationHandler.INSTANCE.updateAnimations((Entity)entity);
    }

    public void aiStep(Player player, EntityGorgon entity) {
        if (entity.getAnimation() == EntityGorgon.ANIMATION_SCARE && entity.getAnimationTick() == 1) {
            AOMAbilityConfig.playSound(player, IafSoundRegistry.GORGON_ATTACK, 3.0f, 1.1f);
        }
        if (entity.getAnimation() == EntityGorgon.ANIMATION_SCARE && entity.getAnimationTick() == 10 && !player.m_9236_().f_46443_) {
            Consumer<LivingEntity> consumer = attackTarget -> {
                if (attackTarget instanceof EntityStoneStatue) {
                    return;
                }
                EntityStoneStatue statue = EntityStoneStatue.buildStatueEntity((LivingEntity)attackTarget);
                statue.m_19890_(attackTarget.m_20185_(), attackTarget.m_20186_(), attackTarget.m_20189_(), attackTarget.m_146908_(), attackTarget.m_146909_());
                if (!player.m_9236_().f_46443_) {
                    player.m_9236_().m_7967_((Entity)statue);
                }
                statue.m_146922_(attackTarget.m_146908_());
                statue.m_146922_(attackTarget.m_146908_());
                statue.f_20885_ = attackTarget.m_146908_();
                statue.f_20883_ = attackTarget.m_146908_();
                statue.f_20884_ = attackTarget.m_146908_();
            };
            MorphUtil.AreaAttack((LivingEntity)player, 8.25f, 3.25f, 180.0f, false, 10.0, consumer);
        }
    }

    public static void registerAbility(HashMap<String, List<Ability>> ABILITY_MAP) {
        ABILITY_MAP.put(((EntityType)IafEntityRegistry.GORGON.get()).m_20675_(), Arrays.asList(GorgonAbilityConfig.gorgon_attack(0)));
    }
}

