/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.impl.ice_and_fire;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.kurome.ageofmythology.bettermorph.impl.BaseIdentity;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.config.ability_config.DragonAbilityConfig;
import com.kurome.ageofmythology.model.Ability;
import dev.architectury.event.EventResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import liushuangwuyin.bettermorph.api.event.IdentitySwapCallback;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class FireDragonAbility
extends BaseIdentity<EntityFireDragon> {
    private static final FireDragonAbility INSTANCE = new FireDragonAbility();

    public static FireDragonAbility getInstance() {
        return INSTANCE;
    }

    @Override
    public void tick(Player player, EntityFireDragon dragon) {
        super.tick(player, dragon);
        if (player.m_20096_()) {
            dragon.setFlying(false);
            dragon.setHovering(false);
            dragon.flyProgress = 0.0f;
            dragon.hoverProgress = 0.0f;
        } else {
            dragon.setFlying(true);
        }
        dragon.flightCycle = dragon.flightCycle < 58 ? (dragon.flightCycle += 2) : 0;
    }

    @Override
    public void onUse(Player player, EntityFireDragon entityFireDragon, Level level) {
        super.onUse(player, entityFireDragon, level);
    }

    public void clientOnUse(Player player, EntityFireDragon identity, Level world) {
        super.clientOnUse(player, (LivingEntity)identity, world);
    }

    public static void registerAbility(HashMap<String, List<Ability>> ABILITY_MAP) {
        ABILITY_MAP.put(((EntityType)IafEntityRegistry.FIRE_DRAGON.get()).m_20675_(), Arrays.asList(DragonAbilityConfig.fire_ball(), DragonAbilityConfig.fire_breath(), DragonAbilityConfig.magma_bomb(), DragonAbilityConfig.scorch(), DragonAbilityConfig.heat_surge(), DragonAbilityConfig.dragon_blood((Item)IafItemRegistry.FIRE_DRAGON_BLOOD.get()), DragonAbilityConfig.eat(5, 0.5f, 1)));
    }

    public static void registerSwapCallback() {
        IdentitySwapCallback.EVENT.register((player, morph) -> {
            if (morph instanceof EntityDragonBase) {
                EntityDragonBase dragon = (EntityDragonBase)morph;
                player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                    dragon.setAgeInDays(data.getDragonAge());
                    dragon.m_20011_(dragon.m_20191_());
                    dragon.m_6210_();
                    player.m_6210_();
                    data.sync((Player)player);
                });
            }
            return EventResult.pass();
        });
    }
}

