/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.impl.ice_and_fire;

import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.kurome.ageofmythology.bettermorph.impl.BaseIdentity;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.ice_and_fire.CyclopsAbilityConfig;
import com.kurome.ageofmythology.model.Ability;
import com.kurome.ageofmythology.utils.MorphUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class CyclopsAbility
extends BaseIdentity<EntityCyclops> {
    private static final CyclopsAbility INSTANCE = new CyclopsAbility();
    public static HashMap<Integer, Integer> skillCoolDownMap = new HashMap<Integer, Integer>(){
        {
            this.put(1, 27);
            this.put(2, 40);
            this.put(3, 20);
            this.put(4, 30);
        }
    };

    public static CyclopsAbility getInstance() {
        return INSTANCE;
    }

    public static int getSkillCoolDown(int animationId) {
        return skillCoolDownMap.getOrDefault(animationId, 60);
    }

    @Override
    public void tick(Player player, EntityCyclops entity) {
        super.tick(player, entity);
        this.aiStep(player, entity);
        AnimationHandler.INSTANCE.updateAnimations((Entity)entity);
    }

    public void aiStep(Player player, EntityCyclops entity) {
        if (entity.getAnimation() == EntityCyclops.ANIMATION_ROAR && entity.getAnimationTick() == 5) {
            AOMAbilityConfig.playSound(player, (SoundEvent)ModSounds.REMNANT_ROAR.get(), 3.0f, 1.1f);
            MorphUtil.ScreenShake((LivingEntity)player);
            MorphUtil.AreaAttack((LivingEntity)player, 8.25f, 3.25f, 180.0f, false, 10.0);
        }
        if (entity.getAnimation() == EntityCyclops.ANIMATION_KICK && entity.getAnimationTick() == 12) {
            MorphUtil.AreaAttack((LivingEntity)player, 6.25f, 2.25f, 180.0f, true, new Vec3(4.0, 3.0, 4.0), 8.0);
            AOMAbilityConfig.playSound(player, SoundEvents.f_12313_, 1.0f, 1.0f);
        }
        if (entity.getAnimation() == EntityCyclops.ANIMATION_STOMP && entity.getAnimationTick() == 14) {
            MorphUtil.AreaAttack((LivingEntity)player, 8.25f, 3.25f, 180.0f, true, 10.0);
            MorphUtil.ScreenShake((LivingEntity)player);
            AOMAbilityConfig.playSound(player, (SoundEvent)ModSounds.REMNANT_STOMP.get(), 1.0f, 1.0f);
        }
    }

    public static void registerAbility(HashMap<String, List<Ability>> ABILITY_MAP) {
        ABILITY_MAP.put(((EntityType)IafEntityRegistry.CYCLOPS.get()).m_20675_(), Arrays.asList(CyclopsAbilityConfig.cyclops_attack(4), CyclopsAbilityConfig.cyclops_attack(3), CyclopsAbilityConfig.cyclops_attack(1)));
    }
}

