/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.impl.general;

import com.kurome.ageofmythology.bettermorph.api.IExecute;
import java.util.HashMap;
import java.util.function.Consumer;

public class TimeExecutor
implements IExecute {
    private final Consumer<TimeExecutor> consumer;
    private final int delay;
    private int age;
    private int duration = 0;
    private int triggerTick = 1;
    private HashMap<String, Object> extra = new HashMap();

    public Object getExtra(String key) {
        return this.extra.get(key);
    }

    public void setExtra(String key, Object value) {
        this.extra.put(key, value);
    }

    public int getAge() {
        return this.age;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getDuration() {
        return this.duration;
    }

    public TimeExecutor(Consumer<TimeExecutor> callback, int delay) {
        this(callback, delay, 0);
    }

    public TimeExecutor(Consumer<TimeExecutor> callback, int delay, int duration) {
        this(callback, delay, duration, 1);
    }

    public TimeExecutor(Consumer<TimeExecutor> callback, int delay, int duration, int triggerTick) {
        this.consumer = callback;
        this.delay = delay;
        this.duration = duration;
        this.triggerTick = triggerTick;
        this.age = 0;
    }

    @Override
    public boolean canExecute() {
        ++this.age;
        return this.age >= this.delay;
    }

    @Override
    public void execute() {
        this.consumer.accept(this);
    }

    @Override
    public boolean canRemove() {
        return this.age >= this.delay + this.duration;
    }

    @Override
    public int triggerTick() {
        return this.triggerTick <= 0 ? 1 : this.triggerTick;
    }
}

