/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.impl.cataclysm;

import com.github.L_Ender.cataclysm.client.particle.CircleLightningParticle;
import com.github.L_Ender.cataclysm.client.particle.Gathering_Water_Particle;
import com.github.L_Ender.cataclysm.client.particle.RingParticle;
import com.github.L_Ender.cataclysm.client.particle.Scylla_Swing_Particle;
import com.github.L_Ender.cataclysm.client.particle.StormParticle;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Scylla.Scylla_Ceraunus_Entity;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Scylla.Scylla_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Lightning_Storm_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Lightning_Spear_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Water_Spear_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import com.kurome.ageofmythology.bettermorph.api.IScyllaEntity;
import com.kurome.ageofmythology.bettermorph.impl.BaseIdentity;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.cataclysm.ScyllaAbilityConfig;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import com.kurome.ageofmythology.model.Ability;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScyllaAbility
extends BaseIdentity<Scylla_Entity> {
    private static final ScyllaAbility INSTANCE = new ScyllaAbility();
    private Vec3 triggerTarget = new Vec3(0.0, 0.0, 0.0);
    public static HashMap<Integer, Integer> skillCoolDownMap = new HashMap<Integer, Integer>(){
        {
            this.put(1, 38);
            this.put(7, 87);
            this.put(9, 150);
            this.put(10, 49);
            this.put(11, 49);
            this.put(15, 70);
            this.put(16, 44);
            this.put(17, 23);
            this.put(18, 85);
        }
    };

    public static ScyllaAbility getInstance() {
        return INSTANCE;
    }

    public static int getSkillCoolDown(int animationId) {
        return skillCoolDownMap.getOrDefault(animationId, 60);
    }

    public Vec3 getTriggerTarget(LivingEntity player) {
        if (player.m_20182_().m_82554_(this.triggerTarget) > 100.0) {
            return Utils.raycastForEntity((Level)player.m_9236_(), (Entity)player, (float)100.0f, (boolean)true, (float)0.25f).m_82450_();
        }
        return this.triggerTarget;
    }

    public void setTriggerTarget(Vec3 vec3) {
        this.triggerTarget = vec3;
    }

    @Override
    public void tick(Player player, Scylla_Entity entity) {
        Entity weapon;
        super.tick(player, entity);
        if (!entity.getAct()) {
            entity.setAct(true);
            entity.setAttackState(0);
        }
        if (entity.getAttackState() > 0) {
            ++entity.attackTicks;
        }
        if (player.m_9236_().m_5776_()) {
            entity.idleAnimationState.m_246184_(entity.getAttackState() == 0, entity.f_19797_);
        }
        if ((weapon = entity.getAnchor()) instanceof Scylla_Ceraunus_Entity) {
            Scylla_Ceraunus_Entity anchor = (Scylla_Ceraunus_Entity)weapon;
            if (entity instanceof IScyllaEntity) {
                IScyllaEntity iScyllaEntity = (IScyllaEntity)entity;
                iScyllaEntity.setAnchorId(anchor.m_19879_());
                anchor.setControllerUUID(player.m_20148_());
            }
        }
        if (entity.isFlying()) {
            player.m_20242_(!player.f_201939_);
        } else {
            player.m_20242_(false);
        }
        this.aiStep(player, entity);
    }

    public void aiStep(Player player, Scylla_Entity entity) {
        Water_Spear_Entity water;
        float playerDamage;
        float xRot;
        float yRot;
        Vec3 vec3;
        double d3;
        double d1;
        double d0;
        double d2;
        float b;
        float g;
        float r;
        Vec3 target = Utils.raycastForEntity((Level)player.m_9236_(), (Entity)player, (float)96.0f, (boolean)true, (float)0.25f).m_82450_();
        float f = Mth.m_14089_((float)(player.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(player.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)player.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.0);
        double vecZ = Math.sin(theta);
        if (entity.getAttackState() == 1 && entity.attackTicks == 15) {
            AOMAbilityConfig.playSound(player, (SoundEvent)ModSounds.STRONGSWING.get(), 2.0f, 0.75f + player.m_217043_().m_188501_() * 0.1f);
            ScyllaAbility.AreaAttack((LivingEntity)player, 3.25f, 6.0f, 100.0f, 1.0f, 80, true);
            ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)10.0f, (float)0.1f, (int)0, (int)20);
            ScyllaAbility.SwingParticle((LivingEntity)player, vecX, -5.0, vecZ, 1.5, false, 0.95f);
        }
        if (entity.getAttackState() == 1 && entity.attackTicks > ScyllaAbility.getSkillCoolDown(1)) {
            entity.setAttackState(0);
        }
        if (entity.getAttackState() == 7) {
            if (entity.attackTicks < 40 && entity.attackTicks >= 12 && player.m_9236_().f_46443_) {
                r = 0.56078434f;
                g = 0.94509804f;
                b = 0.84313726f;
                player.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(0.3882353f, 0.7607843f, 0.8784314f, 6.0f + player.m_217043_().m_188501_() * 0.25f, 1.5f + player.m_217043_().m_188501_() * 0.45f, player.m_19879_()), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
                player.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 4.0f + player.m_217043_().m_188501_() * 1.2f, 1.0f + player.m_217043_().m_188501_() * 0.45f, player.m_19879_()), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
                player.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.0f + player.m_217043_().m_188501_() * 0.7f, 0.35f + player.m_217043_().m_188501_() * 0.45f, player.m_19879_()), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (entity.attackTicks == 29 || entity.attackTicks == 40 || entity.attackTicks == 51) {
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)20.0f, (float)0.1f, (int)0, (int)20);
                AOMAbilityConfig.playSound(player, (SoundEvent)ModSounds.STRONGSWING.get(), 2.0f, 1.1f);
                if (player.m_9236_().f_46443_) {
                    double d02 = player.m_20185_();
                    double d12 = player.m_20186_() + (double)(player.m_20206_() / 2.0f) + 0.5;
                    d2 = player.m_20189_();
                    float yaw = (float)Math.toRadians(-player.f_20883_);
                    double lookX = -Math.cos(yaw);
                    double lookZ = -Math.sin(yaw);
                    float pitch = (float)Math.atan2(-5.0, Math.sqrt(lookX * lookX + lookZ * lookZ));
                    player.m_9236_().m_7106_((ParticleOptions)new Scylla_Swing_Particle.SwingData(player.m_6134_() * 2.0f, yaw, pitch), d02, d12, d2, 0.0, 0.0, 0.0);
                } else {
                    ScyllaAbility.SpinDamage((LivingEntity)player, 2.0f, 5.5, 3.0f, 1.5, 1.0f, (float)AOMUtil.cataclysmHpDamage, 0.0f, 120);
                }
            }
            if (entity.attackTicks < 26 && entity.attackTicks >= 12) {
                ScyllaAbility.Stormknockback((LivingEntity)player, 0.5f, 5.5);
            }
            if (entity.attackTicks < 53 && entity.attackTicks >= 26) {
                ScyllaAbility.Stormknockback((LivingEntity)player, 0.6f, 5.5);
            }
        }
        if (entity.getAttackState() == 7 && entity.attackTicks > ScyllaAbility.getSkillCoolDown(7)) {
            entity.setAttackState(0);
        }
        if (entity.getAttackState() == 9) {
            if (entity.attackTicks == 1) {
                entity.setEye(true);
                entity.setChainAnchor(true);
            }
            if (entity.attackTicks < 115 && entity.attackTicks > 55) {
                ScyllaAbility.CircleLighning((LivingEntity)player, 0.2f, 0.2f, (player.m_217043_().m_188501_() - 0.5f) * 12.0f, 9.0, 3, 1);
                ScyllaAbility.Stormknockback((LivingEntity)player, 0.7f, 5.5);
                if (player.m_9236_().f_46443_) {
                    r = 0.56078434f;
                    g = 0.94509804f;
                    b = 0.84313726f;
                    player.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(0.3882353f, 0.7607843f, 0.8784314f, 6.0f + player.m_217043_().m_188501_() * 0.25f, 1.5f + player.m_217043_().m_188501_() * 0.45f, player.m_19879_()), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
                    player.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 4.0f + player.m_217043_().m_188501_() * 1.2f, 1.0f + player.m_217043_().m_188501_() * 0.45f, player.m_19879_()), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
                    player.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.0f + player.m_217043_().m_188501_() * 0.7f, 0.35f + player.m_217043_().m_188501_() * 0.45f, player.m_19879_()), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
                }
            }
            if (entity.attackTicks < 140 && entity.attackTicks > 55) {
                ScyllaAbility.Nimbo((LivingEntity)player, 0.2f, 0.2f, 5.0f, 9.5, 5, 2);
            }
            if (entity.attackTicks == 55) {
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)15.0f, (float)0.02f, (int)20, (int)10);
            }
            if (entity.attackTicks == 75) {
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)20.0f, (float)0.03f, (int)20, (int)10);
            }
            if (entity.attackTicks == 95) {
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)25.0f, (float)0.04f, (int)20, (int)10);
            }
            if (entity.attackTicks == 114) {
                AOMAbilityConfig.playSound(player, (SoundEvent)ModSounds.SUPER_LIGHTNING.get());
                if (player.m_9236_().f_46443_) {
                    double d03 = player.m_20185_() + vecX * (double)0.2f + (double)(f * 0.2f);
                    double d13 = player.m_20186_() + 9.0;
                    d2 = player.m_20189_() + vecZ * (double)0.2f + (double)(f1 * 0.2f);
                    player.m_9236_().m_7106_((ParticleOptions)ModParticle.LIGHTNING_EXPLODE.get(), d03, d13, d2, 0.0, 0.0, 0.0);
                }
            }
            for (int l = 115; l <= 145; l += 2) {
                if (entity.attackTicks != l) continue;
                Vec3 triggerTarget = this.getTriggerTarget((LivingEntity)player);
                float f_9 = Mth.m_14089_((float)(player.f_20883_ * ((float)Math.PI / 180)));
                float f1_9 = Mth.m_14031_((float)(player.f_20883_ * ((float)Math.PI / 180)));
                float f2 = player.m_217043_().m_188501_() * ((float)Math.PI * 2);
                float f3 = Mth.m_14116_((float)player.m_217043_().m_188501_()) * 5.0f;
                float math = 0.2f;
                d0 = player.m_20185_() + (double)(f_9 * math) + (double)(Mth.m_14089_((float)f2) * f3);
                d1 = player.m_20186_() + (double)(player.m_20206_() * 2.8f);
                double d22 = player.m_20189_() + (double)(f1_9 * math) + (double)(Mth.m_14031_((float)f2) * f3);
                d3 = triggerTarget.f_82479_ - (player.m_217043_().m_188500_() - 0.5) * 6.0 - d0;
                double d4 = triggerTarget.f_82480_ + 0.35 - player.m_217043_().m_188500_() - d1;
                double d5 = triggerTarget.f_82481_ - (player.m_217043_().m_188500_() - 0.5) * 6.0 - d22;
                vec3 = new Vec3(d3, d4, d5).m_82541_();
                yRot = (float)(Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.29577951308232) + 90.0f;
                xRot = (float)(-(Mth.m_14136_((double)vec3.f_82480_, (double)Math.sqrt(vec3.f_82479_ * vec3.f_82479_ + vec3.f_82481_ * vec3.f_82481_)) * 57.29577951308232));
                playerDamage = (float)(AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(EntityTagGenerator.ABYSS, EntityTagGenerator.GENERAL)) + (double)entity.m_21233_() * AOMUtil.cataclysmHpDamage + 14.0);
                water = new Water_Spear_Entity((LivingEntity)player, vec3, player.m_9236_(), playerDamage);
                water.m_146922_(yRot);
                water.m_146926_(xRot);
                water.m_20343_(d0, d1, d22);
                water.setTotalBounces(3);
                player.m_9236_().m_7967_((Entity)water);
                Lightning_Spear_Entity lightning = new Lightning_Spear_Entity((LivingEntity)player, vec3, player.m_9236_(), playerDamage);
                lightning.m_146922_(yRot);
                lightning.m_146926_(xRot);
                lightning.m_20343_(d0, d1, d22);
                lightning.setAreaDamage(playerDamage);
                lightning.setHpDamage((float)AOMUtil.cataclysmHpDamage);
                lightning.setAreaRadius(2.0f);
                player.m_9236_().m_7967_((Entity)lightning);
            }
        }
        if (entity.getAttackState() == 9 && entity.attackTicks > ScyllaAbility.getSkillCoolDown(9)) {
            entity.setAttackState(0);
            entity.setEye(false);
            entity.setChainAnchor(false);
        }
        if (entity.getAttackState() == 10) {
            if (entity.attackTicks < 24 && entity.attackTicks > 7) {
                ScyllaAbility.PullLighning((LivingEntity)player, 7.0, -0.5, -0.5f, player.m_20206_());
            }
            if (entity.attackTicks == 27) {
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)15.0f, (float)0.05f, (int)0, (int)10);
            }
        }
        if (entity.getAttackState() == 11) {
            if (entity.attackTicks < 17 && player.m_9236_().f_46443_) {
                r = 0.56078434f;
                g = 0.94509804f;
                b = 0.84313726f;
                double vec = -0.5;
                float math = -0.5f;
                double d04 = player.m_20185_() + vecX * vec + (double)(f * math);
                double d14 = player.m_20186_() + (double)player.m_20206_();
                double d23 = player.m_20189_() + vecZ * vec + (double)(f1 * math);
                player.m_9236_().m_7106_((ParticleOptions)new Gathering_Water_Particle.GatheringData(r, g, b), d04 + (double)((player.m_217043_().m_188501_() - 0.5f) * 7.0f), d14 + (double)player.m_217043_().m_188501_() - 0.25, d23 + (double)((player.m_217043_().m_188501_() - 0.5f) * 7.0f), d04, d14, d23);
            }
            if (entity.attackTicks == 27) {
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)15.0f, (float)0.05f, (int)0, (int)10);
            }
        }
        if (entity.attackTicks == 27) {
            double math = -0.5;
            double d05 = player.m_20185_() + (double)f * math;
            double d15 = player.m_20186_() + (double)(player.m_20206_() * 0.8f);
            double d24 = player.m_20189_() + (double)f1 * math;
            double d32 = target.m_7096_() - d05;
            double d4 = target.f_82480_ + 0.35 - d15;
            double d5 = target.m_7094_() - d24;
            Vec3 vec32 = new Vec3(d32, d4, d5).m_82541_();
            float yRot2 = (float)(Mth.m_14136_((double)vec32.f_82481_, (double)vec32.f_82479_) * 57.29577951308232) + 90.0f;
            float xRot2 = (float)(-(Mth.m_14136_((double)vec32.f_82480_, (double)Math.sqrt(vec32.f_82479_ * vec32.f_82479_ + vec32.f_82481_ * vec32.f_82481_)) * 57.29577951308232));
            float playerDamage2 = (float)(AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(EntityTagGenerator.ABYSS, EntityTagGenerator.GENERAL)) + (double)entity.m_21233_() * AOMUtil.cataclysmHpDamage + 14.0);
            if (entity.getAttackState() == 11) {
                Water_Spear_Entity water2 = new Water_Spear_Entity((LivingEntity)player, vec32, player.m_9236_(), playerDamage2);
                water2.accelerationPower = 0.2;
                water2.m_146922_(yRot2);
                water2.m_146926_(xRot2);
                water2.m_20343_(d05, d15, d24);
                water2.setTotalBounces(8);
                player.m_9236_().m_7967_((Entity)water2);
            }
            if (entity.getAttackState() == 10) {
                Lightning_Spear_Entity lightning = new Lightning_Spear_Entity((LivingEntity)player, vec32, player.m_9236_(), playerDamage2);
                lightning.accelerationPower = 0.2;
                lightning.m_146922_(yRot2);
                lightning.m_146926_(xRot2);
                lightning.m_20343_(d05, d15, d24);
                lightning.setAreaDamage(playerDamage2);
                lightning.setHpDamage((float)AOMUtil.cataclysmHpDamage);
                lightning.setAreaRadius(2.0f);
                player.m_9236_().m_7967_((Entity)lightning);
            }
        }
        if (entity.attackTicks == 32) {
            for (int i = 0; i < 2; ++i) {
                double dis = 2.0;
                double firstAngleOffset = 0.5 * dis;
                double math = -0.5 - firstAngleOffset + (double)i * dis;
                d0 = player.m_20185_() + (double)f * math;
                d1 = player.m_20186_() + (double)(player.m_20206_() * 0.7f);
                double d25 = player.m_20189_() + (double)f1 * math;
                d3 = target.m_7096_() - d0;
                double d4 = target.f_82480_ + 0.35 - d1;
                double d5 = target.m_7094_() - d25;
                vec3 = new Vec3(d3, d4, d5).m_82541_();
                yRot = (float)(Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.29577951308232) + 90.0f;
                xRot = (float)(-(Mth.m_14136_((double)vec3.f_82480_, (double)Math.sqrt(vec3.f_82479_ * vec3.f_82479_ + vec3.f_82481_ * vec3.f_82481_)) * 57.29577951308232));
                playerDamage = (float)(AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(EntityTagGenerator.ABYSS, EntityTagGenerator.GENERAL)) + (double)entity.m_21233_() * AOMUtil.cataclysmHpDamage + 14.0);
                if (entity.getAttackState() == 11) {
                    water = new Water_Spear_Entity((LivingEntity)player, vec3, player.m_9236_(), playerDamage);
                    water.accelerationPower = 0.2;
                    water.m_146922_(yRot);
                    water.m_146926_(xRot);
                    water.m_20343_(d0, d1, d25);
                    water.setTotalBounces(8);
                    player.m_9236_().m_7967_((Entity)water);
                }
                if (entity.getAttackState() != 10) continue;
                Lightning_Spear_Entity lightning = new Lightning_Spear_Entity((LivingEntity)player, vec3, player.m_9236_(), playerDamage);
                lightning.accelerationPower = 0.2;
                lightning.m_146922_(yRot);
                lightning.m_146926_(xRot);
                lightning.m_20343_(d0, d1, d25);
                lightning.setAreaDamage(playerDamage);
                lightning.setHpDamage((float)AOMUtil.cataclysmHpDamage);
                lightning.setAreaRadius(2.0f);
                player.m_9236_().m_7967_((Entity)lightning);
            }
        }
        if (entity.getAttackState() == 10 && entity.attackTicks > ScyllaAbility.getSkillCoolDown(10)) {
            entity.setAttackState(0);
        }
        if (entity.getAttackState() == 11 && entity.attackTicks > ScyllaAbility.getSkillCoolDown(11)) {
            entity.setAttackState(0);
        }
        if (entity.getAttackState() == 15) {
            Scylla_Ceraunus_Entity anchor;
            Entity weapon;
            int attackshot = 47;
            Vec3 firstTarget = this.getTriggerTarget((LivingEntity)player);
            if (entity.attackTicks == 9) {
                double d16 = firstTarget.m_7098_() - player.m_20186_();
                player.m_20334_(0.0, 1.7 + Mth.m_14008_((double)(d16 * 0.075), (double)0.0, (double)7.0), 0.0);
            }
            if (entity.attackTicks == 25) {
                entity.setFlying(true);
                player.m_20256_(Vec3.f_82478_);
            }
            if (entity.attackTicks == attackshot) {
                Scylla_Ceraunus_Entity throwntrident = new Scylla_Ceraunus_Entity(player.m_9236_(), (LivingEntity)player);
                double p0 = firstTarget.m_7096_() - player.m_20185_();
                double p1 = firstTarget.f_82480_ + 0.3333333333333333 - throwntrident.m_20186_();
                double p2 = firstTarget.f_82481_ - player.m_20189_();
                double p3 = Math.sqrt(p0 * p0 + p2 * p2);
                float playerDamage3 = (float)(AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(EntityTagGenerator.ABYSS, EntityTagGenerator.GENERAL)) + (double)entity.m_21233_() * AOMUtil.cataclysmHpDamage + 14.0);
                throwntrident.m_36781_((double)playerDamage3);
                throwntrident.setPhase(entity.isPhase());
                throwntrident.m_6686_(p0, p1 + p3 * (double)0.2f, p2, 2.0f, 0.0f);
                throwntrident.setControllerUUID(player.m_20148_());
                throwntrident.setHookMode(true);
                entity.setAnchorUUID(throwntrident.m_20148_());
                player.m_9236_().m_7967_((Entity)throwntrident);
            }
            if (entity.attackTicks > attackshot && (weapon = entity.getAnchor()) instanceof Scylla_Ceraunus_Entity && (anchor = (Scylla_Ceraunus_Entity)weapon).getGrab()) {
                entity.setAttackState(16);
                if (entity.isFlying()) {
                    entity.setFlying(false);
                }
            }
        }
        if (entity.getAttackState() == 15 && entity.attackTicks > ScyllaAbility.getSkillCoolDown(15)) {
            entity.setAttackState(16);
            if (entity.isFlying()) {
                entity.setFlying(false);
            }
        }
        if (entity.getAttackState() == 16) {
            Entity weapon = entity.getAnchor();
            if (weapon instanceof Scylla_Ceraunus_Entity) {
                Scylla_Ceraunus_Entity anchor = (Scylla_Ceraunus_Entity)weapon;
                double maxSpeed = 18.0;
                double pullSpeed = maxSpeed / 6.0;
                Vec3 distance = anchor.m_20182_().m_82546_(player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0));
                Vec3 motion = distance.m_82541_().m_82490_(pullSpeed);
                if (Math.abs(distance.f_82480_) < 0.1) {
                    motion = new Vec3(motion.f_82479_, 0.0, motion.f_82481_);
                }
                Vec3 vec33 = new Vec3(distance.f_82479_, 0.0, distance.f_82481_);
                Vec3 vec34 = new Vec3((double)(player.m_20205_() / 2.0f), 0.0, (double)(player.m_20205_() / 2.0f));
                if (vec33.m_82553_() < vec34.m_82553_() / 1.4) {
                    motion = new Vec3(0.0, motion.f_82480_, 0.0);
                }
                player.m_20256_(motion);
                player.f_19864_ = true;
            }
            if (entity.attackTicks > 5 && player.f_201939_) {
                entity.setAttackState(17);
                if (entity.isFlying()) {
                    entity.setFlying(false);
                }
            }
        }
        if (entity.getAttackState() == 16 && entity.attackTicks > ScyllaAbility.getSkillCoolDown(16)) {
            entity.setAttackState(17);
            if (entity.isFlying()) {
                entity.setFlying(false);
            }
        }
        if (entity.getAttackState() == 17) {
            // empty if block
        }
        if (entity.getAttackState() == 17 && entity.attackTicks > ScyllaAbility.getSkillCoolDown(17)) {
            entity.setAttackState(0);
        }
        if (entity.getAttackState() == 18) {
            int attackshot2;
            int attackshot;
            if (entity.attackTicks == 1) {
                entity.setEye(true);
            }
            double d06 = player.m_20185_() + vecX * 1.1 + (double)f * 0.4;
            double d17 = player.m_20186_() + 0.1;
            d2 = player.m_20189_() + vecZ * 1.1 + (double)f1 * 0.4;
            if (entity.attackTicks >= 24 && entity.attackTicks < 54 && player.m_9236_().f_46443_) {
                for (int i = 0; i < 2; ++i) {
                    player.m_9236_().m_7106_((ParticleOptions)new CircleLightningParticle.CircleData(143, 241, 215), d06, d17, d2, d06 + (double)((player.m_217043_().m_188501_() - 0.5f) * 12.0f), d17, d2 + (double)((player.m_217043_().m_188501_() - 0.5f) * 12.0f));
                }
            }
            if (entity.attackTicks == 25) {
                AOMAbilityConfig.playSound(player, (SoundEvent)ModSounds.HEAVY_SMASH.get(), 0.5f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
                AOMAbilityConfig.playSound(player, (SoundEvent)ModSounds.SUPER_LIGHTNING.get(), 0.2f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)15.0f, (float)0.05f, (int)25, (int)10);
                if (player.m_9236_().f_46443_) {
                    float vec = 1.0f;
                    player.m_9236_().m_7106_((ParticleOptions)new RingParticle.RingData(0.0f, 1.5707964f, 30, 0.56078434f, 0.94509804f, 0.84313726f, 1.0f, 65.0f, false, RingParticle.EnumRingBehavior.GROW), player.m_20185_() + (double)vec * vecX, player.m_20186_() + (double)0.02f, player.m_20189_() + (double)vec * vecZ, 0.0, 0.0, 0.0);
                    player.m_9236_().m_7106_((ParticleOptions)ModParticle.LIGHTNING_EXPLODE.get(), d06, d17, d2, 0.0, 0.0, 0.0);
                } else {
                    for (LivingEntity entity1 : player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(4.0))) {
                        if (player.m_7307_((Entity)entity1) || entity1 instanceof Scylla_Entity || entity1 == player) continue;
                        float playerDamage4 = (float)(AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(EntityTagGenerator.ABYSS, EntityTagGenerator.GENERAL)) + (double)entity.m_21233_() * AOMUtil.cataclysmHpDamage);
                        entity1.m_6469_(CMDamageTypes.causeLightningMobDamage((LivingEntity)player), playerDamage4);
                    }
                }
            }
            if (entity.attackTicks == 53) {
                AOMAbilityConfig.playSound(player, (SoundEvent)ModSounds.HEAVY_SMASH.get(), 0.5f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
                AOMAbilityConfig.playSound(player, (SoundEvent)ModSounds.SUPER_LIGHTNING.get(), 0.2f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)15.0f, (float)0.05f, (int)25, (int)10);
                if (player.m_9236_().f_46443_) {
                    float vec = 1.0f;
                    player.m_9236_().m_7106_((ParticleOptions)new RingParticle.RingData(0.0f, 1.5707964f, 30, 0.56078434f, 0.94509804f, 0.84313726f, 1.0f, 65.0f, false, RingParticle.EnumRingBehavior.GROW), player.m_20185_() + (double)vec * vecX, player.m_20186_() + (double)0.02f, player.m_20189_() + (double)vec * vecZ, 0.0, 0.0, 0.0);
                    player.m_9236_().m_7106_((ParticleOptions)ModParticle.LIGHTNING_EXPLODE.get(), d06, d17, d2, 0.0, 0.0, 0.0);
                } else {
                    for (LivingEntity entity1 : player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(4.0))) {
                        if (player.m_7307_((Entity)entity1) || entity1 instanceof Scylla_Entity || entity1 == player) continue;
                        float playerDamage5 = (float)(AOMUtil.getRealDamage((LivingEntity)player, Arrays.asList(EntityTagGenerator.ABYSS, EntityTagGenerator.GENERAL)) + (double)entity.m_21233_() * AOMUtil.cataclysmHpDamage);
                        entity1.m_6469_(CMDamageTypes.causeLightningMobDamage((LivingEntity)player), playerDamage5);
                    }
                }
            }
            if (entity.attackTicks == (attackshot = 26)) {
                double x = target.m_7096_();
                double z = target.m_7094_();
                double newX = x;
                double newZ = z;
                for (int k = -4; k <= 4; ++k) {
                    double d2_18 = 1.25 * (double)k;
                    float yaw = player.m_146908_() * (float)Math.PI / 180.0f;
                    this.spawnLightning((LivingEntity)player, newX + (double)Mth.m_14089_((float)yaw) * d2_18, newZ + (double)Mth.m_14031_((float)yaw) * d2_18, entity.m_20186_() - 2.0, entity.m_20186_() + 5.0, yaw, 0, 3.0f);
                }
            }
            if (entity.attackTicks == (attackshot2 = 54)) {
                double x = target.m_7096_();
                double z = target.m_7094_();
                double newX = x;
                double newZ = z;
                for (int k = -4; k <= 4; ++k) {
                    double d2_18 = 1.25 * (double)k;
                    float yaw = player.m_146908_() * (float)Math.PI / 180.0f;
                    this.spawnLightning((LivingEntity)player, newX + (double)Mth.m_14089_((float)yaw) * d2_18, newZ + (double)Mth.m_14031_((float)yaw) * d2_18, entity.m_20186_() - 2.0, entity.m_20186_() + 5.0, yaw, 0, 3.0f);
                }
            }
        }
        if (entity.getAttackState() == 18 && entity.attackTicks > ScyllaAbility.getSkillCoolDown(18)) {
            entity.setAttackState(0);
        }
    }

    protected void spawnLightning(LivingEntity player, double x, double z, double minY, double maxY, float rotation, int delay, float size) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = player.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)player.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!player.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = player.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)player.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            float playerDamage = (float)(AOMUtil.getRealDamage(player, Arrays.asList(EntityTagGenerator.ABYSS, EntityTagGenerator.GENERAL)) + 14.0);
            player.m_9236_().m_7967_((Entity)new Lightning_Storm_Entity(player.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, playerDamage, (float)AOMUtil.cataclysmHpDamage, player, size));
        }
    }

    private static void Nimbo(LivingEntity player, float vec, float math, float radius, double EndHeight, int amount, int randamount) {
        if (player.m_9236_().f_46443_) {
            for (int j = 0; j < amount + player.m_217043_().m_188503_(randamount); ++j) {
                float f2 = player.m_217043_().m_188501_() * ((float)Math.PI * 2);
                float f3 = Mth.m_14116_((float)player.m_217043_().m_188501_()) * radius;
                float f = Mth.m_14089_((float)(player.f_20883_ * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(player.f_20883_ * ((float)Math.PI / 180)));
                double theta = (double)player.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.0);
                double vecZ = Math.sin(theta);
                double d0 = player.m_20185_() + vecX * (double)vec + (double)(f * math) + (double)(Mth.m_14089_((float)f2) * f3);
                double d2 = player.m_20186_() + EndHeight;
                double d4 = player.m_20189_() + vecZ * (double)vec + (double)(f1 * math) + (double)(Mth.m_14031_((float)f2) * f3);
                player.m_9236_().m_7107_((ParticleOptions)ModParticle.RAIN_CLOUD.get(), d0, d2, d4, player.m_217043_().m_188583_() * 0.03, player.m_217043_().m_188583_() * 0.01, player.m_217043_().m_188583_() * 0.03);
            }
        }
    }

    private static void CircleLighning(LivingEntity player, float vec, float math, float radius, double EndHeight, int amount, int randamount) {
        if (player.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)(player.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(player.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)player.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.0);
            double vecZ = Math.sin(theta);
            double d0 = player.m_20185_() + vecX * (double)vec + (double)(f * math);
            double d1 = player.m_20186_() + EndHeight;
            double d2 = player.m_20189_() + vecZ * (double)vec + (double)(f1 * math);
            for (int i = 0; i < amount + player.m_217043_().m_188503_(randamount + 1); ++i) {
                double theta2 = player.m_217043_().m_188500_() * 2.0 * Math.PI;
                double phi = player.m_217043_().m_188500_() * Math.PI;
                double posX = (double)radius * Math.sin(phi) * Math.cos(theta2);
                double posY = (double)radius * Math.cos(phi);
                double posZ = (double)radius * Math.sin(phi) * Math.sin(theta2);
                player.m_9236_().m_7106_((ParticleOptions)new CircleLightningParticle.CircleData(143, 241, 215), d0 + posX, d1 + posY, d2 + posZ, d0, d1, d2);
            }
        }
    }

    private static void PullLighning(LivingEntity player, double radius, double vec, float math, double height) {
        if (player.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)(player.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(player.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)player.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.0);
            double vecZ = Math.sin(theta);
            double d0 = player.m_20185_() + vecX * vec + (double)(f * math);
            double d1 = player.m_20186_() + height;
            double d2 = player.m_20189_() + vecZ * vec + (double)(f1 * math);
            player.m_9236_().m_7106_((ParticleOptions)new CircleLightningParticle.CircleData(143, 241, 215), d0 + (double)(player.m_217043_().m_188501_() - 0.5f) * radius, d1 + (double)player.m_217043_().m_188501_() - 0.25, d2 + (double)(player.m_217043_().m_188501_() - 0.5f) * radius, d0, d1, d2);
        }
    }

    private static void Stormknockback(LivingEntity player, float scale, double distance) {
        for (Entity target : AOMUtil.getEntitiesNearby(player, Entity.class, distance, distance, distance, distance)) {
            double d0 = target.m_20185_() - player.m_20185_();
            double d1 = target.m_20189_() - player.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            double power = target.m_6144_() ? (double)(scale / 3.0f) : (double)scale;
            target.m_5997_(d0 / d2 * power, 0.0, d1 / d2 * power);
        }
    }

    private static void SpinDamage(LivingEntity player, float spreadarc, double distance, float mxy, double ab, float damage, float hpdamage, float airborne, int shieldbreakticks) {
        double perpFacing = (double)player.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.m_14165_((double)(distance * spread));
        double minY = player.m_20186_() - 1.0;
        double maxY = player.m_20186_() + (double)mxy;
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = player.m_20185_() + vx * distance;
            double pz = player.m_20189_() + vz * distance;
            AABB selection = new AABB(px - ab, minY, pz - ab, px + ab, maxY, pz + ab);
            for (LivingEntity entity : player.m_9236_().m_45976_(LivingEntity.class, selection)) {
                float playerDamage;
                DamageSource damagesource;
                boolean flag;
                if (player.m_7307_((Entity)entity) || entity == player || !(flag = entity.m_6469_(damagesource = player.m_269291_().m_269333_(player), playerDamage = (float)(AOMUtil.getRealDamage(player, Arrays.asList(EntityTagGenerator.ABYSS, EntityTagGenerator.GENERAL)) * (double)damage + (double)entity.m_21233_() * AOMUtil.cataclysmHpDamage)))) continue;
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)airborne * distance + player.m_9236_().f_46441_.m_188500_() * 0.15, 0.0));
            }
        }
    }

    private static void AreaAttack(LivingEntity player, float range, float height, float arc, float damage, int shieldbreakticks, boolean knockback) {
        for (LivingEntity entityHit : AOMUtil.getEntityLivingBaseNearby(player, range, height, range, range)) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - player.m_20189_(), entityHit.m_20185_() - player.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = player.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - player.m_20189_()) * (entityHit.m_20189_() - player.m_20189_()) + (entityHit.m_20185_() - player.m_20185_()) * (entityHit.m_20185_() - player.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || player.m_7307_((Entity)entityHit) || entityHit instanceof Scylla_Entity || entityHit == player) continue;
            DamageSource damagesource = player.m_269291_().m_269333_(player);
            float playerDamage = (float)(AOMUtil.getRealDamage(player, Arrays.asList(EntityTagGenerator.ABYSS, EntityTagGenerator.GENERAL)) * (double)damage + (double)entityHit.m_21233_() * AOMUtil.cataclysmHpDamage);
            boolean hurt = entityHit.m_6469_(damagesource, playerDamage);
            double d0 = entityHit.m_20185_() - player.m_20185_();
            double d1 = entityHit.m_20189_() - player.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            if (!hurt || !knockback) continue;
            entityHit.m_5997_(d0 / d2 * 1.5, 0.15, d1 / d2 * 1.5);
        }
    }

    private static void SwingParticle(LivingEntity player, double x, double y, double z, double vec, boolean reverse, float scale) {
        if (player.m_9236_().f_46443_) {
            double d0 = player.m_20185_() + x * vec;
            double d1 = player.m_20186_() + (double)(player.m_20206_() / 2.0f) + 0.4;
            double d2 = player.m_20189_() + z * vec;
            float yaw = (float)Math.toRadians(-player.f_20883_ + (float)(reverse ? 180 : 0));
            double lookX = -Math.cos(yaw);
            double lookZ = -Math.sin(yaw);
            float pitch = (float)(reverse ? -1 : 1) * (float)Math.atan2(y, Math.sqrt(lookX * lookX + lookZ * lookZ));
            AOMAbilityConfig.addParticles(player, (ParticleOptions)new Scylla_Swing_Particle.SwingData(player.m_6134_() * scale, yaw, pitch), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void registerAbility(HashMap<String, List<Ability>> ABILITY_MAP) {
        ABILITY_MAP.put(((EntityType)ModEntities.SCYLLA.get()).m_20675_(), Arrays.asList(ScyllaAbilityConfig.scylla_attack(1, ScyllaAbility.getSkillCoolDown(1)), ScyllaAbilityConfig.scylla_attack(7, ScyllaAbility.getSkillCoolDown(7)), ScyllaAbilityConfig.scylla_attack(10, ScyllaAbility.getSkillCoolDown(10)), ScyllaAbilityConfig.scylla_attack(11, ScyllaAbility.getSkillCoolDown(11)), ScyllaAbilityConfig.scylla_attack(15, ScyllaAbility.getSkillCoolDown(15) + ScyllaAbility.getSkillCoolDown(16) + ScyllaAbility.getSkillCoolDown(17)), ScyllaAbilityConfig.scylla_attack(18, ScyllaAbility.getSkillCoolDown(18)), ScyllaAbilityConfig.scylla_attack(9, ScyllaAbility.getSkillCoolDown(9))));
    }
}

