/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.impl.cataclysm;

import com.github.L_Ender.cataclysm.client.particle.RingParticle;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Ender_Guardian_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Void_Vortex_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Void_Rune_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.lionfishapi.server.animation.Animation;
import com.github.L_Ender.lionfishapi.server.animation.AnimationHandler;
import com.github.L_Ender.lionfishapi.server.animation.IAnimatedEntity;
import com.kurome.ageofmythology.bettermorph.impl.BaseIdentity;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.cataclysm.EnderGuardianAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.machine.MachineAbilityConfig;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import com.kurome.ageofmythology.model.Ability;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;

public class EnderGuardianAbility
extends BaseIdentity<Ender_Guardian_Entity> {
    private static final EnderGuardianAbility INSTANCE = new EnderGuardianAbility();
    private Vec3 triggerTarget = new Vec3(0.0, 0.0, 0.0);

    public static EnderGuardianAbility getInstance() {
        return INSTANCE;
    }

    public Vec3 getTriggerTarget(LivingEntity player) {
        if (player.m_20182_().m_82554_(this.triggerTarget) > 100.0) {
            return Utils.raycastForEntity((Level)player.m_9236_(), (Entity)player, (float)100.0f, (boolean)true, (float)0.25f).m_82450_();
        }
        return this.triggerTarget;
    }

    public void setTriggerTarget(Vec3 vec3) {
        this.triggerTarget = vec3;
    }

    @Override
    public void tick(Player player, Ender_Guardian_Entity entity) {
        super.tick(player, entity);
        AnimationHandler.INSTANCE.updateAnimations((Entity)entity);
        this.aiStep(player, entity);
    }

    public void aiStep(Player player, Ender_Guardian_Entity entity) {
        Vec3 target;
        if (entity.getAnimation() == Ender_Guardian_Entity.GUARDIAN_BURST_ATTACK) {
            if (entity.getAnimationTick() == 15) {
                EnderGuardianAbility.Burstparticle((LivingEntity)player);
            }
            if (entity.getAnimationTick() == 27) {
                AOMAbilityConfig.playSound(player, SoundEvents.f_11913_, 1.5f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
                EnderGuardianAbility.AreaAttack((LivingEntity)player, 7.5f, 6.0f, 100.0f, 1.0f, (float)CMConfig.EnderguardianKnockbackHpdamage, 0, 0, 0.0f, true);
            }
            player.m_20334_(0.0, player.m_20184_().f_82480_, 0.0);
        }
        if (entity.getAnimation() == Ender_Guardian_Entity.GUARDIAN_ROCKETPUNCH) {
            if (entity.getAnimationTick() == 24) {
                AOMAbilityConfig.playSound(player, SoundEvents.f_11913_, 1.5f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
            }
            if (entity.getAnimationTick() == 28) {
                EnderGuardianAbility.AreaAttack((LivingEntity)player, 12.0f, 7.0f, 360.0f, 1.25f, (float)CMConfig.EnderguardianRocketPunchHpdamage, 200, 0, 0.0f, true);
            }
            target = this.getTriggerTarget((LivingEntity)player);
            if (entity.getAnimationTick() == 24 && target != null) {
                player.m_20334_((target.f_82479_ - player.m_20185_()) * (double)0.3f, 0.0, (target.f_82481_ - player.m_20189_()) * (double)0.3f);
            }
        }
        if (entity.getAnimation() == Ender_Guardian_Entity.GUARDIAN_HUG_ME) {
            target = this.getTriggerTarget((LivingEntity)player);
            int teleport = 20;
            if (entity.getAnimationTick() == 15) {
                EnderGuardianAbility.Teleportparticle((LivingEntity)player, target.f_82479_, target.f_82480_, target.f_82481_);
            }
            if (entity.getAnimationTick() == 38) {
                EnderGuardianAbility.AreaAttack((LivingEntity)player, 8.0f, 6.0f, 180.0f, 1.0f, (float)CMConfig.EnderguardianTeleportAttackHpdamage, 80, 60, 0.6f, false);
                player.m_5496_(SoundEvents.f_11913_, 1.5f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)15.0f, (float)0.2f, (int)0, (int)10);
            }
            if (entity.getAnimationTick() == teleport) {
                player.m_6021_(target.f_82479_, target.f_82480_, target.f_82481_);
                AOMAbilityConfig.playSound(player, SoundEvents.f_12418_, 1.0f, 1.0f);
            }
        }
        if (entity.getAnimation() == Ender_Guardian_Entity.GUARDIAN_AIR_STRIKE2 && entity.getAnimationTick() == 3) {
            EnderGuardianAbility.MassDestruction((LivingEntity)player, 3.0f, 1.5f, 200);
            AOMAbilityConfig.playSound(player, (SoundEvent)ModSounds.ENDER_GUARDIAN_FIST.get(), 0.5f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
            EnderGuardianAbility.Attackparticle((LivingEntity)player, 2.5f, 1.25f);
            EnderGuardianAbility.Attackparticle((LivingEntity)player, 2.5f, -0.5f);
            ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)20.0f, (float)0.3f, (int)0, (int)20);
            switch (player.m_217043_().m_188503_(3)) {
                case 0: {
                    this.StrikeRune((LivingEntity)player, 8, 0.5);
                    break;
                }
                case 1: {
                    this.StrikeRune((LivingEntity)player, 10, 0.75);
                    break;
                }
                case 2: {
                    this.StrikeRune((LivingEntity)player, 12, 1.0);
                }
            }
        }
        if (entity.getAnimation() == Ender_Guardian_Entity.GUARDIAN_RAGE_UPPERCUT) {
            target = Utils.raycastForEntity((Level)player.m_9236_(), (Entity)player, (float)100.0f, (boolean)true, (float)0.25f).m_82450_();
            if (entity.getAnimationTick() == 27) {
                AOMAbilityConfig.playSound(player, SoundEvents.f_11913_, 1.5f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
                EnderGuardianAbility.AreaAttack((LivingEntity)player, 6.25f, 7.0f, 60.0f, 1.4f, (float)CMConfig.EnderguardianUppercutHpdamage, 150, 60, 0.5f, false);
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)15.0f, (float)0.3f, (int)0, (int)10);
            }
            if (entity.getAnimationTick() == 84) {
                EnderGuardianAbility.RageAttack((LivingEntity)player, target);
                EnderGuardianAbility.AreaAttack((LivingEntity)player, 5.5f, 5.0f, 120.0f, 1.2f, (float)CMConfig.EnderguardianAreaAttackHpdamage, 100, 0, 0.0f, false);
                player.m_5496_(SoundEvents.f_11913_, 1.5f, 1.0f + player.m_217043_().m_188501_() * 0.1f);
                ScreenShake_Entity.ScreenShake((Level)player.m_9236_(), (Vec3)player.m_20182_(), (float)15.0f, (float)0.2f, (int)0, (int)10);
            }
            if (entity.getAnimationTick() == 26) {
                float f1 = (float)Math.cos(Math.toRadians(player.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(player.m_146908_() + 90.0f));
                float r = (float)player.m_20182_().m_82554_(target);
                r = Mth.m_14036_((float)r, (float)0.0f, (float)7.0f);
                player.m_5997_((double)f1 * 0.3 * (double)r, 0.0, (double)f2 * 0.3 * (double)r);
            }
            if (entity.getAnimationTick() > 32 || entity.getAnimationTick() < 26) {
                player.m_20334_(0.0, player.m_20184_().f_82480_, 0.0);
            }
        }
    }

    private static void RageAttack(LivingEntity player, Vec3 target) {
        if (target != null) {
            float[] all;
            double d0 = Math.min(target.f_82480_, player.m_20186_());
            double d1 = Math.max(target.f_82480_, player.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(target.f_82481_ - player.m_20189_()), (double)(target.f_82479_ - player.m_20185_()));
            for (float angle : all = new float[]{f - 0.3f, f - 0.6f, f - 0.9f, f, f + 0.3f, f + 0.6f, f + 0.9f}) {
                for (int l = 0; l < 10; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = (int)(0.75f * (float)l);
                    EnderGuardianAbility.spawnFangs(player, player.m_20185_() + (double)Mth.m_14089_((float)angle) * d2, player.m_20189_() + (double)Mth.m_14031_((float)angle) * d2, d0, d1, angle, j);
                }
            }
        }
    }

    private void StrikeRune(LivingEntity player, int rune, double time) {
        for (int i = 0; i < rune; ++i) {
            float throwAngle = (float)i * (float)Math.PI / (float)(rune / 2);
            for (int k = 0; k < 8; ++k) {
                double d2 = 1.15 * (double)(k + 1);
                int d3 = (int)(time * (double)(k + 1));
                EnderGuardianAbility.spawnFangs(player, player.m_20185_() + (double)Mth.m_14089_((float)throwAngle) * 1.25 * d2, player.m_20189_() + (double)Mth.m_14031_((float)throwAngle) * 1.25 * d2, player.m_20186_(), player.m_20186_() + 2.0, throwAngle, d3);
            }
        }
    }

    private static void spawnFangs(LivingEntity player, double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = player.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)player.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!player.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = player.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)player.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            float playerDamage = (float)(AOMUtil.getRealDamage(player, Arrays.asList(EntityTagGenerator.GENERAL)) + 14.0);
            player.m_9236_().m_7967_((Entity)new Void_Rune_Entity(player.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, playerDamage, player));
        }
    }

    private static void Attackparticle(LivingEntity player, float vec, float math) {
        if (player.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)(player.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(player.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)player.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.0);
            double vecZ = Math.sin(theta);
            for (int i1 = 0; i1 < 80 + player.m_217043_().m_188503_(12); ++i1) {
                double DeltaMovementX = player.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = player.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = player.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * player.f_20883_ + (float)i1;
                double extraX = 1.2 * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 1.2 * (double)Mth.m_14089_((float)angle);
                int hitX = Mth.m_14107_((double)(player.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)player.m_20186_());
                int hitZ = Mth.m_14107_((double)(player.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = player.m_9236_().m_8055_(hit.m_7495_());
                if (block.m_60799_() == RenderShape.INVISIBLE) continue;
                player.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), player.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), player.m_20186_() + extraY, player.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
            player.m_9236_().m_7106_((ParticleOptions)new RingParticle.RingData(0.0f, 1.5707964f, 25, 1.0f, 1.0f, 1.0f, 1.0f, 25.0f, false, RingParticle.EnumRingBehavior.GROW_THEN_SHRINK), player.m_20185_() + (double)vec * vecX + (double)(f * math), player.m_20186_() + (double)0.3f, player.m_20189_() + (double)vec * vecZ + (double)(f1 * math), 0.0, 0.0, 0.0);
        }
    }

    private static void MassDestruction(LivingEntity player, float grow, float damage, int ticks) {
        if (!player.m_9236_().f_46443_) {
            for (LivingEntity entityHit : player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_((double)grow))) {
                if (player.m_7307_((Entity)entityHit) || entityHit instanceof Ender_Guardian_Entity || entityHit == player) continue;
                DamageSource damagesource = player.m_269291_().m_269333_(player);
                float playerDamage = (float)(AOMUtil.getRealDamage(player, Arrays.asList(EntityTagGenerator.GENERAL)) + (double)entityHit.m_21233_() * AOMUtil.cataclysmHpDamage + 14.0);
                entityHit.m_6469_(damagesource, playerDamage);
                EnderGuardianAbility.launch(player, (Entity)entityHit);
            }
        }
    }

    private static void Teleportparticle(LivingEntity player, double x, double y, double z) {
        if (player.m_9236_().f_46443_) {
            double d0 = x;
            double d1 = y;
            double d2 = z;
            if (player.m_9236_().f_46443_) {
                for (int i1 = 0; i1 < 40 + player.m_217043_().m_188503_(12); ++i1) {
                    double DeltaMovementY = player.m_217043_().m_188583_() * 0.07;
                    float angle = (float)Math.PI / 180 * player.f_20883_ + (float)i1;
                    double extraX = 2.0f * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                    double extraY = 0.3f;
                    double extraZ = 2.0f * Mth.m_14089_((float)angle);
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, d0 + extraX, d1 + extraY, d2 + extraZ, 0.0, DeltaMovementY, 0.0);
                }
            }
        }
    }

    private static void spawnVortex(LivingEntity player, double x, double z, double minY, double maxY, float rotation) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = player.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)player.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!player.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = player.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)player.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            player.m_9236_().m_7967_((Entity)new Void_Vortex_Entity(player.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, player, 300));
        }
    }

    private static void AreaAttack(LivingEntity player, float range, float height, float arc, float damage, float hpdamage, int shieldbreakticks, int stunticks, float airborne, boolean knockback) {
        List<LivingEntity> entitiesHit = AOMUtil.getEntityLivingBaseNearby(player, range, height, range, range);
        if (!player.m_9236_().f_46443_) {
            for (LivingEntity entityHit : entitiesHit) {
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - player.m_20189_(), entityHit.m_20185_() - player.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = player.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - player.m_20189_()) * (entityHit.m_20189_() - player.m_20189_()) + (entityHit.m_20185_() - player.m_20185_()) * (entityHit.m_20185_() - player.m_20185_()));
                if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f)) continue;
                DamageSource damagesource = player.m_269291_().m_269333_(player);
                float playerDamage = (float)(AOMUtil.getRealDamage(player, Arrays.asList(EntityTagGenerator.ABYSS, EntityTagGenerator.GENERAL)) + 14.0 + (double)entityHit.m_21233_() * AOMUtil.cataclysmHpDamage);
                boolean flag = entityHit.m_6469_(damagesource, playerDamage);
                if (airborne > 0.0f) {
                    entityHit.m_20256_(entityHit.m_20184_().m_82520_(0.0, (double)airborne, 0.0));
                }
                if (flag && stunticks > 0) {
                    entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), stunticks));
                }
                if (!knockback) continue;
                EnderGuardianAbility.launch(player, (Entity)entityHit);
            }
        }
    }

    private static void launch(LivingEntity player, Entity entityHit) {
        double d0 = entityHit.m_20185_() - player.m_20185_();
        double d1 = entityHit.m_20189_() - player.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entityHit.m_5997_(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    private static void Burstparticle(LivingEntity player) {
        if (player.m_9236_().f_46443_) {
            double d0 = player.m_20185_();
            double d1 = player.m_20186_() + 2.0;
            double d2 = player.m_20189_();
            int size = 5;
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        double d3 = (double)j + (player.m_217043_().m_188500_() - player.m_217043_().m_188500_()) * 0.5;
                        double d4 = (double)i + (player.m_217043_().m_188500_() - player.m_217043_().m_188500_()) * 0.5;
                        double d5 = (double)k + (player.m_217043_().m_188500_() - player.m_217043_().m_188500_()) * 0.5;
                        double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + player.m_217043_().m_188583_() * 0.05;
                        player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123789_, d0, d1, d2, d3 / d6, d4 / d6, d5 / d6);
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2 - 1;
                    }
                }
            }
        }
    }

    public static Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, Ender_Guardian_Entity.GUARDIAN_RIGHT_STRONG_ATTACK, Ender_Guardian_Entity.GUARDIAN_LEFT_STRONG_ATTACK, Ender_Guardian_Entity.GUARDIAN_BURST_ATTACK, Ender_Guardian_Entity.GUARDIAN_UPPERCUT_AND_BULLET, Ender_Guardian_Entity.GUARDIAN_STOMP, Ender_Guardian_Entity.GUARDIAN_RIGHT_ATTACK, Ender_Guardian_Entity.GUARDIAN_LEFT_ATTACK, Ender_Guardian_Entity.GUARDIAN_MASS_DESTRUCTION, Ender_Guardian_Entity.GUARDIAN_RAGE_STOMP, Ender_Guardian_Entity.GUARDIAN_RAGE_UPPERCUT, Ender_Guardian_Entity.GUARDIAN_FALLEN, Ender_Guardian_Entity.GUARDIAN_HUG_ME, Ender_Guardian_Entity.GUARDIAN_AIR_STRIKE1, Ender_Guardian_Entity.GUARDIAN_AIR_STRIKE2, Ender_Guardian_Entity.GUARDIAN_LEFT_SWING, Ender_Guardian_Entity.GUARDIAN_RIGHT_SWING, Ender_Guardian_Entity.GUARDIAN_BLACKHOLE, Ender_Guardian_Entity.GUARDIAN_ROCKETPUNCH};
    }

    public static int getAnimationId(Animation animation) {
        return ArrayUtils.indexOf((Object[])EnderGuardianAbility.getAnimations(), (Object)animation);
    }

    public static void registerAbility(HashMap<String, List<Ability>> ABILITY_MAP) {
        ABILITY_MAP.put(((EntityType)ModEntities.ENDER_GUARDIAN.get()).m_20675_(), Arrays.asList(EnderGuardianAbilityConfig.ender_guardian_attack(EnderGuardianAbility.getAnimationId(Ender_Guardian_Entity.GUARDIAN_BURST_ATTACK)), EnderGuardianAbilityConfig.ender_guardian_attack(EnderGuardianAbility.getAnimationId(Ender_Guardian_Entity.GUARDIAN_ROCKETPUNCH)), EnderGuardianAbilityConfig.ender_guardian_attack(EnderGuardianAbility.getAnimationId(Ender_Guardian_Entity.GUARDIAN_HUG_ME)), EnderGuardianAbilityConfig.ender_guardian_attack(EnderGuardianAbility.getAnimationId(Ender_Guardian_Entity.GUARDIAN_AIR_STRIKE2)), EnderGuardianAbilityConfig.ender_guardian_attack(EnderGuardianAbility.getAnimationId(Ender_Guardian_Entity.GUARDIAN_RAGE_UPPERCUT)), MachineAbilityConfig.VORTEX_PUNCH_SPELL(), AOMAbilityConfig.VOID_ERUPTION_SPELL().setNotSpellingMob()));
    }
}

