/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.impl.alexcaves;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearBombEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.KaijuMob;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.kurome.ageofmythology.api.ITremorzilla;
import com.kurome.ageofmythology.bettermorph.impl.BaseIdentity;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.abyss.AbyssAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.alexscaves.TremorzillaAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.explode.ExplodeAbilityConfig;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import com.kurome.ageofmythology.model.Ability;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import org.apache.commons.lang3.ArrayUtils;

public class TremorzillaAbility
extends BaseIdentity<TremorzillaEntity> {
    private static final TremorzillaAbility INSTANCE = new TremorzillaAbility();

    public static TremorzillaAbility getInstance() {
        return INSTANCE;
    }

    @Override
    public void tick(Player player, TremorzillaEntity entity) {
        Vec3 beamEnd;
        super.tick(player, entity);
        AnimationHandler.INSTANCE.updateAnimations((Entity)entity);
        if (!(entity instanceof ITremorzilla)) {
            return;
        }
        ITremorzilla iTremorzilla = (ITremorzilla)entity;
        entity.legSolver.update((LivingEntity)player, player.f_20883_, entity.m_6134_());
        iTremorzilla.setPreBeamProgress(iTremorzilla.getBeamProgress());
        entity.prevClientBeamEndPosition = entity.clientBeamEndPosition;
        if (entity.isFiring() && iTremorzilla.getBeamProgress() < 5.0f) {
            iTremorzilla.setBeamProgress(iTremorzilla.getBeamProgress() + 1.0f);
        }
        if (!entity.isFiring() && iTremorzilla.getBeamProgress() > 0.0f) {
            iTremorzilla.setBeamProgress(iTremorzilla.getBeamProgress() - 1.0f);
        }
        entity.clientBeamEndPosition = beamEnd = entity.getBeamEndPosition();
        if (entity.isFiring()) {
            TremorzillaAbility.tickBreath((LivingEntity)player, entity);
        }
        if (!entity.isFiring()) {
            if (entity.getAnimation() == TremorzillaEntity.ANIMATION_PREPARE_BREATH && entity.getAnimationTick() > 15 && !entity.isFiring()) {
                iTremorzilla.setMaxBeamTime(100 + player.m_217043_().m_188503_(150));
                entity.beamServerTarget = TremorzillaAbility.createInitialBeamVec((LivingEntity)player);
                entity.setFiring(true);
                entity.setMaxBeamBreakLength(100.0f);
                AOMAbilityConfig.playSound(player, (SoundEvent)ACSoundRegistry.TREMORZILLA_ROAR.get(), 8.0f, 1.0f);
            }
        } else {
            int iterateBy = 1;
            if (!player.m_20160_()) {
                iterateBy = 3;
            }
            iTremorzilla.setBeamTime(iTremorzilla.getBeamTime() + iterateBy);
            if (iTremorzilla.getBeamTime() > iTremorzilla.getMaxBeamTime()) {
                iTremorzilla.setBeamTime(0);
                entity.setFiring(false);
                entity.beamServerTarget = null;
                entity.setBeamEndPosition(null);
                entity.setCharge(0);
            } else {
                TremorzillaAbility.tickBeamTargeting((LivingEntity)player, entity);
                entity.setCharge(1000);
            }
            if (!entity.isPowered()) {
                entity.setCharge(entity.getCharge() + 1);
            }
        }
    }

    private static void tickBeamTargeting(LivingEntity player, TremorzillaEntity entity) {
        Vec3 approach;
        if (!(entity instanceof ITremorzilla)) {
            return;
        }
        ITremorzilla iTremorzilla = (ITremorzilla)entity;
        Vec3 vec3 = Utils.raycastForEntity((Level)player.m_9236_(), (Entity)player, (float)96.0f, (boolean)true, (float)0.25f).m_82450_();
        float time = (float)iTremorzilla.getBeamTime() / (float)iTremorzilla.getMaxBeamTime();
        float accuracy = 1.0f - Math.min(0.75f, time) / 0.75f;
        Vec3 position = vec3;
        Vec3 swingVec = new Vec3(Math.sin((float)player.f_19797_ * 0.2f) * 6.0, 0.0, Math.cos((float)player.f_19797_ * 0.2f) * -6.0).m_82524_((float)Math.toRadians(-player.f_20883_)).m_82490_((double)accuracy);
        entity.beamServerTarget = approach = position.m_82549_(swingVec).m_82546_(vec3).m_82490_((double)0.1f).m_82549_(vec3);
    }

    private static void tickBreath(LivingEntity player, TremorzillaEntity entity) {
        if (!(entity instanceof ITremorzilla)) {
            return;
        }
        ITremorzilla iTremorzilla = (ITremorzilla)entity;
        if (player.m_9236_().f_46443_) {
            Vec3 endBeamPos = entity.getClientBeamEndPosition(1.0f);
            endBeamPos = Utils.raycastForEntity((Level)player.m_9236_(), (Entity)player, (float)10.0f, (boolean)true, (float)0.25f).m_82450_();
            if (endBeamPos != null) {
                ParticleOptions explode;
                Vec3 particleVec = endBeamPos.m_82520_((double)((player.m_217043_().m_188501_() - 0.5f) * 3.0f), (double)((player.m_217043_().m_188501_() - 0.5f) * 3.0f), (double)((player.m_217043_().m_188501_() - 0.5f) * 3.0f));
                ParticleOptions particleOptions = entity.getAltSkin() == 2 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_TECTONIC_EXPLOSION.get() : (explode = entity.getAltSkin() == 1 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_RETRO_EXPLOSION.get() : (ParticleOptions)ACParticleRegistry.TREMORZILLA_EXPLOSION.get());
                ParticleOptions lightning = entity.getAltSkin() == 2 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_TECTONIC_LIGHTNING.get() : (entity.getAltSkin() == 1 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_RETRO_LIGHTNING.get() : (ParticleOptions)ACParticleRegistry.TREMORZILLA_LIGHTNING.get());
                player.m_9236_().m_6485_(explode, true, particleVec.f_82479_, particleVec.f_82480_, particleVec.f_82481_, 0.0, 0.0, 0.0);
                player.m_9236_().m_6485_(lightning, true, player.m_20185_(), player.m_20188_(), player.m_20189_(), 0.0, 0.0, 0.0);
                if (player.m_217043_().m_188501_() < 0.3f) {
                    ParticleOptions proton = entity.getAltSkin() == 2 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_TECTONIC_PROTON.get() : (entity.getAltSkin() == 1 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_RETRO_PROTON.get() : (ParticleOptions)ACParticleRegistry.TREMORZILLA_PROTON.get());
                    player.m_9236_().m_6485_(proton, true, player.m_20185_(), player.m_20188_(), player.m_20189_(), (double)player.m_19879_(), 0.0, 0.0);
                }
            }
        } else {
            Vec3 position = Utils.raycastForEntity((Level)player.m_9236_(), (Entity)player, (float)100.0f, (boolean)true, (float)0.25f).m_82450_();
            Vec3 from = TremorzillaAbility.getBeamShootFrom(player, 1.0f);
            Vec3 normalized = from.m_82549_(position.m_82546_(from).m_82541_().m_82490_(100.0));
            entity.setBeamEndPosition(player.m_9236_().m_45547_(new ClipContext(from, normalized, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_82450_());
            Vec3 endBeamPos = entity.getBeamEndPosition();
            boolean brokenClosestBlocks = false;
            float furthestBlockDist = 10.0f;
            if (endBeamPos != null && iTremorzilla.getBeamTime() % 3 == 0) {
                Vec3 start;
                Vec3 startClip = start = TremorzillaAbility.getBeamShootFrom(player, 1.0f);
                Vec3 viewVec = endBeamPos.m_82546_(start).m_82541_();
                float destructionScale = 5.0f;
                float playerDamage = (float)(AOMUtil.getRealDamage(player, Arrays.asList(EntityTagGenerator.GENERAL)) + 50.0);
                float walkThroughBeam = 1.0f;
                while ((double)walkThroughBeam < entity.getMaxBeamBreakLength()) {
                    startClip = startClip.m_82549_(viewVec.m_82490_((double)(destructionScale * 1.5f)));
                    if (!brokenClosestBlocks) {
                        brokenClosestBlocks = TremorzillaAbility.breakBlocksAround(player, startClip, (Boolean)AlexsCaves.COMMON_CONFIG.devastatingTremorzillaBeam.get() != false ? destructionScale : destructionScale * 0.75f, false, true, 0.08f);
                        furthestBlockDist = (float)startClip.m_82554_(start);
                    }
                    TremorzillaAbility.hurtEntitiesAround(player, startClip, destructionScale + 1.0f, playerDamage, 1.0f, true, true, false);
                    walkThroughBeam += destructionScale;
                }
                TremorzillaAbility.hurtEntitiesAround(player, endBeamPos, 6.0f, playerDamage, 1.0f, true, true, false);
                if (((Boolean)AlexsCaves.COMMON_CONFIG.devastatingTremorzillaBeam.get()).booleanValue() && iTremorzilla.getBeamTime() % 6 == 0) {
                    TremorzillaAbility.breakBlocksAround(player, endBeamPos, 4.0f, false, true, 0.08f);
                }
            }
            if (brokenClosestBlocks) {
                entity.setMaxBeamBreakLength((float)Math.max((double)furthestBlockDist, entity.getMaxBeamBreakLength() - 5.0));
            }
        }
    }

    public static boolean hurtEntitiesAround(LivingEntity player, Vec3 center, float radius, float damageAmount, float knockbackAmount, boolean radioactive, boolean hurtsOtherKaiju, boolean stretchY) {
        AABB aabb = new AABB(center.m_82492_((double)radius, (double)radius, (double)radius), center.m_82520_((double)radius, (double)radius, (double)radius));
        if (stretchY) {
            aabb.m_165887_(player.m_20186_() - 1.0);
            aabb.m_165893_(player.m_20188_() + 3.0);
        }
        boolean flag = false;
        DamageSource damageSource = radioactive ? ACDamageTypes.causeTremorzillaBeamDamage((RegistryAccess)player.m_9236_().m_9598_(), (Entity)player) : player.m_269291_().m_269333_(player);
        for (LivingEntity living : player.m_9236_().m_6443_(LivingEntity.class, aabb, EntitySelector.f_20406_)) {
            if (living.m_7306_((Entity)player) || player.m_7307_((Entity)living) || living.m_6095_() == player.m_6095_()) continue;
            double d = center.f_82479_;
            double d2 = stretchY ? living.m_20186_() : center.f_82480_;
            if (!(living.m_20275_(d, d2, center.f_82481_) <= (double)(radius * radius)) || radioactive || !hurtsOtherKaiju || !living.m_6469_(damageSource, damageAmount)) continue;
            flag = true;
            TremorzillaAbility.knockbackTarget(player, (Entity)living, knockbackAmount, player.m_20185_() - living.m_20185_(), player.m_20189_() - living.m_20189_(), !(living instanceof KaijuMob));
            if (!radioactive) continue;
            living.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), 6000, 2));
        }
        return flag;
    }

    public static void knockbackTarget(LivingEntity player, Entity target, double strength, double x, double z, boolean ignoreResistance) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)player, (float)((float)strength), (double)x, (double)z);
        if (!event.isCanceled()) {
            strength = event.getStrength();
            x = event.getRatioX();
            z = event.getRatioZ();
            if (!ignoreResistance) {
                strength *= 1.0 - player.m_21133_(Attributes.f_22278_);
            }
            if (!(strength <= 0.0)) {
                player.f_19812_ = true;
                Vec3 vec3 = player.m_20184_();
                Vec3 vec31 = new Vec3(x, 0.0, z).m_82541_().m_82490_(strength);
                target.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, player.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0 + strength) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
            }
        }
    }

    public static boolean breakBlocksAround(LivingEntity player, Vec3 center, float radius, boolean square, boolean triggerExplosions, float dropChance) {
        if (!player.m_6162_() && ForgeEventFactory.getMobGriefingEvent((Level)player.m_9236_(), (Entity)player) && !player.m_9236_().f_46443_) {
            boolean flag = false;
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)(center.f_82479_ - (double)radius)), (int)Mth.m_14107_((double)(center.f_82480_ - (double)radius)), (int)Mth.m_14107_((double)(center.f_82481_ - (double)radius)), (int)Mth.m_14107_((double)(center.f_82479_ + (double)radius)), (int)Mth.m_14107_((double)(center.f_82480_ + (double)radius)), (int)Mth.m_14107_((double)(center.f_82481_ + (double)radius)))) {
                BlockState blockstate = player.m_9236_().m_8055_(blockpos);
                boolean nuke = blockstate.m_60713_((Block)ACBlockRegistry.NUCLEAR_BOMB.get());
                if (blockstate.m_204336_(ACTagRegistry.NUKE_PROOF) || !blockstate.m_280555_() || !(blockstate.m_60734_().m_7325_() <= 15.0f) && !nuke || !square && !(blockpos.m_203198_(center.f_82479_, center.f_82480_, center.f_82481_) < (double)(radius * radius))) continue;
                if (player.m_217043_().m_188501_() <= dropChance && !nuke) {
                    player.m_9236_().m_46961_(blockpos, false);
                } else {
                    Explosion dummyExplosion = new Explosion(player.m_9236_(), (Entity)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), 10.0f, List.of());
                    blockstate.onBlockExploded(player.m_9236_(), blockpos, dummyExplosion);
                }
                if (triggerExplosions && nuke) {
                    NuclearBombEntity bomb = (NuclearBombEntity)((EntityType)ACEntityRegistry.NUCLEAR_BOMB.get()).m_20615_(player.m_9236_());
                    bomb.m_6034_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5);
                    bomb.setTime(300);
                    player.m_9236_().m_7967_((Entity)bomb);
                }
                flag = true;
            }
            return flag;
        }
        return false;
    }

    private static Vec3 createInitialBeamVec(LivingEntity player) {
        Vec3 vec3;
        Entity entity;
        LivingEntity target = null;
        HitResult raycastForEntity = Utils.raycastForEntity((Level)player.m_9236_(), (Entity)player, (float)10.0f, (boolean)true, (float)0.25f);
        if (raycastForEntity.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)raycastForEntity).m_82443_()) instanceof LivingEntity) {
            LivingEntity attackTarget;
            target = attackTarget = (LivingEntity)entity;
        }
        if (target != null && target.m_6084_()) {
            Vec3 randomRot = new Vec3((double)(-100.0f + player.m_217043_().m_188501_() * 200.0f), 0.0, (double)(15.0f + 15.0f * player.m_217043_().m_188501_())).m_82524_((float)Math.toRadians(-player.f_20883_ + 50.0f - player.m_217043_().m_188501_() * 100.0f));
            Vec3 position = target instanceof KaijuMob ? target.m_146892_() : target.m_20182_();
            return position.m_82549_(randomRot);
        }
        if (player.m_20160_()) {
            vec3 = new Vec3(0.0, 0.0, 10.0).m_82524_((float)Math.toRadians(-player.f_20883_));
            return TremorzillaAbility.getBeamShootFrom(player, 1.0f).m_82549_(vec3);
        }
        vec3 = new Vec3(0.0, player.m_217043_().m_188499_() ? 100.0 : 20.0, 6.0).m_82524_((float)Math.toRadians(-player.f_20883_));
        return TremorzillaAbility.getBeamShootFrom(player, 1.0f).m_82549_(vec3);
    }

    public static Vec3 getBeamShootFrom(LivingEntity player, float partialTicks) {
        return player.m_20318_(partialTicks).m_82520_(0.0, (double)(7.5f * player.m_6134_()), 0.0);
    }

    public static Animation[] getAnimations() {
        return new Animation[]{TremorzillaEntity.ANIMATION_SPEAK, TremorzillaEntity.ANIMATION_ROAR_1, TremorzillaEntity.ANIMATION_ROAR_2, TremorzillaEntity.ANIMATION_RIGHT_SCRATCH, TremorzillaEntity.ANIMATION_LEFT_SCRATCH, TremorzillaEntity.ANIMATION_RIGHT_TAIL, TremorzillaEntity.ANIMATION_LEFT_TAIL, TremorzillaEntity.ANIMATION_RIGHT_STOMP, TremorzillaEntity.ANIMATION_LEFT_STOMP, TremorzillaEntity.ANIMATION_BITE, TremorzillaEntity.ANIMATION_PREPARE_BREATH, TremorzillaEntity.ANIMATION_CHEW};
    }

    public static int getAnimationId(Animation animation) {
        return ArrayUtils.indexOf((Object[])TremorzillaAbility.getAnimations(), (Object)animation);
    }

    public static void registerAbility(HashMap<String, List<Ability>> ABILITY_MAP) {
        ABILITY_MAP.put(((EntityType)ACEntityRegistry.TREMORZILLA.get()).m_20675_(), Arrays.asList(TremorzillaAbilityConfig.tremorzilla_attack(TremorzillaAbility.getAnimationId(TremorzillaEntity.ANIMATION_PREPARE_BREATH)), AbyssAbilityConfig.ABYSSAL_BLAST_SPELL(), ExplodeAbilityConfig.cursed_blast_spell(), ExplodeAbilityConfig.lob_creeper_spell(), ExplodeAbilityConfig.chain_creeper_spell(), ExplodeAbilityConfig.earthquake_spell(), ExplodeAbilityConfig.violent_skreech_spell(), ExplodeAbilityConfig.acid_orb_spell()));
    }
}

