/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.impl.alexcaves;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorsaurusEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.kurome.ageofmythology.bettermorph.impl.BaseIdentity;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.alexscaves.TremorsaurusAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.animation.AnimationAbilityConfig;
import com.kurome.ageofmythology.model.Ability;
import com.kurome.ageofmythology.utils.MorphUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.ArrayUtils;

public class TremorsaurusAbility
extends BaseIdentity<TremorsaurusEntity> {
    private static final TremorsaurusAbility INSTANCE = new TremorsaurusAbility();

    public static TremorsaurusAbility getInstance() {
        return INSTANCE;
    }

    @Override
    public void tick(Player player, TremorsaurusEntity entity) {
        super.tick(player, entity);
        entity.f_20883_ = Mth.m_14148_((float)player.f_20884_, (float)player.f_20883_, (float)entity.m_21529_());
        entity.legSolver.update((LivingEntity)entity, player.f_20883_, entity.m_6134_());
        AnimationHandler.INSTANCE.updateAnimations((Entity)entity);
        entity.prevDanceProgress = entity.danceProgress;
        if (entity.isDancing() && entity.danceProgress < 5.0f) {
            entity.danceProgress += 1.0f;
        }
        if (!entity.isDancing() && entity.danceProgress > 0.0f) {
            entity.danceProgress -= 1.0f;
        }
        if (entity.getAnimation() == TremorsaurusEntity.ANIMATION_ROAR && entity.getAnimationTick() == 5) {
            AOMAbilityConfig.playSound(player, (SoundEvent)ACSoundRegistry.TREMORSAURUS_ROAR.get(), 4.0f, 1.0f);
            MorphUtil.ScreenShake((LivingEntity)player);
        }
        if (entity.getAnimation() == TremorsaurusEntity.ANIMATION_ROAR && entity.getAnimationTick() >= 5 && entity.getAnimationTick() <= 40 && entity.getAnimationTick() % 5 == 0) {
            MorphUtil.AreaAttack((LivingEntity)player, 8.25f, 3.25f, 180.0f, false, 10.0);
            if (player.m_9236_().f_46443_) {
                TremorsaurusAbility.shakeWater((LivingEntity)player);
            }
        }
    }

    private static void shakeWater(LivingEntity player) {
        if (player.m_9236_().f_46443_) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int radius = 8;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + z * z > radius * radius) continue;
                    mutableBlockPos.m_122169_(player.m_20185_() + (double)x, player.m_20186_() + 5.0, player.m_20189_() + (double)z);
                    while (mutableBlockPos.m_123342_() > player.m_9236_().m_141937_() && player.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60795_()) {
                        mutableBlockPos.m_122173_(Direction.DOWN);
                    }
                    float water = TremorsaurusAbility.getWaterLevelForBlock(player, player.m_9236_(), (BlockPos)mutableBlockPos);
                    if (!(water > 0.0f)) continue;
                    player.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.WATER_TREMOR.get(), (double)((float)mutableBlockPos.m_123341_() + 0.5f), (double)((float)mutableBlockPos.m_123342_() + water) + 0.01, (double)((float)mutableBlockPos.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static float getWaterLevelForBlock(LivingEntity player, Level level, BlockPos pos) {
        BlockState state = player.m_9236_().m_8055_(pos);
        if (state.m_60713_(Blocks.f_152476_)) {
            return (6.0f + (float)((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue() * 3.0f) / 16.0f;
        }
        return player.m_217043_().m_188501_() < 0.33f && state.m_60819_().m_205070_(FluidTags.f_13131_) ? state.m_60819_().m_76155_((BlockGetter)level, pos) : 0.0f;
    }

    public static Animation[] getAnimations() {
        return new Animation[]{TremorsaurusEntity.ANIMATION_SNIFF, TremorsaurusEntity.ANIMATION_SPEAK, TremorsaurusEntity.ANIMATION_ROAR, TremorsaurusEntity.ANIMATION_BITE, TremorsaurusEntity.ANIMATION_SHAKE_PREY};
    }

    public static int getAnimationId(Animation animation) {
        return ArrayUtils.indexOf((Object[])TremorsaurusAbility.getAnimations(), (Object)animation);
    }

    public static void registerAbility(HashMap<String, List<Ability>> ABILITY_MAP) {
        ABILITY_MAP.put(((EntityType)ACEntityRegistry.TREMORSAURUS.get()).m_20675_(), Arrays.asList(TremorsaurusAbilityConfig.tremorsaurus_attack(TremorsaurusAbility.getAnimationId(TremorsaurusEntity.ANIMATION_ROAR)), AnimationAbilityConfig.stop_dance(), AnimationAbilityConfig.dance()));
    }
}

