/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.impl.alexcaves;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.RelicheirusEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.kurome.ageofmythology.bettermorph.impl.BaseIdentity;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.alexscaves.RelicheirusAbilityConfig;
import com.kurome.ageofmythology.config.ability_config.animation.AnimationAbilityConfig;
import com.kurome.ageofmythology.model.Ability;
import com.kurome.ageofmythology.utils.MorphUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;

public class RelicheirusAbility
extends BaseIdentity<RelicheirusEntity> {
    private static final RelicheirusAbility INSTANCE = new RelicheirusAbility();

    public static RelicheirusAbility getInstance() {
        return INSTANCE;
    }

    @Override
    public void tick(Player player, RelicheirusEntity entity) {
        super.tick(player, entity);
        AnimationHandler.INSTANCE.updateAnimations((Entity)entity);
        entity.prevDanceProgress = entity.danceProgress;
        if (entity.isDancing() && entity.danceProgress < 5.0f) {
            entity.danceProgress += 1.0f;
        }
        if (!entity.isDancing() && entity.danceProgress > 0.0f) {
            entity.danceProgress -= 1.0f;
        }
        if ((entity.getAnimation() == RelicheirusEntity.ANIMATION_MELEE_SLASH_1 || entity.getAnimation() == RelicheirusEntity.ANIMATION_MELEE_SLASH_2) && entity.getAnimationTick() > 7 && entity.getAnimationTick() <= 10) {
            MorphUtil.AreaAttack((LivingEntity)player, 6.25f, 2.25f, 180.0f, true, new Vec3(8.0, 4.0, 8.0), 8.0);
            AOMAbilityConfig.playSound(player, (SoundEvent)ACSoundRegistry.RELICHEIRUS_SCRATCH.get());
        }
    }

    public static Animation[] getAnimations() {
        return new Animation[]{RelicheirusEntity.ANIMATION_SPEAK_1, RelicheirusEntity.ANIMATION_SPEAK_2, RelicheirusEntity.ANIMATION_EAT_TREE, RelicheirusEntity.ANIMATION_EAT_TRILOCARIS, RelicheirusEntity.ANIMATION_PUSH_TREE, RelicheirusEntity.ANIMATION_SCRATCH_1, RelicheirusEntity.ANIMATION_SCRATCH_2, RelicheirusEntity.ANIMATION_SHAKE, RelicheirusEntity.ANIMATION_MELEE_SLASH_1, RelicheirusEntity.ANIMATION_MELEE_SLASH_2};
    }

    public static int getAnimationId(Animation animation) {
        return ArrayUtils.indexOf((Object[])RelicheirusAbility.getAnimations(), (Object)animation);
    }

    public static void registerAbility(HashMap<String, List<Ability>> ABILITY_MAP) {
        ABILITY_MAP.put(((EntityType)ACEntityRegistry.RELICHEIRUS.get()).m_20675_(), Arrays.asList(RelicheirusAbilityConfig.relicheirus_attack(RelicheirusAbility.getAnimationId(RelicheirusEntity.ANIMATION_MELEE_SLASH_1)), RelicheirusAbilityConfig.relicheirus_attack(RelicheirusAbility.getAnimationId(RelicheirusEntity.ANIMATION_MELEE_SLASH_2)), AnimationAbilityConfig.stop_dance(), AnimationAbilityConfig.dance()));
    }
}

