/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.impl;

import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.kurome.ageofmythology.bettermorph.impl.general.TimeEventScheduler;
import com.kurome.ageofmythology.bettermorph.impl.general.TimeExecutor;
import com.kurome.ageofmythology.capability.PlayerDataCapability;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.model.Ability;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.general.ClientSyncWheelSelection;
import com.kurome.ageofmythology.net.goety.ServerSyncApostle;
import com.mega.revelationfix.common.entity.binding.RevelationCageEntity;
import com.mojang.logging.LogUtils;
import dev.architectury.event.EventResult;
import java.util.List;
import java.util.function.Consumer;
import liushuangwuyin.bettermorph.Identity;
import liushuangwuyin.bettermorph.api.IdentityTickHandler;
import liushuangwuyin.bettermorph.api.PlayerAbilities;
import liushuangwuyin.bettermorph.api.PlayerIdentity;
import liushuangwuyin.bettermorph.api.event.IdentityChangedCallback;
import liushuangwuyin.bettermorph.api.event.IdentitySwapCallback;
import liushuangwuyin.bettermorph.forge.ability.impl.ForgeIdentityAbility;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import z1gned.goetyrevelation.util.ApollyonAbilityHelper;

public abstract class BaseIdentity<T extends LivingEntity>
extends ForgeIdentityAbility<T>
implements IdentityTickHandler<T> {
    public final TimeEventScheduler scheduler = new TimeEventScheduler();

    public void delayExecute(TimeExecutor executor) {
        this.scheduler.addExecutor(executor);
    }

    public void delayExecute(Consumer<TimeExecutor> runnable, int delay, int duration, int triggerTick) {
        this.scheduler.addExecutor(new TimeExecutor(runnable, delay, duration, triggerTick));
    }

    public void delayExecute(Consumer<TimeExecutor> runnable, int delay) {
        this.scheduler.addExecutor(new TimeExecutor(runnable, delay));
    }

    public void onUse(Player player, T t, Level level) {
        EntityType type = t != null ? t.m_6095_() : EntityType.f_20532_;
        Ability ability = AOMAbilityConfig.getAbility(type.m_20675_(), PlayerAbilities.getSelectAbility((Player)player), player);
        this.delayExecute(executor -> {
            ability.abilityConsumer.accept(level, (LivingEntity)t, player);
            ability.abilityConsumerQuad.accept(level, (LivingEntity)t, player, (TimeExecutor)executor);
        }, ability.delay, ability.duration, ability.triggerTick);
        this.delayExecute(executor -> ability.animationConsumer.accept(level, (LivingEntity)t, player), ability.animationDelay);
        this.delayExecute(executor -> ability.animationFinishCallbackConsumer.accept(level, (LivingEntity)t, player), ability.callBackDelay);
    }

    public void tick(Player player, T t) {
        if (!player.m_9236_().f_46443_) {
            this.scheduler.timeTick();
        }
    }

    public int getCooldown(Player player, T entity) {
        EntityType type = entity != null ? entity.m_6095_() : EntityType.f_20532_;
        int configCooldown = Identity.getCooldown((EntityType)type) + AOMUtil.getCoolDown(player) * 20;
        Ability ability = AOMAbilityConfig.getAbility(type.m_20675_(), PlayerAbilities.getSelectAbility((Player)player), player);
        int abilityCooldown = ability.getAbilityCooldown() + AOMUtil.getCoolDown(player) * 20;
        if (ability.type == Ability.AbilityType.EXPLODE) {
            abilityCooldown += (int)AOMUtil.getExplosionCoolDown(player) * 20;
        }
        if (ability.type == Ability.AbilityType.ABYSS) {
            abilityCooldown -= (int)AOMUtil.getAbyssLevel(player) * 20 / 5;
        }
        if (ability.type == Ability.AbilityType.MACHINE) {
            abilityCooldown -= (int)AOMUtil.getMachineLevel(player) * 20 / 5;
        }
        return Math.max(20, Math.max(configCooldown, abilityCooldown));
    }

    public static void registerSwapCallback() {
        IdentitySwapCallback.EVENT.register((player, morph) -> {
            LivingEntity entity = PlayerIdentity.getIdentity((Player)player);
            if (entity == null && morph != null || entity != null && morph == null || entity != null && morph != null && entity.m_6095_() != morph.m_6095_()) {
                Messages.sendToPlayer(new ClientSyncWheelSelection(ClientSyncWheelSelection.WheelType.ABILITY_WHEEL.getId(), 0), player);
                AOMAbilityConfig.addParticlesAroundSelf((LivingEntity)player, (ParticleOptions)ParticleTypes.f_123796_);
                try {
                    List cageList = player.m_9236_().m_6443_(RevelationCageEntity.class, player.m_20191_().m_82377_(3.0, 3.0, 3.0), e -> true);
                    if (!cageList.isEmpty()) {
                        cageList.forEach(Entity::m_146870_);
                    }
                }
                catch (Exception e2) {
                    LogUtils.getLogger().error("RevelationCageEntity catch error %s".formatted(e2.toString()));
                }
            }
            return EventResult.pass();
        });
    }

    public static void registerChangedCallback() {
        IdentityChangedCallback.EVENT.register((player, morph) -> {
            if (player != null) {
                if (player.m_9236_().f_46443_ && morph instanceof EntityDragonBase) {
                    EntityDragonBase dragon = (EntityDragonBase)morph;
                    player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                        dragon.setAgeInDays(data.getDragonAge());
                        dragon.m_20011_(dragon.m_20191_());
                        dragon.m_6210_();
                    });
                }
                if (morph instanceof Apostle) {
                    Apostle apostle = (Apostle)morph;
                    player.getCapability(PlayerDataCapability.INSTANCE).ifPresent(data -> {
                        if (data.getExtraInfo().apostle_type == 1 && apostle instanceof ApollyonAbilityHelper) {
                            ApollyonAbilityHelper helper = (ApollyonAbilityHelper)apostle;
                            CompoundTag nbt = apostle.m_20240_(new CompoundTag());
                            if (!nbt.m_128471_("isApollyon")) {
                                nbt.m_128379_("isApollyon", true);
                            }
                            apostle.m_20258_(nbt);
                            helper.allTitlesApostle_1_20_1$setApollyon(true);
                            if (player.m_9236_().f_46443_) {
                                Messages.sendToServer(new ServerSyncApostle(1));
                            }
                        }
                    });
                }
            }
            return EventResult.pass();
        });
    }
}

