/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.gui.morph_info;

import com.kurome.ageofmythology.bettermorph.gui.BaseTextScreen;
import com.kurome.ageofmythology.bettermorph.gui.GuiManager;
import com.kurome.ageofmythology.bettermorph.gui.morph_info.MorphFeature;
import com.kurome.ageofmythology.bettermorph.gui.morph_info.MorphInfo;
import com.kurome.ageofmythology.config.AOMMorphInfoConfig;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import com.kurome.ageofmythology.model.Ability;
import com.kurome.ageofmythology.model.MorphData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import java.util.ArrayList;
import java.util.List;
import liushuangwuyin.bettermorph.api.PlayerIdentity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;

public class MorphInfoScreen
extends BaseTextScreen {
    private final int OFFSET_X = 8;
    private static final int FLOAT_STYLE = 0;
    private static final int PERCENT_STYLE = 1;
    private static final int TEN_TIMES = 2;
    private int drawX = 0;
    private int drawY = 0;

    protected MorphInfoScreen(Component title) {
        super(title);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        new GuiManager().registerButtonGUI(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, new GuiManager.GuiInfo(this.leftPos, this.topPos, this), GuiManager.MORPH_INFO_INDEX);
    }

    @Override
    public void m_88315_(GuiGraphics g, int mx, int my, float ptick) {
        super.m_88315_(g, mx, my, ptick);
        this.renderMorphInfo(g, mx, my);
        this.renderMorphEntity(g, mx, my);
    }

    private void renderMorphInfo(GuiGraphics g, int mx, int my) {
        List<MorphFeature> features;
        this.drawX = this.leftPos + 8;
        this.drawY = this.topPos + 6;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        LivingEntity entity = PlayerIdentity.getIdentity((Player)player);
        String toolTip = null;
        MorphInfo morphInfo = entity == null ? AOMMorphInfoConfig.defaultMorphInfo : AOMMorphInfoConfig.getMorphInfo(entity.m_6095_());
        String entityName = entity == null ? "ageofmythology.entity.type.player" : morphInfo.name;
        MutableComponent component = Component.m_237110_((String)"ageofmythology.entity.type.desc", (Object[])new Object[]{Component.m_237115_((String)entityName)});
        g.m_280614_(this.f_96547_, (Component)component, this.drawX, this.drawY, 0, false);
        if (mx > this.drawX && mx < this.drawX + this.f_96547_.m_92852_((FormattedText)component) && my > this.drawY && my < this.drawY + 10) {
            toolTip = "ageofmythology.entity.type.desc1";
        }
        this.drawY += 10;
        String faction = "ageofmythology.entity.faction.null";
        if (entity != null) {
            if (entity.m_6095_().m_204039_(EntityTagGenerator.FACTION_ILLAGER)) {
                faction = "ageofmythology.entity.faction.faction_illager";
            } else if (entity.m_6095_().m_204039_(EntityTagGenerator.FACTION_CREEPER)) {
                faction = "ageofmythology.entity.faction.faction_creeper";
            } else if (entity.m_6095_().m_204039_(EntityTagGenerator.FACTION_UNDEAD)) {
                faction = "ageofmythology.entity.faction.faction_undead";
            } else if (entity.m_6095_().m_204039_(EntityTagGenerator.FACTION_BOSS)) {
                faction = "ageofmythology.entity.faction.faction_boss";
            } else if (entity.m_6095_().m_204039_(EntityTagGenerator.FACTION_SPIDER)) {
                faction = "ageofmythology.entity.faction.faction_spider";
            } else if (entity.m_6095_().m_204039_(EntityTagGenerator.FACTION_ABYSS)) {
                faction = "ageofmythology.entity.faction.faction_abyss";
            } else if (entity.m_6095_().m_204039_(EntityTagGenerator.FACTION_CUTE)) {
                faction = "ageofmythology.entity.faction.faction_cute";
            }
        }
        component = Component.m_237110_((String)"ageofmythology.entity.faction.desc", (Object[])new Object[]{Component.m_237115_((String)faction)});
        g.m_280614_(this.f_96547_, (Component)component, this.drawX, this.drawY, 0, false);
        if (mx > this.drawX && mx < this.drawX + this.f_96547_.m_92852_((FormattedText)component) && my > this.drawY && my < this.drawY + 10) {
            toolTip = "ageofmythology.entity.faction.desc1";
            if (entity != null) {
                if (entity.m_6095_().m_204039_(EntityTagGenerator.FACTION_BOSS)) {
                    toolTip = "ageofmythology.entity.faction.desc.boss";
                } else if (entity.m_6095_().m_204039_(EntityTagGenerator.FACTION_CUTE)) {
                    toolTip = "ageofmythology.entity.faction.desc.cute";
                }
            }
        }
        if (entity != null) {
            if (!AOMUtil.TAGS.get().keySet().stream().anyMatch(entityTypeTagKey -> entity.m_6095_().m_204039_(entityTypeTagKey))) {
                this.drawY += 10;
                component = Component.m_237115_((String)"ageofmythology.entity.school.none");
                g.m_280614_(this.f_96547_, (Component)component, this.drawX, this.drawY, 0, false);
            } else {
                boolean flag = false;
                for (TagKey<EntityType<?>> s : AOMUtil.TAGS.get().keySet()) {
                    if (!entity.m_6095_().m_204039_(s)) continue;
                    this.drawY += 10;
                    if (!flag) {
                        component = Component.m_237110_((String)"ageofmythology.entity.school", (Object[])new Object[]{Component.m_237115_((String)"ageofmythology.entity.school.desc.%s".formatted(s.f_203868_().m_135815_()))});
                        g.m_280614_(this.f_96547_, (Component)component, this.drawX, this.drawY, 0, false);
                        flag = true;
                        continue;
                    }
                    component = Component.m_237115_((String)"ageofmythology.entity.school.desc.%s".formatted(s.f_203868_().m_135815_()));
                    g.m_280614_(this.f_96547_, (Component)component, this.drawX + 24, this.drawY, 0, false);
                }
            }
        }
        if ((features = morphInfo.getFeature()).isEmpty()) {
            this.drawY += 10;
            component = Component.m_237115_((String)"ageofmythology.entity.type.feature.none");
            g.m_280614_(this.f_96547_, (Component)component, this.drawX, this.drawY, 0, false);
        }
        for (int i = 0; i < features.size(); ++i) {
            this.drawY += 10;
            MorphFeature feature = features.get(i);
            if (i == 0) {
                component = Component.m_237115_((String)"ageofmythology.entity.type.feature").m_7220_((Component)Component.m_237115_((String)feature.name));
                g.m_280614_(this.f_96547_, (Component)component, this.drawX, this.drawY, 0, false);
                if (mx <= this.drawX || mx >= this.drawX + this.f_96547_.m_92852_((FormattedText)component) || my <= this.drawY || my >= this.drawY + 10) continue;
                toolTip = feature.desc;
                continue;
            }
            component = Component.m_237115_((String)feature.name);
            g.m_280614_(this.f_96547_, (Component)component, this.drawX + 24, this.drawY, 0, false);
            if (mx <= this.drawX + 24 || mx >= this.drawX + 24 + this.f_96547_.m_92852_((FormattedText)component) || my <= this.drawY || my >= this.drawY + 10) continue;
            toolTip = feature.desc;
        }
        this.drawX = this.leftPos + 8;
        List<Ability> abilities = morphInfo.skills;
        for (int i = 0; i < abilities.size(); ++i) {
            this.drawY += 10;
            MorphData abilityData = abilities.get((int)i).abilityData;
            if (i == 0) {
                component = Component.m_237115_((String)"ageofmythology.entity.type.ability").m_7220_((Component)abilityData.title);
                g.m_280614_(this.f_96547_, (Component)component, this.drawX, this.drawY, 0, false);
                if (mx <= this.drawX || mx >= this.drawX + this.f_96547_.m_92852_((FormattedText)component) || my <= this.drawY || my >= this.drawY + 10) continue;
                toolTip = abilityData.spell;
                continue;
            }
            component = abilityData.title;
            g.m_280614_(this.f_96547_, (Component)component, this.drawX + 24, this.drawY, 0, false);
            if (mx <= this.drawX + 24 || mx >= this.drawX + 24 + this.f_96547_.m_92852_((FormattedText)component) || my <= this.drawY || my >= this.drawY + 10) continue;
            toolTip = abilityData.spell;
        }
        this.renderTooltip(g, toolTip, mx, my);
    }

    private void renderTooltip(GuiGraphics g, Object tooltip, int mx, int my) {
        if (tooltip == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (tooltip instanceof String) {
            String str = (String)tooltip;
            g.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)str), mx, my);
        } else if (tooltip instanceof Component) {
            Component component = (Component)tooltip;
            g.m_280557_(this.f_96547_, component, mx, my);
        } else if (tooltip instanceof AbstractSpell) {
            AbstractSpell spell = (AbstractSpell)tooltip;
            int spell_level = AOMUtil.getSpellLevel((LivingEntity)player);
            ArrayList arrayList = new ArrayList(spell.getUniqueInfo(spell_level, (LivingEntity)player));
        }
    }

    private void renderMorphEntity(GuiGraphics g, int mx, int my) {
        int i = this.leftPos;
        int j = this.topPos;
        float renderOffsetX = (float)((double)this.f_96543_ * 0.85);
        float renderOffsetY = (float)((double)this.f_96544_ * 0.75);
        float renderEyeOffsetY = (float)((double)this.f_96544_ * 0.5);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        LivingEntity entity = PlayerIdentity.getIdentity((Player)player);
        if (entity == null) {
            return;
        }
        int size = (int)((double)this.f_96543_ * 0.25 * (double)(1.0f / Math.max(entity.m_20206_(), entity.m_20205_())));
        InventoryScreen.m_274545_((GuiGraphics)g, (int)((int)renderOffsetX), (int)((int)renderOffsetY), (int)size, (float)-10.0f, (float)-10.0f, (LivingEntity)entity);
    }

    public record AttributeInfo(Attribute attribute, int showStyle) {
    }
}

