/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.gui.morph_info;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.bettermorph.gui.morph_info.MorphFeature;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.data.tag.EntityTagGenerator;
import com.kurome.ageofmythology.model.Ability;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liushuangwuyin.bettermorph.registry.IdentityEntityTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class MorphInfo {
    public String name;
    public EntityType<?> type;
    public String description = "";
    private List<MorphFeature> feature = new ArrayList<MorphFeature>();
    public List<Ability> skills = new ArrayList<Ability>();
    public Map<String, String> skillHoverMap = new HashMap<String, String>();
    public List<String> extra = new ArrayList<String>();

    public MorphInfo(EntityType<?> type) {
        this.name = type.m_20675_();
        this.type = type;
        this.update();
    }

    public MorphInfo addDescription(String description) {
        this.description = description;
        return this;
    }

    public MorphInfo addSkills(List<Ability> skills) {
        this.skills = skills;
        return this;
    }

    public MorphInfo addSkillHoverMap(Map<String, String> skillHoverMap) {
        this.skillHoverMap = skillHoverMap;
        return this;
    }

    public MorphInfo addExtra(List<String> extra) {
        this.extra = extra;
        return this;
    }

    public void update() {
        if (this.type == null) {
            return;
        }
        this.updateEntityFeature(this.type);
        this.updateSkills();
    }

    public List<MorphFeature> getFeature() {
        this.update();
        return this.feature;
    }

    private void updateSkills() {
        List<Ability> abilityList = AOMAbilityConfig.getAbilityList(this.type.m_20675_(), AgeOfMythologyMod.PROXY.getClientPlayer());
        if (abilityList == null) {
            this.skills = new ArrayList<Ability>();
            return;
        }
        this.skills = abilityList;
    }

    private void updateEntityFeature(LivingEntity entity) {
        this.updateEntityFeature(entity.m_6095_());
    }

    private void updateEntityFeature(EntityType<?> type) {
        this.feature.clear();
        if (type.m_204039_(IdentityEntityTags.BURNS_IN_DAYLIGHT)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.burns_in_daylight"));
        }
        if (type.m_204039_(IdentityEntityTags.FLYING)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.flying"));
        }
        if (type.m_204039_(IdentityEntityTags.SLOW_FALLING)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.slow_falling"));
        }
        if (type.m_204039_(IdentityEntityTags.WOLF_PREY)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.wolf_prey"));
        }
        if (type.m_204039_(IdentityEntityTags.FOX_PREY)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.fox_prey"));
        }
        if (type.m_204039_(IdentityEntityTags.HURT_BY_HIGH_TEMPERATURE)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.hurt_by_high_temperature"));
        }
        if (type.m_204039_(IdentityEntityTags.RAVAGER_RIDING)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.ravager_riding"));
        }
        if (type.m_204039_(IdentityEntityTags.PIGLIN_FRIENDLY)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.piglin_friendly"));
        }
        if (type.m_204039_(IdentityEntityTags.LAVA_WALKING)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.lava_walking"));
        }
        if (type.m_204039_(IdentityEntityTags.CANT_SWIM)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.cant_swim"));
        }
        if (type.m_204039_(IdentityEntityTags.UNDROWNABLE)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.undrownable"));
        }
        if (type.m_204039_(EntityTagGenerator.NO_PHYSICS)) {
            this.feature.add(new MorphFeature("ageofmythology.entity.info.no_physics"));
        }
    }
}

