/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.gui;

import com.kurome.ageofmythology.bettermorph.gui.BaseButton;
import com.kurome.ageofmythology.bettermorph.gui.BaseTextScreen;
import com.kurome.ageofmythology.bettermorph.gui.attribute_info.AttributeInfoButton;
import com.kurome.ageofmythology.bettermorph.gui.inventory.InventoryButton;
import com.kurome.ageofmythology.bettermorph.gui.morph_info.MorphInfoButton;
import com.kurome.ageofmythology.init.AOMItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class GuiManager {
    public static int BUTTON_WIDTH = 28;
    public static int BUTTON_HEIGHT = 32;
    public static int INVENTORY_INDEX = 0;
    public static int MORPH_INFO_INDEX = 1;
    public static int ATTRIBUTE_INFO_INDEX = 2;
    public static List<BaseButton> buttons = new ArrayList<BaseButton>(Arrays.asList(new BaseButton[]{new InventoryButton(BUTTON_WIDTH, BUTTON_HEIGHT, (Component)Component.m_237115_((String)"inventory"), Items.f_41960_), new MorphInfoButton(BUTTON_WIDTH, BUTTON_HEIGHT, (Component)Component.m_237115_((String)"morph"), (Item)AOMItems.MINECRAFT_CREEPER_ITEM.get()), new AttributeInfoButton(BUTTON_WIDTH, BUTTON_HEIGHT, (Component)Component.m_237115_((String)"attribute"), Items.f_42383_)}));

    public static void setSelectedButton(int index) {
        for (int i = 0; i < buttons.size(); ++i) {
            buttons.get(i).setSelected(index == i);
        }
    }

    public void registerButtonGUI(Consumer<AbstractWidget> consumer, GuiInfo guiInfo, int selected) {
        GuiManager.setSelectedButton(selected);
        for (int i = 0; i < buttons.size(); ++i) {
            IntSupplier screenY;
            IntSupplier screenX;
            BaseButton button = buttons.get(i);
            Screen screen = guiInfo.screen;
            if (screen instanceof BaseTextScreen) {
                BaseTextScreen baseTextScreen = (BaseTextScreen)screen;
                screenX = () -> baseTextScreen.leftPos;
                screenY = () -> baseTextScreen.topPos;
            } else if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)screen;
                Objects.requireNonNull(abstractContainerScreen);
                screenX = () -> ((AbstractContainerScreen)abstractContainerScreen).getGuiLeft();
                Objects.requireNonNull(abstractContainerScreen);
                screenY = () -> ((AbstractContainerScreen)abstractContainerScreen).getGuiTop();
            } else {
                screenX = () -> (screen.f_96543_ - 176) / 2;
                screenY = () -> (screen.f_96544_ - 166) / 2;
            }
            button.setPosition(screenX, i * BUTTON_WIDTH, screenY, -BUTTON_HEIGHT + 4);
            consumer.accept((AbstractWidget)button);
        }
    }

    public static class GuiInfo {
        int guiLeft;
        int guiTop;
        Screen screen;

        public GuiInfo(int guiLeft, int guiTop, Screen screen) {
            this.guiLeft = guiLeft;
            this.guiTop = guiTop;
            this.screen = screen;
        }
    }
}

