/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph.gui;

import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public abstract class BaseButton
extends Button {
    private final Item icon;
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("ageofmythology", "textures/gui/buttons.png");
    private boolean isSelected = false;
    private final int index;
    private IntSupplier screenX;
    private int offsetX;
    private IntSupplier screenY;
    private int offsetY;

    public BaseButton(int width, int height, Component title, Item icon, int index) {
        super(0, 0, width, height, title, button -> ((BaseButton)button).onPressed(), Supplier::get);
        this.icon = icon;
        this.index = index;
    }

    protected abstract void onPressed();

    public void m_87963_(GuiGraphics g, int mouseX, int mouseY, float partialTicks) {
        if (this.isSelected) {
            this.render(g);
        }
    }

    public void render(GuiGraphics g) {
        if (this.f_93624_) {
            g.m_280218_(BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), this.index != 0 ? this.f_93618_ : 0, this.isSelected ? this.f_93619_ : 0, this.f_93618_, this.f_93619_);
            int i = this.m_252754_() + 6;
            int j = this.m_252907_() + 9;
            if (this.icon != null) {
                g.m_280203_(this.icon.m_7968_(), i, j);
                g.m_280370_(Minecraft.m_91087_().f_91062_, this.icon.m_7968_(), i, j);
            }
        }
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public void setPosition(IntSupplier screenX, int offsetX, IntSupplier screenY, int offsetY) {
        this.screenX = screenX;
        this.offsetX = offsetX;
        this.screenY = screenY;
        this.offsetY = offsetY;
    }

    public int m_252754_() {
        return this.screenX.getAsInt() + this.offsetX;
    }

    public int m_252907_() {
        return this.screenY.getAsInt() + this.offsetY;
    }
}

