/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph;

import com.kurome.ageofmythology.AgeOfMythologyMod;
import com.kurome.ageofmythology.bettermorph.api.IWheelManager;
import com.kurome.ageofmythology.config.AOMUtil;
import com.kurome.ageofmythology.model.MorphData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import liushuangwuyin.bettermorph.api.PlayerFavorites;
import liushuangwuyin.bettermorph.api.variant.IdentityType;
import liushuangwuyin.bettermorph.network.impl.SwapPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MorphManager
implements IWheelManager {
    private int selectionIndex = -1;
    private Player player;
    public static MorphManager abilityManager;

    public MorphManager(Player player) {
        this.player = player;
    }

    public static IWheelManager getManager() {
        if (abilityManager == null) {
            abilityManager = new MorphManager((Player)Minecraft.m_91087_().f_91074_);
        }
        return abilityManager;
    }

    @Override
    public int getCount() {
        return this.getFavorites().size();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void makeSelection(int index) {
        if (index >= 0 && index < this.getCount()) {
            this.makeLocalSelection(index, true);
        }
    }

    private void makeLocalSelection(int globalIndex, boolean doSync) {
        List<IdentityType<?>> list = this.getFavorites();
        this.selectionIndex = globalIndex;
        if (doSync && this.player.m_9236_().f_46443_) {
            IdentityType<?> type = list.get(globalIndex);
            SwapPackets.sendSwapRequest(type);
        }
    }

    @Override
    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    @Override
    public MorphData getData(int index) {
        List<IdentityType<?>> list = this.getFavorites();
        if (index < list.size()) {
            IdentityType<?> rawData = list.get(index);
            if (rawData == null) {
                return new MorphData(Component.m_237119_().m_7220_(this.player.m_5446_()), Component.m_237119_().m_7220_(this.player.m_5446_()), new ResourceLocation("bettermorph", "textures/gui/player.png"));
            }
            EntityType type = rawData.getEntityType();
            String name = AOMUtil.getMobName(type);
            Item renderIcon = AOMUtil.getAOMItemByEntityId(name);
            LivingEntity entity = (LivingEntity)type.m_20615_(AgeOfMythologyMod.PROXY.getClientLevel());
            if (entity != null) {
                return new MorphData(Component.m_237115_((String)type.m_20675_()), Component.m_237115_((String)type.m_20675_()), entity);
            }
            return new MorphData(Component.m_237115_((String)type.m_20675_()), Component.m_237115_((String)type.m_20675_()), renderIcon);
        }
        return MorphData.EMPTY;
    }

    private List<IdentityType<?>> getFavorites() {
        ArrayList list = new ArrayList();
        list.add(null);
        List<IdentityType> favoriteList = PlayerFavorites.getFavorites((Player)this.player).stream().sorted(Comparator.comparing(type -> type.getEntityType().m_20675_())).toList();
        list.addAll(favoriteList);
        return list;
    }

    @Override
    public void updatePlayer(Player player) {
        this.player = player;
    }
}

