/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph;

import com.kurome.ageofmythology.bettermorph.api.IWheelManager;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.model.Ability;
import com.kurome.ageofmythology.model.MorphData;
import com.kurome.ageofmythology.net.AbilitySelection;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.net.ServerboundSelectAbility;
import java.util.ArrayList;
import java.util.List;
import liushuangwuyin.bettermorph.api.PlayerIdentity;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AbilityManager
implements IWheelManager {
    private int selectionIndex = -1;
    private List<Ability> selectionOptionList = new ArrayList<Ability>();
    private Player player;
    private final AbilitySelection abilitySelection;
    public static AbilityManager abilityManager;

    public AbilityManager(Player player) {
        this.player = player;
        this.abilitySelection = new AbilitySelection();
        this.init();
    }

    public static IWheelManager getManager() {
        if (abilityManager == null) {
            abilityManager = new AbilityManager((Player)Minecraft.m_91087_().f_91074_);
        }
        return abilityManager;
    }

    private void init() {
        this.refresh();
    }

    private void refresh() {
        this.selectionOptionList = PlayerIdentity.getIdentity((Player)this.player) != null ? AOMAbilityConfig.getAbilityList(PlayerIdentity.getIdentity((Player)this.player).m_6095_().m_20675_(), this.player) : AOMAbilityConfig.getAbilityList(this.player.m_6095_().m_20675_(), this.player);
    }

    @Override
    public int getCount() {
        this.refresh();
        return this.selectionOptionList.size();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void makeSelection(int index) {
        if (index >= 0 && index < this.selectionOptionList.size()) {
            this.makeLocalSelection(index, true);
        }
    }

    private void makeLocalSelection(int globalIndex, boolean doSync) {
        this.selectionIndex = globalIndex;
        if (doSync && this.player.m_9236_().f_46443_) {
            this.abilitySelection.makeSelection(globalIndex);
            Messages.sendToServer(new ServerboundSelectAbility(this.abilitySelection));
        }
    }

    @Override
    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    @Override
    public MorphData getData(int index) {
        this.refresh();
        return this.selectionOptionList.get((int)index).abilityData;
    }

    @Override
    public void updatePlayer(Player player) {
        this.player = player;
    }
}

