/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology.bettermorph;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class AbilityHelper {
    public static Vec3 getPositionFromEntityLookDirection(Entity originEntity, float distance) {
        Vec3 start = originEntity.m_146892_();
        return originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, float distance, boolean checkForBlocks) {
        Vec3 start = originEntity.m_146892_();
        Vec3 end = originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
        return AbilityHelper.raycastForEntity(level, originEntity, start, end, checkForBlocks);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks) {
        return AbilityHelper.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, 0.0f, AbilityHelper::canHitWithRaycast);
    }

    private static boolean canHitWithRaycast(Entity entity) {
        return entity.m_6087_() && entity.m_6084_();
    }

    private static HitResult internalRaycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks, float bbInflation, Predicate<? super Entity> filter) {
        BlockHitResult blockHitResult = null;
        if (checkForBlocks) {
            blockHitResult = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, originEntity));
            end = blockHitResult.m_82450_();
        }
        AABB range = originEntity.m_20191_().m_82369_(end.m_82546_(start));
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        List entities = level.m_6249_(originEntity, range, filter);
        for (Entity target : entities) {
            HitResult hit = AbilityHelper.checkEntityIntersecting(target, start, end, bbInflation);
            if (hit.m_6662_() == HitResult.Type.MISS) continue;
            hits.add(hit);
        }
        if (!hits.isEmpty()) {
            hits.sort(Comparator.comparingDouble(o -> o.m_82450_().m_82557_(start)));
            return (HitResult)hits.get(0);
        }
        if (checkForBlocks) {
            return blockHitResult;
        }
        return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)end));
    }

    public static HitResult checkEntityIntersecting(Entity entity, Vec3 start, Vec3 end, float bbInflation) {
        Vec3 hitPos = null;
        if (entity.isMultipartEntity()) {
            for (PartEntity p : entity.getParts()) {
                Vec3 hit = p.m_20191_().m_82400_((double)bbInflation).m_82371_(start, end).orElse(null);
                if (hit == null) continue;
                hitPos = hit;
                break;
            }
        } else {
            hitPos = entity.m_20191_().m_82400_((double)bbInflation).m_82371_(start, end).orElse(null);
        }
        if (hitPos != null) {
            return new EntityHitResult(entity, hitPos);
        }
        return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)end));
    }
}

