/*
 * Decompiled with CFR 0.152.
 */
package com.kurome.ageofmythology;

import com.kurome.ageofmythology.AOMConfig;
import com.kurome.ageofmythology.advancement.AOMAdvancement;
import com.kurome.ageofmythology.bettermorph.AbilityRegistry;
import com.kurome.ageofmythology.command.AOMCommand;
import com.kurome.ageofmythology.compat.curios.CuriosCompat;
import com.kurome.ageofmythology.compat.curios.ModsCompatHandler;
import com.kurome.ageofmythology.compat.prefeb.PrefebItems;
import com.kurome.ageofmythology.config.AOMEntityRenderConfig;
import com.kurome.ageofmythology.config.AOMItemsConfig;
import com.kurome.ageofmythology.config.AOMMobHeadConfig;
import com.kurome.ageofmythology.config.AOMMorphInfoConfig;
import com.kurome.ageofmythology.config.AOMTradeConfig;
import com.kurome.ageofmythology.config.ability_config.AOMAbilityConfig;
import com.kurome.ageofmythology.events.AOMHeadDropEvent;
import com.kurome.ageofmythology.events.OverlayRegistryEvent;
import com.kurome.ageofmythology.init.AOMAttributes;
import com.kurome.ageofmythology.init.AOMBlockEntities;
import com.kurome.ageofmythology.init.AOMBlocks;
import com.kurome.ageofmythology.init.AOMCreativeTabs;
import com.kurome.ageofmythology.init.AOMDensityFunctionsRegister;
import com.kurome.ageofmythology.init.AOMEntities;
import com.kurome.ageofmythology.init.AOMFeature;
import com.kurome.ageofmythology.init.AOMItems;
import com.kurome.ageofmythology.init.AOMLoot;
import com.kurome.ageofmythology.init.AOMMobEffect;
import com.kurome.ageofmythology.init.AOMSounds;
import com.kurome.ageofmythology.init.AOMStructures;
import com.kurome.ageofmythology.init.MobCategoryAdditions;
import com.kurome.ageofmythology.item.general.BloodBottleItem;
import com.kurome.ageofmythology.net.Messages;
import com.kurome.ageofmythology.proxy.ClientProxy;
import com.kurome.ageofmythology.proxy.CommonProxy;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="ageofmythology")
public class AgeOfMythologyMod {
    public static final String MODID = "ageofmythology";
    private static final Rarity rarity = Rarity.create((String)"AgeOfMythology", (ChatFormatting)ChatFormatting.DARK_GREEN);
    private static final String MODEL_DIR = "textures/model/";
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static final Logger LOGGER = LogUtils.getLogger();

    public static Rarity getRarity() {
        return rarity;
    }

    public AgeOfMythologyMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AOMConfig.SPEC);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(OverlayRegistryEvent::onRegisterOverlays);
        MobCategoryAdditions.registerMobCategory();
        AOMItemsConfig.init();
        AOMAttributes.ATTRIBUTES.register(modEventBus);
        AOMBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        AOMBlocks.BLOCKS.register(modEventBus);
        AOMItems.ITEMS.register(modEventBus);
        PrefebItems.init();
        AOMEntities.ENTITY_TYPES.register(modEventBus);
        AOMEntities.SPAWN_EGGS.register(modEventBus);
        AOMMobEffect.MOB_EFFECT.register(modEventBus);
        AOMMobEffect.POTION_DEF_REG.register(modEventBus);
        AOMLoot.GLOBAL_MODIFIERS.register(modEventBus);
        AOMSounds.SOUNDS.register(modEventBus);
        AOMDensityFunctionsRegister.DENSITY_FUNCTION_TYPE.register(modEventBus);
        AOMCreativeTabs.TABS.register(modEventBus);
        AOMFeature.FEATURES.register(modEventBus);
        AOMStructures.STRUCTURE_FEATURES.register(modEventBus);
        PROXY.init();
        modEventBus.addListener(this::setupClient);
        if (ModList.get().isLoaded("curios")) {
            modEventBus.addListener(CuriosCompat::registerCurioRenderers);
        }
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        ModsCompatHandler.Init(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AOMAdvancement.init();
        Messages.register();
        AOMStructures.registerPieceTypes();
        AOMAbilityConfig.init();
        event.enqueueWork(() -> {});
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        AbilityRegistry.init();
        AOMMobHeadConfig.init();
        AOMEntityRenderConfig.init();
        AOMTradeConfig.register();
        MinecraftForge.EVENT_BUS.register((Object)new AOMHeadDropEvent());
        AOMMorphInfoConfig.init();
        AOMItemsConfig.lazy_init();
    }

    public void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)AOMItems.BLOOD_BOTTLE.get()), (ResourceLocation)BloodBottleItem.BLOOD_BOTTLE_STATE, (stack, world, entity, seed) -> {
            if (entity != null && stack.m_150930_((Item)AOMItems.BLOOD_BOTTLE.get())) {
                return BloodBottleItem.getBloodBottleState(stack);
            }
            return 0.0f;
        }));
    }

    public void registerCommands(RegisterCommandsEvent event) {
        AOMCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static ResourceLocation getModelTexture(String name) {
        return new ResourceLocation(MODID, MODEL_DIR + name);
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(MODID, name.toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static boolean isLoadedMod(String modid) {
        return ModList.get().isLoaded(modid);
    }
}

