/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.api.FoodCapability;
import com.cazsius.solcarrot.api.SOLCarrotAPI;
import com.cazsius.solcarrot.tracking.FoodInstance;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

@ParametersAreNonnullByDefault
public final class FoodList
implements FoodCapability {
    private static final String NBT_KEY_FOOD_LIST = "foodList";
    private final Set<FoodInstance> foods = new HashSet<FoodInstance>();
    @Nullable
    private ProgressInfo cachedProgressInfo;
    private final LazyOptional<FoodList> capabilityOptional = LazyOptional.of(() -> this);

    public static FoodList get(Player player) {
        return (FoodList)player.getCapability(SOLCarrotAPI.foodCapability).orElseThrow(FoodListNotFoundException::new);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        return capability == SOLCarrotAPI.foodCapability ? this.capabilityOptional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        this.foods.stream().map(FoodInstance::encode).filter(Objects::nonNull).map(StringTag::m_129297_).forEach(arg_0 -> list.add(arg_0));
        tag.m_128365_(NBT_KEY_FOOD_LIST, (Tag)list);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag list = tag.m_128437_(NBT_KEY_FOOD_LIST, 8);
        this.foods.clear();
        list.stream().map(nbt -> (StringTag)nbt).map(StringTag::m_7916_).map(FoodInstance::decode).filter(Objects::nonNull).forEach(this.foods::add);
        this.invalidateProgressInfo();
    }

    public boolean addFood(Item food) {
        boolean wasAdded = this.foods.add(new FoodInstance(food)) && SOLCarrotConfig.shouldCount(food);
        this.invalidateProgressInfo();
        return wasAdded;
    }

    @Override
    public boolean hasEaten(Item food) {
        if (!food.m_41472_()) {
            return false;
        }
        return this.foods.contains(new FoodInstance(food));
    }

    public void clearFood() {
        this.foods.clear();
        this.invalidateProgressInfo();
    }

    public Set<FoodInstance> getEatenFoods() {
        return new HashSet<FoodInstance>(this.foods);
    }

    @Override
    public int getEatenFoodCount() {
        return this.foods.size();
    }

    public ProgressInfo getProgressInfo() {
        if (this.cachedProgressInfo == null) {
            this.cachedProgressInfo = new ProgressInfo(this);
        }
        return this.cachedProgressInfo;
    }

    public void invalidateProgressInfo() {
        this.cachedProgressInfo = null;
    }

    public static class FoodListNotFoundException
    extends RuntimeException {
        public FoodListNotFoundException() {
            super("Player must have food capability attached, but none was found.");
        }
    }
}

