/*
 * Decompiled with CFR 0.152.
 */
package cn.flowerinsnow.greatscrollabletooltips;

import cn.flowerinsnow.greatscrollabletooltips.common.config.GreatScrollableTooltipsConfig;
import cn.flowerinsnow.greatscrollabletooltips.common.object.ScrollSession;
import cn.flowerinsnow.greatscrollabletooltips.common.provider.ModEnvironmentProvider;
import cn.flowerinsnow.greatscrollabletooltips.listener.EventTriggerListener;
import cn.flowerinsnow.greatscrollabletooltips.listener.KeyScrollListener;
import cn.flowerinsnow.greatscrollabletooltips.listener.MouseScrollListener;
import cn.flowerinsnow.greatscrollabletooltips.listener.ScrollingStatusListener;
import cn.flowerinsnow.greatscrollabletooltips.manager.KeyBindingManager;
import cn.flowerinsnow.greatscrollabletooltips.screen.ConfigScreen;
import java.io.InputStream;
import java.nio.file.Path;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="great_scrollable_tooltips")
public class GreatScrollableTooltips {
    public static final String MODID = "great_scrollable_tooltips";
    private static GreatScrollableTooltips instance;
    private GreatScrollableTooltipsConfig config;
    private ScrollSession<ItemStack> scrollSession;

    public GreatScrollableTooltips() {
        this(FMLJavaModLoadingContext.get());
    }

    public GreatScrollableTooltips(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::initKeyBindings);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        instance = this;
        this.scrollSession = new ScrollSession();
        this.initConfig();
        this.initListeners();
    }

    private void initConfig() {
        this.config = new GreatScrollableTooltipsConfig(new ModEnvironmentProvider(){

            public InputStream getDefaultConfigAsStream() {
                return GreatScrollableTooltips.class.getResourceAsStream("/config.toml");
            }

            public Path getConfigFile() {
                return FMLPaths.CONFIGDIR.get().resolve("great_scrollable_tooltips.toml");
            }

            public void crash(Throwable throwable, String msg) {
                Minecraft.m_91332_((CrashReport)CrashReport.m_127521_((Throwable)throwable, (String)msg));
            }
        });
        this.config.saveDefaultConfig();
        this.config.load();
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> new ConfigScreen((Screen)parent, this.config)));
    }

    private void initListeners() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.register((Object)new EventTriggerListener());
        eventBus.register((Object)new MouseScrollListener(this));
        eventBus.register((Object)new ScrollingStatusListener(this));
        eventBus.register((Object)new KeyScrollListener(this));
    }

    public void initKeyBindings(RegisterKeyMappingsEvent event) {
        KeyBindingManager.registerAll(event);
    }

    public static GreatScrollableTooltips getInstance() {
        return instance;
    }

    public GreatScrollableTooltipsConfig getConfig() {
        return this.config;
    }

    public ScrollSession<ItemStack> getScrollSession() {
        return this.scrollSession;
    }
}

