/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.Restriction;
import jeresources.entry.WorldGenEntry;
import jeresources.util.LogHelper;
import jeresources.util.PlantHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;

public class MapKeys {
    private static final Cache<BlockState, String> keyCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();

    @Nullable
    public static String getKey(BlockState state, ServerLevel serverLevel, BlockPos pos) {
        Block block = state.m_60734_();
        if (!block.m_6724_(state)) {
            try {
                return (String)keyCache.get((Object)state, () -> MapKeys.getKeyUncached(block, state, serverLevel, pos));
            }
            catch (ExecutionException e) {
                LogHelper.error("Cache error", e);
            }
        }
        return MapKeys.getKeyUncached(block, state, serverLevel, pos);
    }

    @Nullable
    private static String getKeyUncached(Block block, BlockState state, ServerLevel serverLevel, BlockPos pos) {
        ItemStack pickBlock = null;
        try {
            pickBlock = block.m_7397_((BlockGetter)serverLevel, pos, state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pickBlock == null || pickBlock.m_41720_() == null) {
            return block.m_7705_();
        }
        return MapKeys.getKey(pickBlock);
    }

    @Nullable
    public static String getKey(ItemStack drop) {
        if (drop == null) {
            return null;
        }
        Item item = drop.m_41720_();
        if (item == null) {
            return null;
        }
        String registryName = item.m_5524_();
        StringBuilder key = new StringBuilder(registryName);
        if (drop.m_41783_() != null) {
            key.append(":").append(drop.m_41783_());
        }
        return key.toString();
    }

    public static String getKey(BushBlock plant) {
        return PlantHelper.getPlant(plant, null, null).m_60734_().m_7705_();
    }

    public static String getKey(LootDrop dropItem) {
        return MapKeys.getKey(dropItem.item);
    }

    public static String getKey(ItemStack drop, Restriction restriction) {
        return MapKeys.getKey(drop) + ":" + restriction.toString();
    }

    public static String getKey(WorldGenEntry entry) {
        return MapKeys.getKey(entry.getBlock(), entry.getRestriction());
    }
}

