/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.GetEmergencyItemsMessage;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class EmergencyItemsScreen
extends BaseScreen {
    private final long endTime = System.currentTimeMillis() + (long)ClientQuestFile.INSTANCE.getEmergencyItemsCooldown() * 1000L;
    private boolean done = false;
    private final SimpleTextButton cancelButton = new SimpleTextButton((Panel)this, (Component)Component.m_237115_((String)"gui.cancel"), (Icon)Color4I.empty()){

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.getGui().closeGui();
        }
    };
    private final Panel itemPanel = new Panel((Panel)this){

        public void addWidgets() {
            ClientQuestFile.INSTANCE.getEmergencyItems().forEach(stack -> this.add(new EmergencyItemWidget(this, (ItemStack)stack)));
        }

        public void alignWidgets() {
            this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 7, 3)));
            this.setHeight(22);
            this.setPos((EmergencyItemsScreen.this.width - EmergencyItemsScreen.this.itemPanel.width) / 2, EmergencyItemsScreen.this.height * 2 / 3 - 10);
        }
    };

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.cancelButton);
        this.cancelButton.setPos((this.width - this.cancelButton.width) / 2, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        long timeLeft = this.endTime - System.currentTimeMillis();
        if (timeLeft <= 0L) {
            if (!this.done) {
                this.done = true;
                this.cancelButton.setTitle((Component)Component.m_237115_((String)"gui.close"));
                new GetEmergencyItemsMessage().sendToServer();
            }
            timeLeft = 0L;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)((int)((double)w / 2.0)), (float)((int)((double)h / 5.0)), 0.0f);
        poseStack.m_85841_(2.0f, 2.0f, 1.0f);
        String s = I18n.m_118938_((String)"ftbquests.file.emergency_items", (Object[])new Object[0]);
        theme.drawString(graphics, (Object)s, -theme.getStringWidth(s) / 2, 0, Color4I.WHITE, 0);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)((int)((double)w / 2.0)), (float)((int)((double)h / 2.5)), 0.0f);
        poseStack.m_85841_(4.0f, 4.0f, 1.0f);
        s = timeLeft <= 0L ? "00:00" : TimeUtils.getTimeString((long)(timeLeft / 1000L * 1000L + 1000L));
        int x1 = -theme.getStringWidth(s) / 2;
        theme.drawString(graphics, (Object)s, x1 - 1, 0, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)s, x1 + 1, 0, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)s, x1, 1, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)s, x1, -1, Color4I.BLACK, 0);
        theme.drawString(graphics, (Object)s, x1, 0, Color4I.WHITE, 0);
        poseStack.m_85849_();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private static class EmergencyItemWidget
    extends Widget {
        private final ItemStack stack;

        public EmergencyItemWidget(Panel panel, ItemStack stack) {
            super(panel);
            this.stack = stack;
            this.setY(3);
            this.setSize(16, 16);
        }

        public void addMouseOverText(TooltipList list) {
            ArrayList l = new ArrayList();
            GuiHelper.addStackTooltip((ItemStack)this.stack, l);
            l.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            QuestShape.get("rsquare").getOutline().draw(graphics, x - 3, y - 3, w + 6, h + 6);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
            GuiHelper.drawItem((GuiGraphics)graphics, (ItemStack)this.stack, (int)0, (boolean)true, null);
            graphics.m_280168_().m_85849_();
        }

        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of((Object)this.stack, (Widget)this);
        }
    }
}

