/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.gui.controls.GuiSlider;
import com.wuest.prefab.structures.base.EnumStructureMaterial;
import com.wuest.prefab.structures.config.InstantBridgeConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureInstantBridge;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiInstantBridge
extends GuiStructure {
    private static final ResourceLocation structureTopDown = new ResourceLocation("prefab", "textures/gui/instant_bridge.png");
    protected InstantBridgeConfiguration specificConfiguration;
    private ExtendedButton btnMaterialType;
    private GuiSlider sldrBridgeLength;
    private GuiCheckBox chckIncludeRoof;
    private GuiSlider sldrInteriorHeight;

    public GuiInstantBridge() {
        super("Instant Bridge");
        this.configurationEnum = StructureTagMessage.EnumStructureConfiguration.InstantBridge;
    }

    public Component m_142562_() {
        return Component.m_237115_((String)GuiLangKeys.translateString("item.prefab.item_instant_bridge"));
    }

    @Override
    protected void Initialize() {
        this.modifiedInitialXAxis = 212;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        this.specificConfiguration = ClientEventHandler.playerConfig.getClientConfig("InstantBridge", InstantBridgeConfiguration.class);
        this.configuration = this.specificConfiguration;
        this.configuration.pos = this.pos;
        this.structureImageLocation = structureTopDown;
        StructureInstantBridge structure = new StructureInstantBridge();
        structure.getClearSpace().getShape().setDirection(Direction.SOUTH);
        structure.setupStructure(this.specificConfiguration, this.pos);
        this.selectedStructure = structure;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnMaterialType = this.createAndAddButton(grayBoxX + 15, grayBoxY + 45, 90, 20, this.specificConfiguration.bridgeMaterial.getName());
        this.sldrBridgeLength = this.createAndAddSlider(grayBoxX + 15, grayBoxY + 85, 90, 20, 25.0, 75.0, this.specificConfiguration.bridgeLength);
        this.chckIncludeRoof = this.createAndAddCheckBox(grayBoxX + 15, grayBoxY + 112, "prefab.gui.bridge_include_roof", this.specificConfiguration.includeRoof, this::buttonClicked);
        this.sldrInteriorHeight = this.createAndAddSlider(grayBoxX + 15, grayBoxY + 140, 90, 20, 3.0, 8.0, this.specificConfiguration.interiorHeight);
        this.sldrInteriorHeight.f_93624_ = this.chckIncludeRoof.isChecked();
        this.btnVisualize = this.createAndAddCustomButton(grayBoxX + 25, grayBoxY + 177, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(grayBoxX + 310, grayBoxY + 177, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(grayBoxX + 150, grayBoxY + 177, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 132;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.m_280273_(guiGraphics);
        this.drawControlLeftPanel(guiGraphics, x + 10, y + 10, 125, 190);
        this.drawControlRightPanel(guiGraphics, imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindAndDrawScaledTexture(this.structureImageLocation, guiGraphics, imageLocation, y + 15, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
    }

    @Override
    protected void postButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawSplitString(guiGraphics, GuiLangKeys.translateString("item.prefab.item_instant_bridge"), x + 15, y + 17, 100);
        this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.bridge_material"), x + 15, y + 35, this.textColor);
        this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.bridge_length"), x + 15, y + 75, this.textColor);
        if (this.chckIncludeRoof.isChecked()) {
            this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.bridge_interior_height"), x + 15, y + 130, this.textColor);
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        int sliderValue = this.sldrBridgeLength.getIntValue();
        if (sliderValue > 75) {
            sliderValue = 75;
        } else if (sliderValue < 25) {
            sliderValue = 25;
        }
        this.specificConfiguration.bridgeLength = sliderValue;
        sliderValue = this.sldrInteriorHeight.getIntValue();
        if (sliderValue > 8) {
            sliderValue = 8;
        } else if (sliderValue < 3) {
            sliderValue = 3;
        }
        this.specificConfiguration.interiorHeight = sliderValue;
        this.specificConfiguration.includeRoof = this.chckIncludeRoof.isChecked();
        this.configuration.houseFacing = this.player.m_6350_().m_122424_();
        this.configuration.pos = this.pos;
        this.performCancelOrBuildOrHouseFacing(button);
        if (button == this.chckIncludeRoof) {
            this.sldrInteriorHeight.f_93624_ = this.specificConfiguration.includeRoof = this.chckIncludeRoof.isChecked();
        }
        if (button == this.btnMaterialType) {
            this.specificConfiguration.bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(this.specificConfiguration.bridgeMaterial.getNumber() + 1);
            GuiUtils.setButtonText(this.btnMaterialType, this.specificConfiguration.bridgeMaterial.getTranslatedName());
        } else if (button == this.btnVisualize) {
            ((StructureInstantBridge)this.selectedStructure).setupStructure(this.specificConfiguration, this.pos);
            this.performPreview();
        }
    }
}

