/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.config.ServerModConfiguration;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.enums.BaseOption;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.items.ItemBasicStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureBasic;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class GuiBasicStructure
extends GuiStructure {
    public BasicStructureConfiguration specificConfiguration;
    protected ServerModConfiguration serverConfiguration;
    private ExtendedButton btnBedColor = null;
    private ExtendedButton btnGlassColor = null;
    private ExtendedButton btnStructureOptions = null;
    private ArrayList<BaseOption> availableOptions;
    private boolean showConfigurationOptions;

    public GuiBasicStructure() {
        super("Basic Structure");
        this.configurationEnum = StructureTagMessage.EnumStructureConfiguration.Basic;
        this.showConfigurationOptions = false;
    }

    public Component m_142562_() {
        return Component.m_237115_((String)this.specificConfiguration.getDisplayName());
    }

    @Override
    protected void Initialize() {
        BaseOption option;
        super.Initialize();
        ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(this.player);
        if (stack != null) {
            ItemBasicStructure item = (ItemBasicStructure)stack.m_41720_();
            this.serverConfiguration = Prefab.proxy.getServerConfiguration();
            this.specificConfiguration = ClientEventHandler.playerConfig.getClientConfig(item.structureType.getName(), BasicStructureConfiguration.class);
            this.configuration = this.specificConfiguration;
            this.specificConfiguration.basicStructureName = item.structureType;
            HashMap<String, Boolean> configurationSettings = this.serverConfiguration.structureOptions.get(item.structureType.getItemTranslationString());
            ArrayList<BaseOption> tempOptions = item.structureType.getBaseOption().getSpecificOptions();
            this.availableOptions = new ArrayList();
            for (BaseOption option2 : tempOptions) {
                if (configurationSettings != null && (!configurationSettings.containsKey(option2.getTranslationString()) || !((Boolean)configurationSettings.get(option2.getTranslationString())).booleanValue())) continue;
                this.availableOptions.add(option2);
            }
        }
        if (this.availableOptions.isEmpty()) {
            this.showNoOptionsScreen();
            return;
        }
        boolean foundPreviouslySelectedOption = false;
        if (this.specificConfiguration.chosenOption != null) {
            for (BaseOption option3 : this.availableOptions) {
                if (!option3.getTranslationString().equals(this.specificConfiguration.chosenOption.getTranslationString())) continue;
                foundPreviouslySelectedOption = true;
                break;
            }
        }
        if (!foundPreviouslySelectedOption) {
            this.specificConfiguration.chosenOption = this.availableOptions.get(0);
        }
        this.structureImageLocation = this.specificConfiguration.chosenOption.getPictureLocation();
        this.configuration.pos = this.pos;
        this.configuration.houseFacing = this.houseFacing;
        this.selectedStructure = StructureBasic.CreateInstance(this.specificConfiguration.chosenOption.getAssetLocation(), StructureBasic.class);
        if (this.availableOptions.size() > 1 || this.specificConfiguration.basicStructureName.shouldShowConfigurationOptions()) {
            this.showConfigurationOptions = true;
        }
        if (this.availableOptions.size() == 1 && this.showConfigurationOptions && !(option = this.availableOptions.get(0)).getHasBedColor() && !option.getHasGlassColor()) {
            this.showConfigurationOptions = false;
        }
        if (!this.showConfigurationOptions) {
            this.InitializeStandardButtons();
        } else {
            this.modifiedInitialXAxis = 215;
            this.modifiedInitialYAxis = 117;
            this.imagePanelWidth = 285;
            Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
            int grayBoxX = adjustedXYValue.getFirst();
            int grayBoxY = adjustedXYValue.getSecond();
            int x = grayBoxX + 8;
            int y = grayBoxY + 45;
            if (this.availableOptions.size() > 1) {
                this.btnStructureOptions = this.createAndAddButton(x, y, 100, 20, this.specificConfiguration.chosenOption.getTranslationString(), GuiLangKeys.translateString("prefab.gui.building_options"));
                this.btnStructureOptions.f_93624_ = true;
                y += 45;
            } else if (this.btnStructureOptions != null) {
                this.btnStructureOptions.f_93624_ = false;
            }
            this.btnBedColor = this.createAndAddDyeButton(x, y, 90, 20, this.specificConfiguration.bedColor, GuiLangKeys.translateString("prefab.gui.structure.bed_color"));
            this.btnBedColor.f_93624_ = false;
            this.btnGlassColor = this.createAndAddFullDyeButton(x, y, 90, 20, this.specificConfiguration.glassColor, GuiLangKeys.translateString("prefab.gui.structure.glass"));
            this.btnGlassColor.f_93624_ = false;
            this.btnVisualize = this.createAndAddCustomButton(grayBoxX + 24, grayBoxY + 177, 90, 20, "prefab.gui.button.preview");
            this.btnBuild = this.createAndAddCustomButton(grayBoxX + 310, grayBoxY + 177, 90, 20, "prefab.gui.button.build");
            this.btnCancel = this.createAndAddButton(grayBoxX + 154, grayBoxY + 177, 90, 20, "prefab.gui.button.cancel");
        }
    }

    @Override
    protected void preButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (!this.showConfigurationOptions) {
            super.preButtonRender(guiGraphics, x, y, mouseX, mouseY, partialTicks);
        } else {
            int imagePanelUpperLeft = x + 136;
            int imagePanelMiddle = this.imagePanelWidth / 2;
            this.m_280273_(guiGraphics);
            this.drawControlLeftPanel(guiGraphics, x + 2, y + 10, 185, 190);
            this.drawControlRightPanel(guiGraphics, imagePanelUpperLeft, y + 10, this.imagePanelWidth, 190);
            int middleOfImage = this.shownImageWidth / 2;
            int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
            GuiUtils.bindAndDrawScaledTexture(this.structureImageLocation, guiGraphics, imageLocation, y + 15, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        }
        if (this.btnBedColor != null) {
            this.btnBedColor.f_93624_ = false;
        }
        if (this.btnGlassColor != null) {
            this.btnGlassColor.f_93624_ = false;
        }
        int yValue = y + 45;
        if (this.availableOptions.size() > 1) {
            yValue += 45;
        }
        if (this.specificConfiguration.chosenOption.getHasBedColor()) {
            this.btnBedColor.f_93624_ = true;
            this.btnBedColor.m_253211_(yValue);
            yValue += 45;
        }
        if (this.specificConfiguration.chosenOption.getHasGlassColor()) {
            this.btnGlassColor.f_93624_ = true;
            this.btnGlassColor.m_253211_(yValue);
        }
    }

    @Override
    protected void postButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.showConfigurationOptions) {
            this.drawSplitString(guiGraphics, GuiLangKeys.translateString(this.specificConfiguration.basicStructureName.getItemTranslationString()), x + 8, y + 17, 128);
            int yValue = y + 35;
            if (this.availableOptions.size() > 1) {
                this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.building_options"), x + 8, yValue, this.textColor);
                yValue += 45;
            }
            if (this.specificConfiguration.chosenOption.getHasBedColor()) {
                this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 8, yValue, this.textColor);
                yValue += 45;
            }
            if (this.specificConfiguration.chosenOption.getHasGlassColor()) {
                this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.structure.glass"), x + 8, yValue, this.textColor);
                yValue += 45;
            }
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.performCancelOrBuildOrHouseFacing(button);
        if (button == this.btnVisualize) {
            this.performPreview();
        } else if (button == this.btnBedColor) {
            this.specificConfiguration.bedColor = DyeColor.m_41053_((int)(this.specificConfiguration.bedColor.m_41060_() + 1));
            GuiUtils.setButtonText(this.btnBedColor, GuiLangKeys.translateDye(this.specificConfiguration.bedColor));
        } else if (button == this.btnGlassColor) {
            this.specificConfiguration.glassColor = FullDyeColor.ById(this.specificConfiguration.glassColor.getId() + 1);
            GuiUtils.setButtonText(this.btnGlassColor, GuiLangKeys.translateFullDye(this.specificConfiguration.glassColor));
        } else if (button == this.btnStructureOptions) {
            for (int i = 0; i < this.availableOptions.size(); ++i) {
                BaseOption option = this.availableOptions.get(i);
                BaseOption chosenOption = null;
                if (this.specificConfiguration.chosenOption.getTranslationString().equals(option.getTranslationString())) {
                    chosenOption = i == this.availableOptions.size() - 1 ? this.availableOptions.get(0) : this.availableOptions.get(i + 1);
                }
                if (chosenOption == null) continue;
                this.selectedStructure = StructureBasic.CreateInstance(chosenOption.getAssetLocation(), StructureBasic.class);
                this.specificConfiguration.chosenOption = chosenOption;
                this.structureImageLocation = this.specificConfiguration.chosenOption.getPictureLocation();
                GuiUtils.setButtonText(this.btnStructureOptions, GuiLangKeys.translateString(chosenOption.getTranslationString()));
                break;
            }
        }
    }
}

