/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.registries;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.BlockDarkLamp;
import com.wuest.prefab.blocks.BlockLightSwitch;
import com.wuest.prefab.registries.ILevelBasedRegistry;
import java.util.Vector;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightSwitchRegistry
extends ILevelBasedRegistry<BlockPos> {
    private static final int SearchBlockRadius = 24;

    @Override
    protected void onElementRemoved(Level level, BlockPos element) {
        this.setNearbyLights(element, level, false);
    }

    @Override
    protected void onElementRegistered(Level level, BlockPos element) {
    }

    public void flipSwitch(Level level, BlockPos incomingBlockPos, boolean turnOn) {
        Vector blockPositions;
        if (!level.f_46443_ && this.internalRegistry.containsKey(level) && (blockPositions = (Vector)this.internalRegistry.get(level)) != null) {
            for (BlockPos blockPos : blockPositions) {
                if (blockPos.hashCode() != incomingBlockPos.hashCode()) continue;
                this.setNearbyLights(blockPos, level, turnOn);
                break;
            }
        }
    }

    public boolean checkForNearbyOnSwitch(Level level, BlockPos blockPos) {
        Tuple<BlockPos, BlockPos> searchPositions = this.getSearchStartAndEnd(blockPos);
        for (BlockPos worldPos : BlockPos.m_121940_((BlockPos)searchPositions.getFirst(), (BlockPos)searchPositions.getSecond())) {
            BlockState blockState = level.m_8055_(worldPos);
            if (blockState.m_60734_() != ModRegistry.LightSwitch.get()) continue;
            return (Boolean)blockState.m_61143_((Property)BlockLightSwitch.POWERED);
        }
        return false;
    }

    private void setNearbyLights(BlockPos blockPos, Level level, boolean turnOn) {
        Tuple<BlockPos, BlockPos> searchPositions = this.getSearchStartAndEnd(blockPos);
        for (BlockPos worldPos : BlockPos.m_121940_((BlockPos)searchPositions.getFirst(), (BlockPos)searchPositions.getSecond())) {
            BlockState blockState = level.m_8055_(worldPos);
            if (blockState.m_60734_() != ModRegistry.DarkLamp.get()) continue;
            blockState = (BlockState)blockState.m_61124_((Property)BlockDarkLamp.LIT, (Comparable)Boolean.valueOf(turnOn));
            level.m_7731_(worldPos, blockState, 3);
        }
    }

    private Tuple<BlockPos, BlockPos> getSearchStartAndEnd(BlockPos startingPos) {
        BlockPos startPos = startingPos.m_6625_(24).m_122020_(24).m_122025_(24);
        BlockPos endPos = startingPos.m_6630_(24).m_122013_(24).m_122030_(24);
        return new Tuple<BlockPos, BlockPos>(startPos, endPos);
    }
}

