/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui;

import com.mojang.serialization.Codec;
import com.wuest.prefab.Quadruple;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.config.ConfigCategory;
import com.wuest.prefab.config.ConfigOption;
import com.wuest.prefab.config.ModConfiguration;
import com.wuest.prefab.gui.GuiBase;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class GuiPrefab
extends GuiBase {
    private static final int TITLE_HEIGHT = 8;
    private static final int OPTIONS_LIST_TOP_HEIGHT = 55;
    private static final int OPTIONS_LIST_BOTTOM_OFFSET = 32;
    private static final int OPTIONS_LIST_ITEM_HEIGHT = 25;
    private static final int DONE_BUTTON_TOP_OFFSET = 26;
    private static final int BOTTOM_SECTION_HEIGHT = 32;
    private final Screen parentScreen;
    private ExtendedButton doneButton;
    private ExtendedButton resetToDefaultsButton;
    private ExtendedButton generalGroupButton;
    private ConfigCategory currentOption = ConfigCategory.General;
    private OptionsList currentRowList;
    private ArrayList<Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory>> optionCollection;
    private OptionsList optionsRowList;
    private OptionsList chestOptionsRowList;
    private OptionsList recipeOptionsRowList;
    private OptionsList starterHouseOptionsRowList;

    public GuiPrefab(Minecraft minecraft, Screen parent) {
        super("Prefab Configuration");
        this.parentScreen = parent;
        this.f_96541_ = minecraft;
    }

    @Nullable
    public static List<FormattedCharSequence> tooltipAt(OptionsList optionsRowList, int mouseX, int mouseY) {
        Optional optional;
        if (!optionsRowList.m_5953_((double)mouseX, (double)mouseY) || (optional = optionsRowList.m_94480_((double)mouseX, (double)mouseY)).isPresent()) {
            // empty if block
        }
        return null;
    }

    @Override
    protected void Initialize() {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int x = adjustedXYValue.getFirst();
        this.optionCollection = new ArrayList();
        this.resetToDefaultsButton = this.createAndAddButton(60, this.f_96544_ - 26, 100, 20, "Reset", false);
        this.doneButton = this.createAndAddButton(this.f_96543_ - 160, this.f_96544_ - 26, 100, 20, "Done", false);
        this.generalGroupButton = this.createAndAddButton(this.f_96543_ / 2, 30, 120, 20, "General", false);
        int calculatedListHeight = this.f_96544_ - 55 - 32;
        for (ConfigCategory category : ConfigCategory.values()) {
            OptionsList nextOptions = new OptionsList(this.getMinecraft(), this.f_96543_, this.f_96544_, 55, this.f_96544_ - 32, 25);
            OptionsList currentOptions = null;
            int currentLocation = category.ordinal();
            if (currentLocation == 0) {
                currentOptions = new OptionsList(this.getMinecraft(), this.f_96543_, this.f_96544_, 55, this.f_96544_ - 32, 25);
            } else {
                int currentOptionsIndex = currentLocation - 1;
                if (currentLocation == ConfigCategory.values().length - 1) {
                    nextOptions = this.optionCollection.get(0).getSecond();
                }
                currentOptions = this.optionCollection.get(currentOptionsIndex).getThird();
            }
            ConfigCategory nextCategory = ConfigCategory.getNextCategory(category);
            this.optionCollection.add(new Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory>(category, currentOptions, nextOptions, nextCategory));
        }
        for (ConfigOption configOption : CommonProxy.proxyConfiguration.configOptions) {
            Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory> rowList = this.getOptionsRowList(configOption.getCategory());
            if (rowList == null) continue;
            switch (configOption.getConfigType()) {
                case "Boolean": {
                    this.addBooleanOption(rowList.getSecond(), configOption);
                    break;
                }
                case "String": {
                    this.addStringOption(rowList.getSecond(), configOption);
                    break;
                }
                case "Integer": {
                    this.addIntegerOption(rowList.getSecond(), configOption);
                }
            }
        }
        this.m_7787_((GuiEventListener)this.optionCollection.get(0).getSecond());
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        if (button == this.doneButton) {
            ModConfiguration.UpdateServerConfig();
            this.getMinecraft().m_91152_(this.parentScreen);
        } else if (button == this.generalGroupButton) {
            Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory> option = this.getOptionsRowList(this.currentOption);
            if (option != null) {
                this.m_169411_((GuiEventListener)option.getSecond());
                this.m_7787_((GuiEventListener)option.getThird());
                GuiUtils.setButtonText(this.generalGroupButton, option.getFourth().getName());
                this.currentOption = option.getFourth();
            }
        } else if (button == this.resetToDefaultsButton) {
            for (ConfigOption<?> configOption : CommonProxy.proxyConfiguration.configOptions) {
                configOption.resetToDefault();
            }
            this.m_169413_();
            this.currentOption = ConfigCategory.General;
            this.Initialize();
        }
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(0, 0);
    }

    @Override
    protected void preButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory> rowList = this.getOptionsRowList(this.currentOption);
        if (rowList != null) {
            rowList.getSecond().m_88315_(guiGraphics, x, y, partialTicks);
            List<FormattedCharSequence> list = GuiPrefab.tooltipAt(rowList.getSecond(), mouseX, mouseY);
            if (list != null) {
                this.m_257959_(list);
            }
        }
        guiGraphics.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 8, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, "Category", this.f_96543_ / 2 - 50, 35, 0xFFFFFF);
    }

    @Override
    protected void postButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
    }

    private void addBooleanOption(OptionsList rowList, ConfigOption<?> configOption) {
        OptionInstance abstractOption = OptionInstance.m_257874_((String)configOption.getName(), (OptionInstance.TooltipSupplier)(!configOption.getHoverText().isEmpty() ? supplierValue -> Tooltip.m_257550_((Component)configOption.getHoverTextComponent()) : OptionInstance.m_231498_()), (boolean)((Boolean)configOption.getConfigValueAsBoolean().get()), newValue -> configOption.getConfigValueAsBoolean().set(newValue));
        rowList.m_232528_(abstractOption);
    }

    private void addIntegerOption(OptionsList rowList, ConfigOption<?> configOption) {
        OptionInstance abstractOption = new OptionInstance(configOption.getName(), OptionInstance.m_231498_(), (component, value) -> Utils.createTextComponent(configOption.getName() + ": " + value), (OptionInstance.ValueSet)new OptionInstance.IntRange(configOption.getMinRange(), configOption.getMaxRange()).m_231657_(toSliderValue -> toSliderValue, fromSliderValue -> fromSliderValue), Codec.intRange((int)configOption.getMinRange(), (int)configOption.getMaxRange()), (Object)((Integer)configOption.getConfigValueAsInt().get()), newValue -> configOption.getConfigValueAsInt().set(newValue));
        rowList.m_232528_(abstractOption);
    }

    private void addStringOption(OptionsList rowList, ConfigOption<?> configOption) {
        OptionInstance abstractOption = new OptionInstance(configOption.getName(), !configOption.getHoverText().isEmpty() ? supplierValue -> Tooltip.m_257550_((Component)configOption.getHoverTextComponent()) : OptionInstance.m_231498_(), (component, value) -> Utils.createTextComponent(configOption.getName() + ": " + value), (OptionInstance.ValueSet)new OptionInstance.Enum(configOption.getValidValues(), Codec.STRING.xmap(value2 -> String.valueOf(configOption.getValidValues().size()), value1 -> String.valueOf(0))), (Object)((String)configOption.getConfigValueAsString().get()), newValue -> {
            int nextIndex = configOption.getValidValues().indexOf(newValue);
            if (nextIndex == -1) {
                nextIndex = 0;
            }
            configOption.getConfigValueAsString().set((Object)configOption.getValidValues().get(nextIndex));
        });
        rowList.m_232528_(abstractOption);
    }

    private Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory> getOptionsRowList(ConfigCategory listName) {
        for (Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory> option : this.optionCollection) {
            if (option.getFirst() != listName) continue;
            return option;
        }
        return null;
    }
}

