/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.screen.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class KeepFastHungerOverlay {
    public static int foodIconsOffset;
    private static final ResourceLocation KEEP_FAST_ICONS_TEXTURE;
    static ResourceLocation FOOD_LEVEL_ELEMENT;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new KeepFastHungerOverlay());
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPost(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)FOOD_LEVEL_ELEMENT)) {
            boolean isMounted;
            Minecraft mc = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            boolean bl = isMounted = mc.f_91074_ != null && mc.f_91074_.m_20202_() instanceof LivingEntity;
            if (!isMounted && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                KeepFastHungerOverlay.renderKeepFastOverlay(gui, event.getGuiGraphics());
            }
        }
    }

    public static void renderKeepFastOverlay(ForgeGui gui, GuiGraphics graphics) {
        foodIconsOffset = gui.rightHeight;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        FoodData stats = player.m_36324_();
        int top = minecraft.m_91268_().m_85446_() - foodIconsOffset + 10;
        int left = minecraft.m_91268_().m_85445_() / 2 + 91;
        if (player.m_21124_((MobEffect)ImmortalersDelightMobEffect.KEEP_A_FAST.get()) != null) {
            KeepFastHungerOverlay.drawKeepFastOverlay(stats, minecraft, graphics, left, top);
        }
    }

    public static void drawKeepFastOverlay(FoodData stats, Minecraft mc, GuiGraphics graphics, int left, int top) {
        float saturation = stats.m_38722_();
        int foodLevel = stats.m_38702_();
        int ticks = mc.f_91065_.m_93079_();
        Random rand = new Random();
        rand.setSeed(ticks * 312871);
        RenderSystem.enableBlend();
        for (int j = 0; j < 10; ++j) {
            int fullSaturationOffset;
            int x = left - j * 8 - 9;
            int y = top;
            if (saturation <= 0.0f && ticks % (foodLevel * 3 + 1) == 0) {
                y = top + (rand.nextInt(3) - 1);
            }
            graphics.m_280218_(KEEP_FAST_ICONS_TEXTURE, x, y - 4, 0, 18, 10, 14);
            float effectiveHungerOfBar = (float)stats.m_38702_() / 2.0f - (float)j;
            float effectiveSaturationOfBar = saturation / 2.0f - (float)j;
            int n = fullSaturationOffset = (double)effectiveSaturationOfBar >= 0.5 ? 20 : 0;
            if (effectiveHungerOfBar >= 1.0f) {
                graphics.m_280218_(KEEP_FAST_ICONS_TEXTURE, x, y - 4, 20 + fullSaturationOffset, 18, 10, 14);
                continue;
            }
            if (!((double)effectiveHungerOfBar >= 0.5)) continue;
            graphics.m_280218_(KEEP_FAST_ICONS_TEXTURE, x, y - 4, 10 + fullSaturationOffset, 18, 10, 14);
        }
        RenderSystem.disableBlend();
    }

    static {
        KEEP_FAST_ICONS_TEXTURE = new ResourceLocation("immortalers_delight", "textures/gui/icons/keep_fast_icons.png");
        FOOD_LEVEL_ELEMENT = new ResourceLocation("minecraft", "food_level");
    }
}

