/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.screen;

import com.renyigesai.immortalers_delight.block.enchantal_cooler.EnchantalCoolerBlockEntity;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EnchantalCoolerMenu
extends AbstractContainerMenu {
    private final EnchantalCoolerBlockEntity blockEntity;
    private final Player player;
    private final IItemHandler playerInventory;

    public EnchantalCoolerMenu(int windowId, Inventory playerInventory, final EnchantalCoolerBlockEntity blockEntity) {
        super((MenuType)ImmortalersDelightMenuTypes.ENCHANTAL_COOLER_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        ItemStackHandler inventory = blockEntity.getInventory();
        this.player = playerInventory.f_35978_;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, 0, 52, 17));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, 1, 70, 17));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, 2, 52, 35));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, 3, 70, 35));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, blockEntity.CONTAINER_SLOT, 137, 55));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, blockEntity.OUTPUT_SLOT, 137, 25){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, blockEntity.FUEL_SLOT, 24, 55){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return blockEntity.isFuel(stack);
            }
        });
        this.layoutPlayerInventorySlots(8, 84);
    }

    public static EnchantalCoolerMenu create(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        BlockPos pos = data.m_130135_();
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(pos);
        if (blockEntity instanceof EnchantalCoolerBlockEntity) {
            return new EnchantalCoolerMenu(windowId, playerInventory, (EnchantalCoolerBlockEntity)blockEntity);
        }
        throw new IllegalStateException("Block entity is not an EnchantalCoolerBlockEntity!");
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack originalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            originalStack = stackInSlot.m_41777_();
            if (slotIndex < 7) {
                if (!this.m_38903_(stackInSlot, 7, 43, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (this.blockEntity.isFuel(stackInSlot) ? !this.m_38903_(stackInSlot, 6, 7, false) : !this.m_38903_(stackInSlot, 0, 6, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(stackInSlot, 0, 6, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == originalStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return originalStack;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.m_6542_(player);
    }

    public EnchantalCoolerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

