/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.potion;

import com.renyigesai.immortalers_delight.event.DifficultyModeHelper;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EsteemedGuestPotionEffect {
    public static final String FRIEND_TO = "immortalers_delight_esteemed_guest_friend_to";
    public static final UUID ESTEEMED_GUEST_FOLLOW_MOD = UUID.fromString("58e46d04-d6a8-4397-a1a9-2f09c919b388");
    public static final UUID ESTEEMED_GUEST_HEALTH_MOD = UUID.fromString("2f945b07-f673-4c32-abbb-eaa86f15787f");

    @SubscribeEvent
    public static void PiglinIgnore(LivingEvent.LivingTickEvent event) {
        AbstractPiglin piglin;
        LivingEntity livingEntity;
        if (!event.getEntity().m_9236_().m_5776_() && (livingEntity = event.getEntity()) instanceof AbstractPiglin && (piglin = (AbstractPiglin)livingEntity).m_5448_() != null) {
            boolean isPowerful = DifficultyModeHelper.isPowerBattleMode();
            boolean flag = isPowerful || piglin.m_21188_() != piglin.m_5448_();
            boolean flag2 = piglin.m_5448_().m_21023_((MobEffect)ImmortalersDelightMobEffect.ESTEEMED_GUEST.get());
            if (piglin.getPersistentData().m_128425_(FRIEND_TO, 11) && piglin.getPersistentData().m_128342_(FRIEND_TO).toString().equals(piglin.m_5448_().m_20148_().toString())) {
                flag2 = true;
            }
            if (flag && flag2) {
                piglin.m_6710_(null);
                piglin.m_21561_(false);
                piglin.m_6274_().m_21886_(MemoryModuleType.f_26334_, Optional.empty());
                piglin.m_6274_().m_21886_(MemoryModuleType.f_148206_, Optional.empty());
                piglin.m_6274_().m_21886_(MemoryModuleType.f_26345_, Optional.empty());
            }
        }
    }

    @SubscribeEvent
    public static void callPiglinFriend(LivingHurtEvent evt) {
        Entity entity;
        if (evt.isCanceled() || evt.getEntity().m_9236_().f_46443_) {
            return;
        }
        boolean isPowerful = DifficultyModeHelper.isPowerBattleMode();
        LivingEntity hurtOne = evt.getEntity();
        if (hurtOne.m_21023_((MobEffect)ImmortalersDelightMobEffect.ESTEEMED_GUEST.get()) && (entity = evt.getSource().m_7639_()) instanceof LivingEntity) {
            float workHealth;
            LivingEntity attacker = (LivingEntity)entity;
            int lv = hurtOne.m_21023_((MobEffect)ImmortalersDelightMobEffect.ESTEEMED_GUEST.get()) ? Objects.requireNonNull(hurtOne.m_21124_((MobEffect)ImmortalersDelightMobEffect.ESTEEMED_GUEST.get())).m_19564_() : 0;
            float f = workHealth = hurtOne.m_21233_() * (float)lv / (float)(2 * (lv + 1)) > (float)(3 * (lv + 1)) ? (float)(3 * (lv + 1)) : hurtOne.m_21233_() * (float)lv / (float)(2 * (lv + 1));
            if (isPowerful) {
                if (hurtOne.m_21223_() - evt.getAmount() < workHealth) {
                    EsteemedGuestPotionEffect.spawnPiglinFriends(hurtOne.m_9236_(), attacker, hurtOne, lv);
                    hurtOne.m_21195_((MobEffect)ImmortalersDelightMobEffect.ESTEEMED_GUEST.get());
                }
            } else if (hurtOne.m_21223_() < workHealth) {
                EsteemedGuestPotionEffect.spawnPiglinFriends(hurtOne.m_9236_(), attacker, hurtOne, lv);
                hurtOne.m_21195_((MobEffect)ImmortalersDelightMobEffect.ESTEEMED_GUEST.get());
            }
        }
    }

    private static void spawnPiglinFriends(Level level, LivingEntity target, LivingEntity friend, int lv) {
        if (!level.m_5776_()) {
            PiglinBrute piglin = (PiglinBrute)EntityType.f_20512_.m_20615_(level);
            if (piglin != null) {
                boolean isPowerful = DifficultyModeHelper.isPowerBattleMode();
                piglin.m_7678_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 0.0f, 0.0f);
                piglin.m_21530_();
                AttributeInstance att = piglin.m_21051_(Attributes.f_22277_);
                if (att != null && att.m_22111_(ESTEEMED_GUEST_FOLLOW_MOD) == null) {
                    att.m_22118_(new AttributeModifier(ESTEEMED_GUEST_FOLLOW_MOD, "esteemed_guest_follow_mod", 64.0, AttributeModifier.Operation.ADDITION));
                }
                if ((att = piglin.m_21051_(Attributes.f_22276_)) != null && att.m_22111_(ESTEEMED_GUEST_HEALTH_MOD) == null) {
                    att.m_22125_(new AttributeModifier(ESTEEMED_GUEST_HEALTH_MOD, "esteemed_guest_health_mod", (double)lv, AttributeModifier.Operation.MULTIPLY_BASE));
                }
                piglin.m_7292_(new MobEffectInstance(MobEffects.f_19601_, lv, 8));
                piglin.m_7292_(new MobEffectInstance(MobEffects.f_19600_, -1, lv > 255 ? 255 : lv, false, false));
                if (isPowerful) {
                    piglin.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42396_));
                    piglin.m_8061_(EquipmentSlot.OFFHAND, EsteemedGuestPotionEffect.createCustomShield());
                    piglin.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42480_));
                    piglin.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42481_));
                    piglin.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42482_));
                    piglin.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42483_));
                } else {
                    piglin.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42433_));
                    piglin.m_8061_(EquipmentSlot.OFFHAND, EsteemedGuestPotionEffect.createCustomShield());
                }
                CompoundTag tag = piglin.getPersistentData();
                if (tag.m_128423_(FRIEND_TO) == null) {
                    tag.m_128362_(FRIEND_TO, friend.m_20148_());
                }
                piglin.m_34670_(true);
                level.m_7967_((Entity)piglin);
                piglin.m_6710_(target);
                piglin.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)target.m_20148_(), 600L);
                piglin.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)target, 600L);
                if (target instanceof Mob) {
                    Mob mob = (Mob)target;
                    AttributeInstance att1 = mob.m_21051_(Attributes.f_22277_);
                    if (att1 != null && att1.m_22111_(ESTEEMED_GUEST_FOLLOW_MOD) == null) {
                        att1.m_22118_(new AttributeModifier(ESTEEMED_GUEST_FOLLOW_MOD, "esteemed_guest_follow_mod", 64.0, AttributeModifier.Operation.ADDITION));
                    }
                    mob.m_6710_((LivingEntity)piglin);
                    mob.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)piglin.m_20148_(), 600L);
                    mob.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)piglin, 600L);
                    if (mob instanceof Warden) {
                        Warden warden = (Warden)mob;
                        warden.m_219387_((Entity)target, AngerLevel.ANGRY.m_219226_() + 20, false);
                        warden.m_219459_(target);
                    }
                }
            }
            for (int i = 0; i < 2; ++i) {
                if (i % 2 == 0) {
                    EsteemedGuestPotionEffect.spawnParticle(friend.m_9236_(), friend.m_20183_(), 1);
                }
                if (i % 2 != 1) continue;
                EsteemedGuestPotionEffect.spawnParticle(target.m_9236_(), target.m_20183_(), 0);
            }
        }
    }

    public static ItemStack createCustomShield() {
        ItemStack shield = new ItemStack((ItemLike)Items.f_42740_);
        CompoundTag shieldTag = new CompoundTag();
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.m_128405_("Base", 9);
        ListTag patterns = new ListTag();
        EsteemedGuestPotionEffect.addPattern(patterns, 11, "gru");
        EsteemedGuestPotionEffect.addPattern(patterns, 5, "bs");
        EsteemedGuestPotionEffect.addPattern(patterns, 13, "bts");
        EsteemedGuestPotionEffect.addPattern(patterns, 15, "flo");
        EsteemedGuestPotionEffect.addPattern(patterns, 15, "moj");
        EsteemedGuestPotionEffect.addPattern(patterns, 15, "glb");
        EsteemedGuestPotionEffect.addPattern(patterns, 3, "mc");
        blockEntityTag.m_128365_("Patterns", (Tag)patterns);
        blockEntityTag.m_128359_("id", "minecraft:banner");
        shieldTag.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
        shieldTag.m_128405_("Damage", 0);
        shield.m_41751_(shieldTag);
        return shield;
    }

    private static void addPattern(ListTag patterns, int color, String patternId) {
        CompoundTag patternTag = new CompoundTag();
        patternTag.m_128405_("Color", color);
        patternTag.m_128359_("Pattern", patternId);
        patterns.add((Object)patternTag);
    }

    private static void spawnParticle(Level level, BlockPos pPos, int type) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5);
            double radius = 1.5;
            for (int i = 0; i < 16; ++i) {
                double angle = Math.PI * 2 * Math.random();
                double r = radius * Math.sqrt(Math.random());
                double x = center.f_82479_ + r * Math.cos(angle);
                double z = center.f_82481_ + r * Math.sin(angle);
                double y = center.f_82480_ + angle * 0.5;
                if (type == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
                }
                if (type != 1) continue;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
            }
        }
    }
}

