/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RepeatingCrossbowItem
extends CrossbowItem {
    private static final String MOD_TAG_CHARGED = "immortalers_delight_charged";
    private static final String MOD_TAG_CHARGED_PROJECTILES = "immortalers_delight_charged_projectiles";
    private static final String BULLET_COUNT = "immortalers_delightremainder_bullet";
    private int maxChargeDuration = 25;
    public int defaultRange = 8;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;
    private float startSoundPercent = 0.2f;
    private float midSoundPercent = 0.5f;
    private float arrowPower = 3.15f;
    private float fireworkPower = 1.6f;

    public RepeatingCrossbowItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static int getBulletCount(ItemStack pCrossbowStack) {
        CompoundTag compoundtag = pCrossbowStack.m_41784_();
        return compoundtag.m_128425_(BULLET_COUNT, 3) ? compoundtag.m_128451_(BULLET_COUNT) : 0;
    }

    public static void setBulletCount(ItemStack pCrossbowStack, int count) {
        CompoundTag compoundtag = pCrossbowStack.m_41784_();
        compoundtag.m_128405_(BULLET_COUNT, count);
    }

    public static boolean isModCharged(ItemStack pCrossbowStack) {
        CompoundTag compoundtag = pCrossbowStack.m_41783_();
        return compoundtag != null && compoundtag.m_128471_(MOD_TAG_CHARGED);
    }

    public static void setModCharged(ItemStack pCrossbowStack, boolean pIsCharged) {
        CompoundTag compoundtag = pCrossbowStack.m_41784_();
        compoundtag.m_128379_(MOD_TAG_CHARGED, pIsCharged);
    }

    private static void addChargedModProjectile(ItemStack pCrossbowStack, ItemStack pAmmoStack) {
        CompoundTag compoundtag = pCrossbowStack.m_41784_();
        ListTag listtag = compoundtag.m_128425_(MOD_TAG_CHARGED_PROJECTILES, 9) ? compoundtag.m_128437_(MOD_TAG_CHARGED_PROJECTILES, 10) : new ListTag();
        CompoundTag compoundtag1 = new CompoundTag();
        pAmmoStack.m_41739_(compoundtag1);
        listtag.add((Object)compoundtag1);
        compoundtag.m_128365_(MOD_TAG_CHARGED_PROJECTILES, (Tag)listtag);
    }

    private static List<ItemStack> getChargedModProjectiles(ItemStack pCrossbowStack) {
        ListTag listtag;
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundtag = pCrossbowStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_(MOD_TAG_CHARGED_PROJECTILES, 9) && (listtag = compoundtag.m_128437_(MOD_TAG_CHARGED_PROJECTILES, 10)) != null) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundtag1));
            }
        }
        return list;
    }

    private static void clearChargedModProjectiles(ItemStack pCrossbowStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)pCrossbowStack) > 0 ? 3 : 1;
        CompoundTag compoundtag = pCrossbowStack.m_41783_();
        if (compoundtag != null) {
            ListTag listtag = compoundtag.m_128437_(MOD_TAG_CHARGED_PROJECTILES, 10);
            for (int j = 0; j < i; ++j) {
                if (listtag.isEmpty()) continue;
                listtag.remove(listtag.size() - 1);
            }
            compoundtag.m_128365_(MOD_TAG_CHARGED_PROJECTILES, (Tag)listtag);
        }
    }

    public static boolean containsChargedModProjectile(ItemStack pCrossbowStack, Item pAmmoItem) {
        return RepeatingCrossbowItem.getChargedModProjectiles(pCrossbowStack).stream().anyMatch(p_40870_ -> p_40870_.m_150930_(pAmmoItem));
    }

    public Predicate<ItemStack> m_6442_() {
        return f_43006_;
    }

    public Predicate<ItemStack> m_6437_() {
        return f_43005_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (RepeatingCrossbowItem.isModCharged(itemstack)) {
            RepeatingCrossbowItem.modPerformShooting(pLevel, (LivingEntity)pPlayer, pHand, itemstack, RepeatingCrossbowItem.getShootingModPower(itemstack), 1.0f);
            if (RepeatingCrossbowItem.getChargedModProjectiles(itemstack).isEmpty()) {
                RepeatingCrossbowItem.setModCharged(itemstack, false);
                pPlayer.m_36335_().m_41524_(itemstack.m_41720_(), RepeatingCrossbowItem.getModCoolDown(itemstack));
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!pPlayer.m_6298_(itemstack).m_41619_()) {
            if (!RepeatingCrossbowItem.isModCharged(itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                pPlayer.m_6672_(pHand);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    private static float getShootingModPower(ItemStack pCrossbowStack) {
        return RepeatingCrossbowItem.containsChargedModProjectile(pCrossbowStack, Items.f_42688_) ? 1.6f : 3.15f;
    }

    /*
     * Unable to fully structure code
     */
    public static void modPerformShooting(Level pLevel, LivingEntity pShooter, InteractionHand pUsedHand, ItemStack pCrossbowStack, float pVelocity, float pInaccuracy) {
        if (pShooter instanceof Player) {
            player = (Player)pShooter;
            if (ForgeEventFactory.onArrowLoose((ItemStack)pCrossbowStack, (Level)pShooter.m_9236_(), (Player)player, (int)1, (boolean)true) < 0) {
                return;
            }
        }
        flag1 = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)pCrossbowStack) > 0;
        list = RepeatingCrossbowItem.getChargedModProjectiles(pCrossbowStack);
        afloat = RepeatingCrossbowItem.getModShotPitches(pShooter.m_217043_());
        for (i = 0; i < list.size(); ++i) {
            block7: {
                itemstack = list.get(i);
                if (itemstack.m_41619_()) continue;
                if (!(pShooter instanceof Player)) break block7;
                player = (Player)pShooter;
                if (player.m_150110_().f_35937_) ** GOTO lbl-1000
            }
            if (itemstack != list.get(0)) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = flag = false;
            }
            if (i == list.size() - 1) {
                RepeatingCrossbowItem.shootModProjectile(pLevel, pShooter, pUsedHand, pCrossbowStack, itemstack, afloat[i % 3], flag, pVelocity, pInaccuracy, 0.0f);
            }
            if (!flag1) continue;
            if (i == list.size() - 2) {
                RepeatingCrossbowItem.shootModProjectile(pLevel, pShooter, pUsedHand, pCrossbowStack, itemstack, afloat[i % 3], flag, pVelocity, pInaccuracy, -10.0f);
                continue;
            }
            if (i != list.size() - 3) continue;
            RepeatingCrossbowItem.shootModProjectile(pLevel, pShooter, pUsedHand, pCrossbowStack, itemstack, afloat[i % 3], flag, pVelocity, pInaccuracy, 10.0f);
        }
        RepeatingCrossbowItem.onModCrossbowShot(pLevel, pShooter, pCrossbowStack);
    }

    private static void shootModProjectile(Level pLevel, LivingEntity pShooter, InteractionHand pHand, ItemStack pCrossbowStack, ItemStack pAmmoStack, float pSoundPitch, boolean pNoTrueArrow, float pVelocity, float pInaccuracy, float pProjectileAngle) {
        if (!pLevel.f_46443_) {
            AbstractArrow projectile;
            boolean flag = pAmmoStack.m_150930_(Items.f_42688_);
            if (flag) {
                projectile = new FireworkRocketEntity(pLevel, pAmmoStack, (Entity)pShooter, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.15f, pShooter.m_20189_(), true);
            } else {
                projectile = RepeatingCrossbowItem.getModArrow(pLevel, pShooter, pCrossbowStack, pAmmoStack);
                if (pNoTrueArrow) {
                    projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (pShooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowattackmob = (CrossbowAttackMob)pShooter;
                crossbowattackmob.m_5811_(crossbowattackmob.m_5448_(), pCrossbowStack, (Projectile)projectile, pProjectileAngle);
            } else {
                Vec3 vec31 = pShooter.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(pProjectileAngle * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                Vec3 vec3 = pShooter.m_20252_(1.0f);
                Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
                projectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), pVelocity, pInaccuracy);
            }
            pCrossbowStack.m_41622_(flag ? 3 : 1, pShooter, p_40858_ -> p_40858_.m_21190_(pHand));
            pLevel.m_7967_((Entity)projectile);
            pLevel.m_6263_((Player)null, pShooter.m_20185_(), pShooter.m_20186_(), pShooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, pSoundPitch);
        }
    }

    private static AbstractArrow getModArrow(Level pLevel, LivingEntity pLivingEntity, ItemStack pCrossbowStack, ItemStack pAmmoStack) {
        ArrowItem arrowitem = (ArrowItem)(pAmmoStack.m_41720_() instanceof ArrowItem ? pAmmoStack.m_41720_() : Items.f_42412_);
        AbstractArrow abstractarrow = arrowitem.m_6394_(pLevel, pAmmoStack, pLivingEntity);
        if (pLivingEntity instanceof Player) {
            abstractarrow.m_36762_(true);
        }
        abstractarrow.m_36740_(SoundEvents.f_11840_);
        abstractarrow.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)pCrossbowStack);
        if (i > 0) {
            abstractarrow.m_36767_((byte)i);
        }
        return abstractarrow;
    }

    private static float[] getModShotPitches(RandomSource pRandom) {
        boolean flag = pRandom.m_188499_();
        return new float[]{1.0f, RepeatingCrossbowItem.getModRandomShotPitch(flag, pRandom), RepeatingCrossbowItem.getModRandomShotPitch(!flag, pRandom)};
    }

    private static float getModRandomShotPitch(boolean pIsHighPitched, RandomSource pRandom) {
        float f = pIsHighPitched ? 0.63f : 0.43f;
        return 1.0f / (pRandom.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static void onModCrossbowShot(Level pLevel, LivingEntity pShooter, ItemStack pCrossbowStack) {
        if (pShooter instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)pShooter;
            if (!pLevel.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverplayer, pCrossbowStack);
            }
            serverplayer.m_36246_(Stats.f_12982_.m_12902_((Object)pCrossbowStack.m_41720_()));
        }
        RepeatingCrossbowItem.clearChargedModProjectiles(pCrossbowStack);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        int i = this.m_8105_(pStack) - pTimeLeft;
        float f = RepeatingCrossbowItem.getModPowerForTime(i, pStack);
        if (f >= 1.0f && !RepeatingCrossbowItem.isModCharged(pStack) && RepeatingCrossbowItem.tryLoadModProjectiles(pEntityLiving, pStack)) {
            RepeatingCrossbowItem.setModCharged(pStack, true);
            SoundSource soundsource = pEntityLiving instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            pLevel.m_6263_((Player)null, pEntityLiving.m_20185_(), pEntityLiving.m_20186_(), pEntityLiving.m_20189_(), SoundEvents.f_11841_, soundsource, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadModProjectiles(LivingEntity pShooter, ItemStack pCrossbowStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)pCrossbowStack);
        int j = i == 0 ? 3 : 9;
        boolean flag = pShooter instanceof Player && ((Player)pShooter).m_150110_().f_35937_;
        ItemStack itemstack = pShooter.m_6298_(pCrossbowStack);
        ItemStack itemstack1 = itemstack.m_41777_();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.m_41777_();
            }
            if (itemstack.m_41619_() && flag) {
                itemstack = new ItemStack((ItemLike)Items.f_42412_);
                itemstack1 = itemstack.m_41777_();
            }
            if (RepeatingCrossbowItem.loadModProjectile(pShooter, pCrossbowStack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadModProjectile(LivingEntity pShooter, ItemStack pCrossbowStack, ItemStack pAmmoStack, boolean pHasAmmo, boolean pIsCreative) {
        ItemStack itemstack;
        boolean flag;
        if (pAmmoStack.m_41619_()) {
            return false;
        }
        boolean bl = flag = pIsCreative && pAmmoStack.m_41720_() instanceof ArrowItem;
        if (!(flag || pIsCreative || pHasAmmo)) {
            itemstack = pAmmoStack.m_41620_(1);
            if (pAmmoStack.m_41619_() && pShooter instanceof Player) {
                ((Player)pShooter).m_150109_().m_36057_(pAmmoStack);
            }
        } else {
            itemstack = pAmmoStack.m_41777_();
        }
        RepeatingCrossbowItem.addChargedModProjectile(pCrossbowStack, itemstack);
        return true;
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pCount) {
        if (!pLevel.f_46443_) {
            int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)pStack);
            SoundEvent soundevent = this.m_40851_(i);
            SoundEvent soundevent1 = i == 0 ? SoundEvents.f_11842_ : null;
            float f = (float)(pStack.m_41779_() - pCount) / (float)RepeatingCrossbowItem.getModChargeDuration(pStack);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                pLevel.m_6263_((Player)null, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), soundevent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                pLevel.m_6263_((Player)null, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), soundevent1, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int m_8105_(ItemStack pStack) {
        return RepeatingCrossbowItem.getModChargeDuration(pStack) + 3;
    }

    public static int getModChargeDuration(ItemStack pCrossbowStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)pCrossbowStack);
        return i == 0 ? 45 : 45 - 5 * i;
    }

    public static int getModCoolDown(ItemStack pCrossbowStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)pCrossbowStack);
        return i == 0 ? 200 : 200 - 20 * i;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.CROSSBOW;
    }

    private SoundEvent m_40851_(int pEnchantmentLevel) {
        switch (pEnchantmentLevel) {
            case 1: {
                return SoundEvents.f_11844_;
            }
            case 2: {
                return SoundEvents.f_11845_;
            }
            case 3: {
                return SoundEvents.f_11846_;
            }
        }
        return SoundEvents.f_11843_;
    }

    private static float getModPowerForTime(int pUseTime, ItemStack pCrossbowStack) {
        float f = (float)pUseTime / (float)RepeatingCrossbowItem.getModChargeDuration(pCrossbowStack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        List<ItemStack> list = RepeatingCrossbowItem.getChargedModProjectiles(pStack);
        if (RepeatingCrossbowItem.isModCharged(pStack) && !list.isEmpty()) {
            MutableComponent textValue = Component.m_237110_((String)"tooltip.immortalers_delight.charged_projectiles", (Object[])new Object[]{list.size()});
            pTooltip.add((Component)textValue.m_130940_(ChatFormatting.WHITE));
            ItemStack itemstack = list.get(0);
            pTooltip.add((Component)Component.m_237115_((String)"item.minecraft.crossbow.projectile").m_7220_(CommonComponents.f_263701_).m_7220_(itemstack.m_41611_()));
            if (pFlag.m_7050_() && itemstack.m_150930_(Items.f_42688_)) {
                ArrayList list1 = Lists.newArrayList();
                Items.f_42688_.m_7373_(itemstack, pLevel, (List)list1, pFlag);
                if (!list1.isEmpty()) {
                    for (int i = 0; i < list1.size(); ++i) {
                        list1.set(i, Component.m_237113_((String)"  ").m_7220_((Component)list1.get(i)).m_130940_(ChatFormatting.GRAY));
                    }
                    pTooltip.addAll(list1);
                }
            }
        }
    }

    public boolean m_41463_(ItemStack pStack) {
        return pStack.m_150930_((Item)this);
    }

    public int m_6615_() {
        return 8;
    }
}

