/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.renyigesai.immortalers_delight.event.DifficultyModeHelper;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.KnifeItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class ImmortalersKnifeItem
extends KnifeItem {
    public static final String ANCIENT_KNIFE_COMBO_SKILL = "immortalers_delight_ancient_knife_combo_skill";
    private int type_id;
    private final float attackDamage;
    private final float attackSpeed;

    public int getTypeId() {
        return this.type_id;
    }

    public ImmortalersKnifeItem(int type, Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
        this.type_id = type;
        this.attackDamage = attackDamage + tier.m_6631_();
        this.attackSpeed = attackSpeed;
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)stack);
        boolean isPowerful = DifficultyModeHelper.isPowerBattleMode();
        int type = this.type_id;
        if (type == 2 && enchantment == Enchantments.f_44982_) {
            level += isPowerful ? 4 : 2;
        }
        return level;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        boolean isPowerful = DifficultyModeHelper.isPowerBattleMode();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage + (double)(isPowerful ? 2.0f : 0.0f), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
            return multimap;
        }
        return super.m_7167_(equipmentSlot);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (this.type_id == 1) {
                MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + this), (Object[])new Object[0]);
                tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
            }
            if (this.type_id == 2) {
                for (int i = 0; i < 3; ++i) {
                    MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + this + "." + (Serializable)(i == 2 && DifficultyModeHelper.isPowerBattleMode() ? "power" : Integer.valueOf(i))), (Object[])new Object[0]);
                    if (i == 1) {
                        tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.GRAY));
                        continue;
                    }
                    if (i == 2) {
                        tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.DARK_GREEN));
                        continue;
                    }
                    tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ImmortalersKnifeEvents {
        @SubscribeEvent
        public static void ImmortalersKnifeAttack(LivingHurtEvent event) {
            Item item;
            LivingEntity attacker;
            ItemStack toolStack;
            if (event.isCanceled()) {
                return;
            }
            boolean isPowerful = DifficultyModeHelper.isPowerBattleMode();
            LivingEntity hurtOne = event.getEntity();
            if (hurtOne.m_9236_().f_46443_) {
                return;
            }
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity && !(toolStack = (attacker = (LivingEntity)entity).m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && (item = toolStack.m_41720_()) instanceof ImmortalersKnifeItem) {
                ItemStack toolStack2;
                ImmortalersKnifeItem knife = (ImmortalersKnifeItem)item;
                if (knife.getTypeId() == 1) {
                    hurtOne.m_7292_(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.WEAK_WITHER.get(), 320, isPowerful ? 2 : 1));
                }
                if (knife.getTypeId() == 2 && !(toolStack2 = attacker.m_21120_(InteractionHand.OFF_HAND)).m_41619_() && toolStack2.m_150930_((Item)ImmortalersDelightItems.ANCIENT_BLADE.get())) {
                    float buffer = event.getAmount() * 0.6f;
                    if (!isPowerful && buffer > 4.0f) {
                        buffer = 4.0f;
                    }
                    event.setAmount(event.getAmount() + buffer);
                    if (attacker instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)attacker;
                        if (!serverPlayer.m_150110_().f_35937_) {
                            toolStack2.m_41622_(1, (LivingEntity)serverPlayer, action -> action.m_21190_(InteractionHand.OFF_HAND));
                        }
                    }
                }
            }
        }
    }
}

