/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.fluid;

import com.renyigesai.immortalers_delight.fluid.ImmortalersDelightFluids;
import com.renyigesai.immortalers_delight.recipe.HotSpringRecipe;
import com.renyigesai.immortalers_delight.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;

public class HotSpringFluidsBlock
extends LiquidBlock {
    public HotSpringFluidsBlock() {
        super(ImmortalersDelightFluids.HOT_SPRING, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_60978_(100.0f).m_60910_().m_222994_().m_278788_().m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_279557_).m_280170_().m_60977_());
    }

    private Optional<HotSpringRecipe> getCurrentRecipe(Level level, List<ItemStack> list) {
        int i;
        SimpleContainer inventory = new SimpleContainer(6);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (i = 0; i < list.size(); ++i) {
            ItemStack stack = list.get(i);
            if (stack.m_41619_()) continue;
            inputs.add(stack);
        }
        for (i = 0; i < inputs.size(); ++i) {
            inventory.m_6836_(i, (ItemStack)inputs.get(i));
        }
        return level.m_7465_().m_44015_((RecipeType)HotSpringRecipe.Type.INSTANCE, (Container)inventory, level);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_214162_(pState, pLevel, pPos, pRandom);
        if (this.isHeatSources(pLevel, pPos)) {
            double x = pPos.m_123341_();
            double y = pPos.m_7494_().m_123342_();
            double z = pPos.m_123343_();
            Random random = new Random();
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123759_, x + random.nextDouble(-0.5, 0.5), y, z + random.nextDouble(-0.5, 0.5), 0.0, 0.0, 0.0);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.craftTick((Level)pLevel, pPos);
    }

    public boolean isHeatSources(Level level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("farmersdelight:heat_sources")));
    }

    private void craftTick(Level level, BlockPos pos) {
        List itemEntityList = level.m_45976_(ItemEntity.class, new AABB(pos, pos).m_82377_(1.0, 1.0, 1.0));
        if (itemEntityList.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < itemEntityList.size(); ++i) {
            ItemStack item = ((ItemEntity)itemEntityList.get(i)).m_32055_();
            if (item.m_41619_() || item.m_41613_() != 1) continue;
            stackList.add(i, item);
        }
        if (stackList.isEmpty()) {
            return;
        }
        Optional<HotSpringRecipe> recipeOptional = this.getCurrentRecipe(level, stackList);
        if (recipeOptional.isEmpty()) {
            return;
        }
        HotSpringRecipe recipe = recipeOptional.get();
        ItemStack resultItem = recipe.m_8043_(level.m_9598_()).m_41777_();
        for (int i = 0; i < itemEntityList.size(); ++i) {
            ItemEntity itemEntity = (ItemEntity)itemEntityList.get(i);
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        ItemUtils.spawnItemEntity(level, resultItem, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8, 0.0, 0.0, 0.0, 0.0);
            level.m_247517_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.m_7892_(pState, pLevel, pPos, pEntity);
        if (!this.isHeatSources(pLevel, pPos)) {
            return;
        }
        if (pEntity instanceof ItemEntity) {
            pLevel.m_186460_(pPos, (Block)this, 5);
        }
    }
}

