/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.event;

import com.renyigesai.immortalers_delight.Config;
import com.renyigesai.immortalers_delight.api.event.SnifferDropSeedEvent;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightTags;
import com.renyigesai.immortalers_delight.util.WorldUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.utility.ItemUtils;

@Mod.EventBusSubscriber
public class SnifferEvent {
    public static final String SNIFFER_BRUSHING_COOLDOWN = "immortalers_delight_sniffer_brushing_cooldown";

    @SubscribeEvent
    public static void onDropSeed(SnifferDropSeedEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = event.getBlockPos();
            Holder biomeHolder = event.getLevel().m_204166_(pos);
            for (Map.Entry<TagKey<Biome>, List<ItemStack>> key : SnifferEvent.getSeeds((Level)serverLevel, pos).entrySet()) {
                TagKey<Biome> tagKey = key.getKey();
                if (!biomeHolder.m_203656_(tagKey) || !(Math.random() < Config.mininProbability)) continue;
                HashMap<TagKey<Biome>, List<ItemStack>> seeds = SnifferEvent.getSeeds((Level)serverLevel, pos);
                event.setStacks(seeds.get(tagKey));
            }
        }
    }

    private static HashMap<TagKey<Biome>, List<ItemStack>> getSeeds(Level level, BlockPos pos) {
        HashMap<TagKey<Biome>, List<ItemStack>> itemStackHashMap = new HashMap<TagKey<Biome>, List<ItemStack>>();
        itemStackHashMap.put(BiomeTags.f_207610_, WorldUtils.getFromLootTableItemStack(WorldUtils.getLootTables("immortalers_delight:gameplay/id_sniffer_jungle", level), level, pos));
        itemStackHashMap.put(Tags.Biomes.IS_PLAINS, WorldUtils.getFromLootTableItemStack(WorldUtils.getLootTables("immortalers_delight:gameplay/id_sniffer_plains", level), level, pos));
        itemStackHashMap.put(BiomeTags.f_207611_, WorldUtils.getFromLootTableItemStack(WorldUtils.getLootTables("immortalers_delight:gameplay/id_sniffer_forest", level), level, pos));
        itemStackHashMap.put(BiomeTags.f_207605_, WorldUtils.getFromLootTableItemStack(WorldUtils.getLootTables("immortalers_delight:gameplay/id_sniffer_river", level), level, pos));
        itemStackHashMap.put(ImmortalersDelightTags.IS_CRIMSON_FOREST, WorldUtils.getFromLootTableItemStack(WorldUtils.getLootTables("immortalers_delight:gameplay/id_sniffer_crimson_forest", level), level, pos));
        itemStackHashMap.put(ImmortalersDelightTags.IS_WARPED_FOREST, WorldUtils.getFromLootTableItemStack(WorldUtils.getLootTables("immortalers_delight:gameplay/id_sniffer_warped_forest", level), level, pos));
        return itemStackHashMap;
    }

    @SubscribeEvent
    public static void snifferPrune(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity;
        if (event.getEntity() != null && (entity = event.getTarget()) instanceof Sniffer) {
            Sniffer sniffer = (Sniffer)entity;
            Player player = event.getEntity();
            Level level = player.m_9236_();
            int outputNumber = 0;
            CompoundTag tag = sniffer.getPersistentData();
            if (tag.m_128423_(SNIFFER_BRUSHING_COOLDOWN) == null) {
                tag.m_128405_(SNIFFER_BRUSHING_COOLDOWN, 0);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (player instanceof ServerPlayer) {
                    ItemStack itemStack;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if ((!tag.m_128425_(SNIFFER_BRUSHING_COOLDOWN, 3) || tag.m_128451_(SNIFFER_BRUSHING_COOLDOWN) <= 0) && (itemStack = event.getItemStack()).m_41720_() instanceof ShearsItem) {
                        outputNumber += 1 + player.m_217043_().m_188503_(3);
                        if (!player.m_150110_().f_35937_) {
                            tag.m_128405_(SNIFFER_BRUSHING_COOLDOWN, 10140);
                            itemStack.m_41622_(125, (LivingEntity)serverPlayer, action -> action.m_21190_(event.getHand()));
                        }
                    }
                }
            }
            if (outputNumber > 0) {
                BlockPos pos = player.m_20097_().m_7494_();
                ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)ImmortalersDelightItems.SNIFFER_FUR.get(), outputNumber), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (double)0.0, (double)0.0, (double)0.0);
            }
        }
    }

    @SubscribeEvent
    public static void snifferBrushing(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (event.getEntity() != null && (entity = event.getTarget()) instanceof Sniffer) {
            Sniffer sniffer = (Sniffer)entity;
            Player player = event.getEntity();
            Level level = player.m_9236_();
            CompoundTag tag = sniffer.getPersistentData();
            if (tag.m_128423_(SNIFFER_BRUSHING_COOLDOWN) == null) {
                tag.m_128405_(SNIFFER_BRUSHING_COOLDOWN, 0);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (player instanceof ServerPlayer) {
                    ItemStack oldStack;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (!(tag.m_128425_(SNIFFER_BRUSHING_COOLDOWN, 3) && tag.m_128451_(SNIFFER_BRUSHING_COOLDOWN) > 0 || (oldStack = event.getItemStack()).m_41720_() != Items.f_271356_)) {
                        ItemStack newStack = new ItemStack((ItemLike)ImmortalersDelightItems.BRUSH.get(), oldStack.m_41613_(), SnifferEvent.getItemStackCapNBT(oldStack));
                        newStack.m_41754_(oldStack.m_41612_());
                        if (oldStack.m_41783_() != null) {
                            newStack.m_41751_(oldStack.m_41783_());
                        }
                        player.m_21008_(event.getHand(), newStack);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void snifferCooldown(LivingEvent.LivingTickEvent event) {
        Player player;
        Sniffer sniffer;
        CompoundTag tag;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Sniffer && (tag = (sniffer = (Sniffer)livingEntity).getPersistentData()).m_128425_(SNIFFER_BRUSHING_COOLDOWN, 3) && tag.m_128451_(SNIFFER_BRUSHING_COOLDOWN) > 0) {
            tag.m_128405_(SNIFFER_BRUSHING_COOLDOWN, tag.m_128451_(SNIFFER_BRUSHING_COOLDOWN) - 1);
        }
        if (!event.getEntity().m_9236_().m_5776_() && (tag = event.getEntity()) instanceof Player && (player = (Player)tag).m_21212_() <= 0) {
            ItemStack oldStack = new ItemStack((ItemLike)Items.f_41852_);
            if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() == ImmortalersDelightItems.BRUSH.get()) {
                oldStack = player.m_21120_(InteractionHand.OFF_HAND);
            }
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == ImmortalersDelightItems.BRUSH.get()) {
                oldStack = player.m_21120_(InteractionHand.MAIN_HAND);
            }
            if (!oldStack.m_41619_()) {
                EquipmentSlot equipmentslot = oldStack.equals(player.m_6844_(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                ItemStack newStack = new ItemStack((ItemLike)Items.f_271356_, oldStack.m_41613_(), SnifferEvent.getItemStackCapNBT(oldStack));
                newStack.m_41754_(oldStack.m_41612_());
                if (oldStack.m_41783_() != null) {
                    newStack.m_41751_(oldStack.m_41783_());
                }
                player.m_8061_(equipmentslot, newStack);
            }
        }
    }

    private static CompoundTag getItemStackCapNBT(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        try {
            Method method = CapabilityProvider.class.getDeclaredMethod("serializeCaps", new Class[0]);
            method.setAccessible(true);
            CompoundTag value = (CompoundTag)method.invoke((Object)itemStack, new Object[0]);
            if (value != null) {
                tag = value.m_6426_();
            } else {
                System.out.println("\u6211\u4eecget\u5230\u4e86null\u503c\uff0c\u600e\u4e48\u4f1a\u8fd9\u6837\u5462\uff1f");
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            System.out.println("\u83b7\u53d6capNBT\u5b57\u6bb5\u5931\u8d25");
            e.printStackTrace();
        }
        return tag;
    }
}

