/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.event;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.immortalers_delight.event.DifficultyModeHelper;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightFoodProperties;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.util.task.TimekeepingTask;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.utility.ItemUtils;

@Mod.EventBusSubscriber
public class FoodItemEventHelper {
    public static final String DELETE_PIGLIN = "immortalers_delight_delete_piglin";

    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        if (event != null && event.getEntity() != null) {
            LivingEntity livingEntity;
            ItemStack stack = event.getItem();
            LivingEntity entity = event.getEntity();
            if (entity instanceof LivingEntity && !(livingEntity = entity).m_9236_().m_5776_() && stack.m_41720_().m_41472_()) {
                if (stack.getFoodProperties(livingEntity) == ImmortalersDelightFoodProperties.RED_STUFFED_BUN) {
                    if (DifficultyModeHelper.isPowerBattleMode()) {
                        if (livingEntity.m_217043_().m_188503_(3) == 0) {
                            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 6000, 3));
                            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 2700));
                        }
                    } else if (livingEntity.m_217043_().m_188503_(3) == 0) {
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 6000, 1));
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 600));
                    }
                }
                if (stack.getFoodProperties(livingEntity) == ImmortalersDelightFoodProperties.PEARLIP_BUBBLE_MILK) {
                    livingEntity.curePotionEffects(new ItemStack((ItemLike)Items.f_42455_));
                    for (Pair pair : Objects.requireNonNull(stack.getFoodProperties(livingEntity)).m_38749_()) {
                        livingEntity.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent evt) {
        if (evt.isCanceled() || evt.getSource().m_269533_(DamageTypeTags.f_268630_)) {
            return;
        }
        boolean isPowerful = DifficultyModeHelper.isPowerBattleMode();
        LivingEntity hurtOne = evt.getEntity();
        LivingEntity attacker = null;
        Entity entity = evt.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            attacker = livingEntity = (LivingEntity)entity;
        }
        if (!hurtOne.m_9236_().f_46443_ && hurtOne.m_21211_().m_41720_() == ImmortalersDelightItems.EVOLUTCORN_HARD_CANDY.get() && hurtOne.m_21252_() > (isPowerful ? 16 : 32)) {
            if (isPowerful) {
                float buffer = 0.4f - 0.6f * (float)hurtOne.m_21252_() / (float)hurtOne.m_21211_().m_41779_();
                if (buffer > 0.0f) {
                    evt.setAmount(evt.getAmount() * buffer);
                } else {
                    hurtOne.m_5634_(evt.getAmount() * buffer * -1.0f);
                    evt.setCanceled(true);
                }
            } else {
                evt.setAmount(evt.getAmount() * 0.4f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerFeed(PlayerInteractEvent.EntityInteractSpecific event) {
        block8: {
            ServerLevel serverLevel;
            ItemStack itemStack;
            Level level;
            Player player;
            LivingEntity target;
            block10: {
                block9: {
                    Entity entity;
                    if (event.getEntity() == null || !((entity = event.getTarget()) instanceof LivingEntity)) break block8;
                    target = (LivingEntity)entity;
                    player = event.getEntity();
                    level = player.m_9236_();
                    itemStack = event.getItemStack();
                    if (!(level instanceof ServerLevel)) break block9;
                    serverLevel = (ServerLevel)level;
                    if (itemStack != ItemStack.f_41583_) break block10;
                }
                return;
            }
            if (itemStack.m_41720_() == ImmortalersDelightItems.CLEAR_WATER_VODKA.get()) {
                FoodItemEventHelper.addInebriatedEffect(itemStack, (Level)serverLevel, target);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                    BlockPos pos = player.m_20097_().m_7494_();
                    ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)Items.f_42590_), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (double)0.0, (double)0.0, (double)0.0);
                }
            }
            if (itemStack.m_41720_() == ImmortalersDelightItems.GOLDEN_KWAT_TOAST.get() && target instanceof PiglinBrute) {
                PiglinBrute piglin = (PiglinBrute)target;
                player.m_7292_(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.ESTEEMED_GUEST.get(), 48000, 1));
                piglin.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)ImmortalersDelightItems.GOLDEN_KWAT_TOAST.get()));
                CompoundTag tag = piglin.getPersistentData();
                if (tag.m_128423_(DELETE_PIGLIN) == null) {
                    tag.m_128356_(DELETE_PIGLIN, TimekeepingTask.getImmortalTickTime().longValue());
                }
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
        }
    }

    private static void addInebriatedEffect(ItemStack stack, Level level, LivingEntity livingEntity) {
        Item item = stack.m_41720_();
        if (item.m_41472_()) {
            for (Pair pair : stack.getFoodProperties(livingEntity).m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null) continue;
                if (((MobEffectInstance)pair.getFirst()).m_19544_() == ImmortalersDelightMobEffect.INEBRIATED.get()) {
                    int oldLv = livingEntity.m_21023_((MobEffect)ImmortalersDelightMobEffect.INEBRIATED.get()) ? livingEntity.m_21124_((MobEffect)ImmortalersDelightMobEffect.INEBRIATED.get()).m_19564_() : 0;
                    int oldTime = livingEntity.m_21023_((MobEffect)ImmortalersDelightMobEffect.INEBRIATED.get()) ? livingEntity.m_21124_((MobEffect)ImmortalersDelightMobEffect.INEBRIATED.get()).m_19557_() : 0;
                    int time = ((MobEffectInstance)pair.getFirst()).m_19557_() + oldTime;
                    int lv = ((MobEffectInstance)pair.getFirst()).m_19564_() > oldLv ? ((MobEffectInstance)pair.getFirst()).m_19564_() : oldLv;
                    livingEntity.m_7292_(new MobEffectInstance(((MobEffectInstance)pair.getFirst()).m_19544_(), time, lv));
                    continue;
                }
                livingEntity.m_7292_((MobEffectInstance)pair.getFirst());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        AbstractPiglin piglin;
        LivingEntity livingEntity;
        if (!event.getEntity().m_9236_().m_5776_() && (livingEntity = event.getEntity()) instanceof AbstractPiglin && (piglin = (AbstractPiglin)livingEntity).getPersistentData().m_128425_(DELETE_PIGLIN, 4)) {
            if (TimekeepingTask.getImmortalTickTime() % 500L <= 50L) {
                FoodItemEventHelper.spawnParticle(piglin.m_9236_(), piglin.m_20183_(), 0);
            }
            if (TimekeepingTask.getImmortalTickTime() == 4000L + piglin.getPersistentData().m_128454_(DELETE_PIGLIN)) {
                for (int i = 0; i < 2; ++i) {
                    FoodItemEventHelper.spawnParticle(piglin.m_9236_(), piglin.m_20183_(), 1);
                }
                piglin.m_9236_().m_7785_(piglin.m_20185_(), piglin.m_20186_(), piglin.m_20189_(), SoundEvents.f_12241_, SoundSource.HOSTILE, 0.8f, 0.8f, false);
                piglin.m_146870_();
            }
        }
    }

    private static void spawnParticle(Level level, BlockPos pPos, int type) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5);
            double radius = 0.32 + (double)type;
            for (int i = 0; i < 3 + 12 * type; ++i) {
                double angle = Math.PI * 2 * Math.random();
                double r = radius * Math.sqrt(Math.random());
                double x = center.f_82479_ + r * Math.cos(angle);
                double z = center.f_82481_ + r * Math.sin(angle);
                double y = center.f_82480_;
                if (type == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
                }
                if (type != 1) continue;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
            }
        }
    }
}

