/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.living;

import com.renyigesai.immortalers_delight.screen.TerracottaGolemMenu;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerracottaGolem
extends TamableAnimal
implements ContainerListener,
HasCustomInventoryScreen,
RangedAttackMob,
NeutralMob {
    private static final EntityDataAccessor<Byte> DATA_ID_DECORATE_LEFT = SynchedEntityData.m_135353_(TerracottaGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> DATA_ID_DECORATE_BACK = SynchedEntityData.m_135353_(TerracottaGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> DATA_ID_DECORATE_RIGHT = SynchedEntityData.m_135353_(TerracottaGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(TerracottaGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int FLAG_TAME = 2;
    private static final int FLAG_SADDLE = 4;
    private static final int FLAG_BRED = 8;
    private static final int FLAG_EATING = 16;
    private static final int FLAG_STANDING = 32;
    private static final int FLAG_OPEN_MOUTH = 64;
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    public static final int INV_SLOT_LEFT = 0;
    public static final int INV_SLOT_BACK = 1;
    public static final int INV_SLOT_RIGHT = 2;
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.m_135353_(TerracottaGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(TerracottaGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(TerracottaGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = p_289448_ -> {
        EntityType entitytype = p_289448_.m_6095_();
        return entitytype == EntityType.f_20520_ || entitytype == EntityType.f_20517_ || entitytype == EntityType.f_20452_;
    };
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @javax.annotation.Nullable
    private UUID persistentAngerTarget;
    public static final AnimationState idleAnimationState = new AnimationState();
    public int idleAnimationTimeOut = 0;
    public static final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeOut = 0;

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor pCollarColor) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)pCollarColor.m_41060_());
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INTERESTED_ID);
    }

    public void setIsInterested(boolean pIsInterested) {
        this.f_19804_.m_135381_(DATA_INTERESTED_ID, (Object)pIsInterested);
    }

    protected boolean getFlag(int pFlagId) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & pFlagId) != 0;
    }

    protected void setFlag(int pFlagId, boolean pValue) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (pValue) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | pFlagId)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~pFlagId)));
        }
    }

    public boolean isEating() {
        return this.getFlag(16);
    }

    public boolean isStanding() {
        return this.getFlag(32);
    }

    public boolean isBred() {
        return this.getFlag(8);
    }

    public void setBred(boolean pBreeding) {
        this.setFlag(8, pBreeding);
    }

    public boolean isSaddleable() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    public void equipSaddle(@javax.annotation.Nullable SoundSource pSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public void equipArmor(Player pPlayer, ItemStack pArmor) {
        if (this.isArmor(pArmor)) {
            this.inventory.m_6836_(1, pArmor.m_255036_(1));
            if (!pPlayer.m_150110_().f_35937_) {
                pArmor.m_41774_(1);
            }
        }
    }

    public boolean isArmor(ItemStack pStack) {
        return pStack.m_204117_(ItemTags.f_283829_);
    }

    public boolean isSaddled() {
        return this.getFlag(4);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public int getAmbientStandInterval() {
        return this.m_8100_();
    }

    protected int getInventorySize() {
        return 23;
    }

    public int getInventoryColumns() {
        return 5;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(1).m_41619_());
        }
    }

    public void m_5757_(Container pContainer) {
        boolean flag = this.isSaddled();
        this.updateContainerEquipment();
        if (this.f_19797_ <= 20 || flag || this.isSaddled()) {
            // empty if block
        }
    }

    public void m_213583_(Player pPlayer) {
        System.out.println("openCustomInventoryScreen\u5f00\u59cb");
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)pPlayer;
            if (this.m_6084_()) {
                NetworkHooks.openScreen((ServerPlayer)serverplayer, (MenuProvider)new SimpleMenuProvider((containerId, inv, ServerPlayer2) -> new TerracottaGolemMenu(containerId, inv, this), (Component)Component.m_237115_((String)"immortalers_delight.container.terracotta_golem")), friendlyByteBuf -> friendlyByteBuf.m_130130_(this.m_19879_()));
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean hasInventoryChanged(Container pInventory) {
        return this.inventory != pInventory;
    }

    public boolean hasChest() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268659_) || super.m_6673_(source);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                this.m_5552_(itemstack, 0.0f);
            }
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public TerracottaGolem(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_7105_(false);
        this.m_274367_(1.0f);
        this.createInventory();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TerracottaGolemPanicGoal(1.5));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((TerracottaGolem)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, p_28879_ -> p_28879_ instanceof Enemy && !(p_28879_ instanceof Creeper)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createTerracottaGolemAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22276_, 10.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_INTERESTED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_DECORATE_BACK, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_DECORATE_LEFT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_DECORATE_RIGHT, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        this.m_21678_(pCompound);
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        pCompound.m_128365_("Items", (Tag)listtag);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)pCompound.m_128451_("CollarColor")));
        }
        this.m_147285_(this.m_9236_(), pCompound);
        System.out.println("readAdditionalSaveData\u8bfb\u5b8c\u4e86\u72fc\u7684nbt");
        this.createInventory();
        ListTag listtag = pCompound.m_128437_("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 2 || j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return SoundEvents.f_12619_;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    public void m_7105_(boolean pTamed) {
        super.m_7105_(pTamed);
        if (pTamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public boolean m_6573_(Player pPlayer) {
        return !this.m_21660_() && super.m_6573_(pPlayer);
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public InteractionResult openInventoryScreenByRightClick(Player player, InteractionHand hand) {
        System.out.println("openInventoryScreenByRightClick\u5f00\u59cb");
        ItemStack stack = player.m_21120_(hand);
        boolean owner = this.m_21824_() && this.m_21830_((LivingEntity)player);
        InteractionResult type = super.m_6071_(player, hand);
        if (owner) {
            if (!player.m_6144_()) {
                this.m_213583_(player);
                this.m_21839_(true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        } else {
            System.out.println("\u4e0d\u662f\u4e3b\u4eba");
        }
        if (!this.m_21824_() && stack.m_150930_(Items.f_41959_)) {
            this.m_142075_(player, hand, stack);
            this.m_146850_(GameEvent.f_157806_);
            if (!ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && stack.m_150930_(Items.f_42413_) && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(5.0f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.m_146852_(GameEvent.f_157806_, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    @Nullable
    public Wolf getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        UUID uuid;
        Wolf wolf = (Wolf)EntityType.f_20499_.m_20615_((Level)pLevel);
        if (wolf != null && (uuid = this.m_21805_()) != null) {
            wolf.m_21816_(uuid);
            wolf.m_7105_(true);
        }
        return wolf;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        if (pOtherAnimal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(pOtherAnimal instanceof Wolf)) {
            return false;
        }
        Wolf wolf = (Wolf)pOtherAnimal;
        if (!wolf.m_21824_()) {
            return false;
        }
        if (wolf.m_21825_()) {
            return false;
        }
        return this.m_27593_() && wolf.m_27593_();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        this.openInventoryScreenByRightClick(pPlayer, pHand);
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)pPlayer) || this.m_21824_() || itemstack.m_150930_(Items.f_42500_) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)pPlayer)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.m_150930_(Items.f_42500_) && !this.m_21660_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_7757_(LivingEntity pTarget, LivingEntity pOwner) {
        if (!(pTarget instanceof Creeper) && !(pTarget instanceof AbstractGolem)) {
            AbstractHorse horse;
            if (pTarget instanceof TerracottaGolem) {
                TerracottaGolem thisGolem = (TerracottaGolem)pTarget;
                return !thisGolem.m_21824_();
            }
            if (pTarget instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)pTarget;
                return !tamableAnimal.m_21824_() || tamableAnimal.m_269323_() != pOwner;
            }
            if (pTarget instanceof Player && pOwner instanceof Player && !((Player)pOwner).m_7099_((Player)pTarget)) {
                return false;
            }
            if (pTarget instanceof AbstractHorse && (horse = (AbstractHorse)pTarget).m_30614_()) {
                return false;
            }
            return !pTarget.getPersistentData().m_128425_("immortalers_delight_esteemed_guest_friend_to", 11);
        }
        return false;
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_269323_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            pAmount = (pAmount + 1.0f) / 2.0f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, pEntity);
        }
        return flag;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    class TerracottaGolemPanicGoal
    extends PanicGoal {
        public TerracottaGolemPanicGoal(double pSpeedModifier) {
            super((PathfinderMob)TerracottaGolem.this, pSpeedModifier);
        }

        protected boolean m_202729_() {
            return this.f_25684_.m_203117_() || this.f_25684_.m_6060_();
        }
    }
}

