/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.living;

import com.renyigesai.immortalers_delight.event.DifficultyModeHelper;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class Scavenger
extends SpellcasterIllager
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_TELEPORTING = SynchedEntityData.m_135353_(Scavenger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DATA_MOD_SPELL_CASTING_ID = SynchedEntityData.m_135353_(Scavenger.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> DATA_TAKE_POISON_COUNT = SynchedEntityData.m_135353_(Scavenger.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Nullable
    private Sheep wololoTarget;

    public Scavenger(EntityType<? extends Scavenger> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ScavengerCastingSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new ScavengerRandemTeleportSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new ScavengerAttackSpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new ScavengerWololoSpellGoal());
        this.f_21345_.m_25352_(7, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public static AttributeSupplier.Builder createScavengerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, 24.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_MOD_SPELL_CASTING_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_TELEPORTING, (Object)false);
        this.f_19804_.m_135372_(DATA_TAKE_POISON_COUNT, (Object)1);
    }

    public boolean isSpellCasting() {
        return (Byte)this.f_19804_.m_135370_(DATA_MOD_SPELL_CASTING_ID) > 0;
    }

    public void setIsSpellCasting(Byte pCurrentSpell) {
        this.f_19804_.m_135381_(DATA_MOD_SPELL_CASTING_ID, (Object)pCurrentSpell);
    }

    public Byte getSpellCastingType() {
        return (Byte)this.f_19804_.m_135370_(DATA_MOD_SPELL_CASTING_ID);
    }

    public boolean isTeleporting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TELEPORTING);
    }

    public void setTeleporting(Boolean isTeleporting) {
        this.f_19804_.m_135381_(DATA_TELEPORTING, (Object)isTeleporting);
    }

    public void setPotionCount(Byte potionCount) {
        this.f_19804_.m_135381_(DATA_TAKE_POISON_COUNT, (Object)potionCount);
    }

    public Byte getPotionCount() {
        return (Byte)this.f_19804_.m_135370_(DATA_TAKE_POISON_COUNT);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_11863_;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public boolean m_7327_(Entity pEntity) {
        if (!super.m_7327_(pEntity)) {
            return false;
        }
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            if (this.getPotionCount() > 0) {
                pEntity.f_19802_ = 0;
                float f = DifficultyModeHelper.isPowerBattleMode() ? livingEntity.m_21233_() * 0.1f : 2.0f;
                pEntity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this), f * (1.2f + this.f_19796_.m_188501_() * 0.6f));
                pEntity.f_19802_ = 0;
                this.setPotionCount((byte)(this.getPotionCount() - 1));
            }
        }
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.getSpellCastingType() == 3) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public boolean m_7307_(Entity pEntity) {
        if (pEntity == null) {
            return false;
        }
        if (pEntity == this) {
            return true;
        }
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof Vex) {
            return this.m_7307_((Entity)((Vex)pEntity).m_19749_());
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)ImmortalersDelightItems.REPEATING_CROSSBOW.get()));
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_33736_() && !this.isSpellCasting()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        if (this.getSpellCastingType() == 1) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE;
        }
        if (this.getSpellCastingType() == 2) {
            return AbstractIllager.IllagerArmPose.BOW_AND_ARROW;
        }
        return this.m_5912_() ? AbstractIllager.IllagerArmPose.ATTACKING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11861_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11864_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11866_;
    }

    void setWololoTarget(@Nullable Sheep pWololoTarget) {
        this.wololoTarget = pWololoTarget;
    }

    @Nullable
    Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11862_;
    }

    public void m_7895_(int pWave, boolean pUnusedFalse) {
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)pVelocity);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        } else {
            abstractarrow.m_36781_(abstractarrow.m_36789_() + (this.m_9236_().m_46791_() == Difficulty.HARD ? 1.5 : 2.0));
        }
        if (DifficultyModeHelper.isPowerBattleMode()) {
            abstractarrow.m_36781_(abstractarrow.m_36789_() + 3.0 + (double)this.m_9236_().m_46791_().m_19028_());
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    protected boolean teleportSomewhere() {
        if (!this.m_21525_() && this.m_6084_()) {
            BlockPos blockpos = this.m_20183_();
            for (int i = 0; i < 5; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(Mth.m_216287_((RandomSource)this.f_19796_, (int)-8, (int)8), Mth.m_216287_((RandomSource)this.f_19796_, (int)-8, (int)8), Mth.m_216287_((RandomSource)this.f_19796_, (int)-8, (int)8));
                if (blockpos1.m_123342_() <= this.m_9236_().m_141937_() || !this.m_9236_().m_46859_(blockpos1) || !this.m_9236_().m_6857_().m_61937_(blockpos1) || !this.m_9236_().m_45756_((Entity)this, new AABB(blockpos1).m_82406_(1.0E-6))) continue;
                Direction direction = this.findAttachableSurface(blockpos1);
                if (direction != null) {
                    EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)blockpos1.m_123341_(), (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_());
                    if (event.isCanceled()) {
                        direction = null;
                    }
                    blockpos1 = BlockPos.m_274561_((double)event.getTargetX(), (double)event.getTargetY(), (double)event.getTargetZ());
                }
                if (direction == null) continue;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int j = 0; j < 32; ++j) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, this.f_19854_, this.m_20187_() + this.f_19796_.m_188500_() * 2.0, this.f_19856_, 1, 0.0, 0.0, 0.0, 0.05);
                    }
                }
                this.m_19877_();
                this.m_5496_(SoundEvents.f_12418_, 1.0f, 1.0f);
                this.m_6034_((double)blockpos1.m_123341_() + 0.5, blockpos1.m_123342_(), (double)blockpos1.m_123343_() + 0.5);
                this.m_9236_().m_220407_(GameEvent.f_238175_, blockpos, GameEvent.Context.m_223717_((Entity)this));
                this.m_6710_(null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Nullable
    protected Direction findAttachableSurface(BlockPos pPos) {
        for (Direction direction : Direction.values()) {
            if (!this.canStayAt(pPos, direction)) continue;
            return direction;
        }
        return null;
    }

    boolean canStayAt(BlockPos pPos, Direction pFacing) {
        if (this.isPositionBlocked(pPos)) {
            return false;
        }
        Direction direction = pFacing.m_122424_();
        if (!this.m_9236_().m_46578_(pPos.m_121945_(pFacing), (Entity)this, direction)) {
            return false;
        }
        AABB aabb = Scavenger.getProgressAabb(direction, 1.0f).m_82338_(pPos).m_82406_(1.0E-6);
        return this.m_9236_().m_45756_((Entity)this, aabb);
    }

    private boolean isPositionBlocked(BlockPos pPos) {
        BlockState blockstate = this.m_9236_().m_8055_(pPos);
        if (blockstate.m_60795_()) {
            return false;
        }
        boolean flag = blockstate.m_60713_(Blocks.f_50110_) && pPos.equals((Object)this.m_20183_());
        return !flag;
    }

    public static AABB getProgressAabb(Direction pDirection, float pDelta) {
        return Scavenger.getProgressDeltaAabb(pDirection, -1.0f, pDelta);
    }

    public static AABB getProgressDeltaAabb(Direction pDirection, float pDelta, float pDeltaO) {
        double d0 = Math.max(pDelta, pDeltaO);
        double d1 = Math.min(pDelta, pDeltaO);
        return new AABB(BlockPos.f_121853_).m_82363_((double)pDirection.m_122429_() * d0, (double)pDirection.m_122430_() * d0, (double)pDirection.m_122431_() * d0).m_82310_((double)(-pDirection.m_122429_()) * (1.0 + d1), (double)(-pDirection.m_122430_()) * (1.0 + d1), (double)(-pDirection.m_122431_()) * (1.0 + d1));
    }

    class ScavengerCastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        ScavengerCastingSpellGoal() {
            super((SpellcasterIllager)Scavenger.this);
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public void m_8037_() {
            if (Scavenger.this.m_5448_() != null) {
                Scavenger.this.m_21563_().m_24960_((Entity)Scavenger.this.m_5448_(), (float)Scavenger.this.m_8085_(), (float)Scavenger.this.m_8132_());
            } else if (Scavenger.this.getWololoTarget() != null) {
                Scavenger.this.m_21563_().m_24960_((Entity)Scavenger.this.getWololoTarget(), (float)Scavenger.this.m_8085_(), (float)Scavenger.this.m_8132_());
            }
        }
    }

    class ScavengerRandemTeleportSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private boolean hasTeleported;

        ScavengerRandemTeleportSpellGoal() {
            super((SpellcasterIllager)Scavenger.this);
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            return Scavenger.this.m_21188_() != null;
        }

        protected int m_8089_() {
            return 40;
        }

        protected int m_8067_() {
            return Scavenger.this.f_19796_.m_188503_(121) + 240;
        }

        protected void m_8130_() {
        }

        public void m_8056_() {
            this.spawnPreTeleportParticle(Scavenger.this.m_9236_(), Scavenger.this.m_20183_());
            super.m_8056_();
        }

        public void m_8037_() {
            if (this.f_33774_ == 15) {
                Scavenger.this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 30, 1, false, false));
                Scavenger.this.setIsSpellCasting((byte)3);
                Scavenger.this.m_33727_(SpellcasterIllager.IllagerSpell.NONE);
            }
            if (this.f_33774_ <= 10 && this.f_33774_ >= 5) {
                boolean flag;
                if (this.f_33774_ == 10) {
                    Scavenger.this.setTeleporting(true);
                }
                if (!this.hasTeleported && (flag = Scavenger.this.teleportSomewhere())) {
                    Level level = Scavenger.this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 32; ++i) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, Scavenger.this.f_19854_, Scavenger.this.m_20187_() + Scavenger.this.f_19796_.m_188500_() * 2.0, Scavenger.this.f_19856_, 1, 0.0, 0.0, 0.0, 0.05);
                        }
                    }
                    this.hasTeleported = true;
                }
                if (this.f_33774_ == 5) {
                    Scavenger.this.setTeleporting(false);
                }
            }
            super.m_8037_();
        }

        public void m_8041_() {
            super.m_8041_();
            Scavenger.this.setIsSpellCasting((byte)0);
            Scavenger.this.setPotionCount((byte)(Scavenger.this.getPotionCount() + 1));
            this.spawnPreTeleportParticle(Scavenger.this.m_9236_(), Scavenger.this.m_20183_());
        }

        private void spawnPreTeleportParticle(Level level, BlockPos pPos) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 10; ++i) {
                    Vec3 pos = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5);
                    double flunc = Math.random() * 2.0 - 1.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_ + 1.0, pos.f_82480_ + 0.1, pos.f_82481_ + flunc, 1, 0.0, 0.0, 0.0, 0.03);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_ - 1.0, pos.f_82480_ + 0.1, pos.f_82481_ + flunc, 1, 0.0, 0.0, 0.0, 0.03);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_ + flunc, pos.f_82480_ + 0.1, pos.f_82481_ + 1.0, 1, 0.0, 0.0, 0.0, 0.03);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_ + flunc, pos.f_82480_ + 0.1, pos.f_82481_ - 1.0, 1, 0.0, 0.0, 0.0, 0.03);
                }
            }
        }

        protected int m_8069_() {
            return 40;
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11868_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.BLINDNESS;
        }
    }

    class ScavengerAttackSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private int attackStep;
        private int attackTime;
        private int defAttackTime;

        ScavengerAttackSpellGoal() {
            super((SpellcasterIllager)Scavenger.this);
        }

        protected int m_8089_() {
            return 80;
        }

        protected int m_8067_() {
            return 200;
        }

        protected void m_8130_() {
            LivingEntity livingentity = Scavenger.this.m_5448_();
            if (livingentity == null || !livingentity.m_6084_()) {
                return;
            }
            if (this.attackStep <= 0) {
                return;
            }
            if (this.isHoldingBow()) {
                --this.attackStep;
                Scavenger.this.m_6504_(livingentity, BowItem.m_40661_((int)1));
                this.attackTime = this.defAttackTime;
            } else {
                --this.attackStep;
                this.attackTime = this.defAttackTime;
            }
        }

        protected boolean isHoldingBow() {
            return Scavenger.this.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
        }

        public void m_8056_() {
            if (!(Scavenger.this.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof CrossbowItem)) {
                this.changeHands();
            }
            Scavenger.this.m_6672_(InteractionHand.MAIN_HAND);
            Scavenger.this.setIsSpellCasting((byte)1);
            int fraction = 3;
            if (Scavenger.this.m_37885_() != null) {
                fraction = 1;
            }
            if (Scavenger.this.m_217043_().m_188501_() <= 1.0f / (float)fraction) {
                this.attackStep = 6;
                this.defAttackTime = 6;
            } else {
                this.attackStep = 3;
                this.defAttackTime = 12;
            }
            this.attackTime = this.m_183277_(20);
            super.m_8056_();
        }

        public void m_8037_() {
            if (this.attackTime > 0) {
                --this.attackTime;
            }
            if (this.attackTime == 10 && Scavenger.this.m_5448_() != null && Scavenger.this.m_20280_((Entity)Scavenger.this.m_5448_()) < 16.0 && Scavenger.this.m_20096_()) {
                Vec3 targetEntityPos = Scavenger.this.m_5448_().m_20182_();
                Vec3 thisEntityPos = Scavenger.this.m_20182_();
                Vec3 directionVector = thisEntityPos.m_82546_(targetEntityPos);
                double distance = Scavenger.this.m_20280_((Entity)Scavenger.this.m_5448_());
                Scavenger.this.m_20256_(Scavenger.this.m_20184_().m_82520_(directionVector.f_82479_ / (1.0 + 0.2 * distance), 0.5, directionVector.f_82481_ / (1.0 + 0.2 * distance)));
                Scavenger.this.m_146922_(Scavenger.this.f_20885_);
                Scavenger.this.m_6853_(false);
                Scavenger.this.f_19812_ = true;
            }
            if (this.attackTime <= 6) {
                Scavenger.this.setIsSpellCasting((byte)2);
            }
            if (this.attackTime == 0) {
                this.m_8130_();
            }
            super.m_8037_();
        }

        public void m_8041_() {
            super.m_8041_();
            this.attackStep = 0;
            Scavenger.this.setIsSpellCasting((byte)0);
            Scavenger.this.m_5810_();
            if (Scavenger.this.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof CrossbowItem) {
                this.changeHands();
            }
        }

        private void changeHands() {
            ItemStack tool = Scavenger.this.m_21120_(InteractionHand.OFF_HAND).m_41777_();
            Scavenger.this.m_21008_(InteractionHand.OFF_HAND, Scavenger.this.m_21120_(InteractionHand.MAIN_HAND));
            Scavenger.this.m_21008_(InteractionHand.MAIN_HAND, tool);
        }

        protected int m_8069_() {
            return 60;
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11867_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.NONE;
        }
    }

    public class ScavengerWololoSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions wololoTargeting;

        public ScavengerWololoSpellGoal() {
            super((SpellcasterIllager)Scavenger.this);
            this.wololoTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_26888_(p_32710_ -> ((Sheep)p_32710_).m_29874_() == DyeColor.BLUE);
        }

        public boolean m_8036_() {
            if (Scavenger.this.m_5448_() != null) {
                return false;
            }
            if (Scavenger.this.m_33736_()) {
                return false;
            }
            if (Scavenger.this.f_19797_ < this.f_33775_) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)Scavenger.this.m_9236_(), (Entity)Scavenger.this)) {
                return false;
            }
            List list = Scavenger.this.m_9236_().m_45971_(Sheep.class, this.wololoTargeting, (LivingEntity)Scavenger.this, Scavenger.this.m_20191_().m_82377_(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            Scavenger.this.setWololoTarget((Sheep)list.get(Scavenger.this.f_19796_.m_188503_(list.size())));
            return true;
        }

        public boolean m_8045_() {
            return Scavenger.this.getWololoTarget() != null && this.f_33774_ > 0;
        }

        public void m_8041_() {
            super.m_8041_();
            Scavenger.this.setWololoTarget(null);
        }

        protected void m_8130_() {
            Sheep sheep = Scavenger.this.getWololoTarget();
            if (sheep != null && sheep.m_6084_()) {
                sheep.m_29855_(DyeColor.RED);
            }
        }

        protected int m_8069_() {
            return 40;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 140;
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11869_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(Scavenger vindicator) {
            super((PathfinderMob)vindicator, 1.25, false);
        }

        protected double m_6639_(LivingEntity entity) {
            if (this.f_25540_.m_20202_() instanceof Ravager) {
                float f = this.f_25540_.m_20202_().m_20205_() - 0.1f;
                return f * 2.0f * (f * 2.0f) + entity.m_20205_();
            }
            return super.m_6639_(entity);
        }
    }
}

