/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.anvil;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.anvil.AnvilUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class AnvilUpgradeContainer
extends UpgradeContainerBase<AnvilUpgradeWrapper, AnvilUpgradeContainer> {
    private static final String DATA_SHIFT_CLICK_INTO_STORAGE = "shiftClickIntoStorage";
    private final Slot resultSlot;
    private PersistableAnvilMenu anvilMenuDelegate;
    private Runnable nameChangeListener = () -> {};
    private boolean processingOnTakeLogic = false;

    public AnvilUpgradeContainer(Player player, int upgradeContainerId, AnvilUpgradeWrapper upgradeWrapper, UpgradeContainerType<AnvilUpgradeWrapper, AnvilUpgradeContainer> type) {
        super(player, upgradeContainerId, (IUpgradeWrapper)upgradeWrapper, type);
        this.anvilMenuDelegate = new PersistableAnvilMenu(new Inventory(player));
        this.slots.add(this.anvilMenuDelegate.m_38853_(0));
        this.slots.add(this.anvilMenuDelegate.m_38853_(1));
        this.resultSlot = this.anvilMenuDelegate.m_38853_(2);
        this.slots.add(this.resultSlot);
    }

    public void setNameChangeListener(Runnable nameChangeListener) {
        this.nameChangeListener = nameChangeListener;
    }

    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SHIFT_CLICK_INTO_STORAGE)) {
            this.setShiftClickIntoStorage(data.m_128471_(DATA_SHIFT_CLICK_INTO_STORAGE));
        } else if (data.m_128441_("itemName")) {
            this.setItemName(data.m_128461_("itemName"));
        }
    }

    public void setUpgradeWrapper(IUpgradeWrapper updatedUpgradeWrapper) {
        super.setUpgradeWrapper(updatedUpgradeWrapper);
        this.anvilMenuDelegate.m_39020_(((AnvilUpgradeWrapper)this.upgradeWrapper).getItemName());
        this.anvilMenuDelegate.m_6640_();
        this.nameChangeListener.run();
    }

    public boolean shouldShiftClickIntoStorage() {
        return ((AnvilUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoStorage();
    }

    public boolean isProcessingOnTakeLogic() {
        return this.processingOnTakeLogic;
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        ((AnvilUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoStorage(shiftClickIntoStorage);
        this.sendDataToServer(() -> NBTHelper.putBoolean((CompoundTag)new CompoundTag(), (String)DATA_SHIFT_CLICK_INTO_STORAGE, (boolean)shiftClickIntoStorage));
    }

    public boolean mergeIntoStorageFirst(Slot slot) {
        return !(slot instanceof ResultSlot) || this.shouldShiftClickIntoStorage();
    }

    public boolean allowsPickupAll(Slot slot) {
        return slot != this.resultSlot;
    }

    public void setItemName(String name) {
        this.anvilMenuDelegate.m_39020_(name);
        ((AnvilUpgradeWrapper)this.upgradeWrapper).setItemName(name);
        this.sendDataToServer(() -> NBTHelper.putString((CompoundTag)new CompoundTag(), (String)"itemName", (String)name));
    }

    public int getCost() {
        return this.anvilMenuDelegate.m_39028_();
    }

    @Nullable
    public String getItemName() {
        return ((AnvilUpgradeWrapper)this.upgradeWrapper).getItemName();
    }

    private class PersistableAnvilMenu
    extends AnvilMenu {
        public PersistableAnvilMenu(Inventory playerInventory) {
            super(0, playerInventory, playerInventory.f_35978_.m_9236_().m_5776_() ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)playerInventory.f_35978_.m_20183_()));
            super.m_39020_(((AnvilUpgradeWrapper)AnvilUpgradeContainer.this.upgradeWrapper).getItemName());
        }

        protected void m_266254_(ItemCombinerMenuSlotDefinition itemCombinerMenuSlotDefinition) {
            for (final ItemCombinerMenuSlotDefinition.SlotDefinition slotDefinition : itemCombinerMenuSlotDefinition.m_266233_()) {
                this.m_38897_((Slot)new SlotSuppliedHandler(() -> ((AnvilUpgradeWrapper)AnvilUpgradeContainer.this.upgradeWrapper).getInventory(), slotDefinition.f_266086_(), 0, 0){

                    public void m_6654_() {
                        super.m_6654_();
                        PersistableAnvilMenu.this.m_6199_(PersistableAnvilMenu.this.f_39769_);
                        if (slotDefinition.f_266086_() == 0) {
                            if (((AnvilUpgradeWrapper)AnvilUpgradeContainer.this.upgradeWrapper).getItemName().isEmpty() != this.m_7993_().m_41619_()) {
                                String newItemName = this.m_7993_().m_41619_() ? "" : this.m_7993_().m_41786_().getString();
                                ((AnvilUpgradeWrapper)AnvilUpgradeContainer.this.upgradeWrapper).setItemName(newItemName);
                                PersistableAnvilMenu.this.m_39020_(newItemName);
                                AnvilUpgradeContainer.this.nameChangeListener.run();
                            }
                            if (this.m_7993_().m_41619_()) {
                                PersistableAnvilMenu.this.m_39020_("");
                                ((AnvilUpgradeWrapper)AnvilUpgradeContainer.this.upgradeWrapper).setItemName("");
                            }
                        }
                    }

                    public boolean m_5857_(ItemStack p_267156_) {
                        return slotDefinition.f_265897_().test(p_267156_);
                    }
                });
            }
        }

        protected SimpleContainer m_266190_(int p_267204_) {
            return new SimpleContainer(p_267204_){

                public void m_6596_() {
                    super.m_6596_();
                    PersistableAnvilMenu.this.m_6199_((Container)this);
                }

                public ItemStack m_8020_(int pIndex) {
                    return ((AnvilUpgradeWrapper)AnvilUpgradeContainer.this.upgradeWrapper).getInventory().getStackInSlot(pIndex);
                }

                public void m_6836_(int pIndex, ItemStack pStack) {
                    ((AnvilUpgradeWrapper)AnvilUpgradeContainer.this.upgradeWrapper).getInventory().setStackInSlot(pIndex, pStack);
                }
            };
        }

        public void m_6199_(Container pInventory) {
            this.m_6640_();
        }

        protected void m_142365_(Player player, ItemStack stack) {
            AnvilUpgradeContainer.this.processingOnTakeLogic = true;
            super.m_142365_(player, stack);
            AnvilUpgradeContainer.this.processingOnTakeLogic = false;
        }
    }
}

