/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.datapackloaderrorfix.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<File> findFiles(File directory, Predicate<Path> filter) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            return List.of();
        }
        try (Stream<Path> paths = Files.walk(directory.toPath(), new FileVisitOption[0]);){
            List<File> list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(filter).map(Path::toFile).toList();
            return list;
        }
    }

    public static List<File> findDirectories(File directory, Predicate<Path> filter) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            return List.of();
        }
        try (Stream<Path> paths = Files.walk(directory.toPath(), new FileVisitOption[0]);){
            List<File> list = paths.filter(path -> path.toFile().isDirectory()).filter(filter).map(Path::toFile).toList();
            return list;
        }
    }

    public static boolean hasExtension(Path path, String ... extensions) {
        String fileName = path.getFileName().toString().toLowerCase();
        for (String ext : extensions) {
            if (!fileName.endsWith(ext.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidFile(File file) {
        return file != null && file.exists() && file.isFile() && file.canRead();
    }

    public static boolean isValidDirectory(File directory) {
        return directory != null && directory.exists() && directory.isDirectory() && directory.canRead();
    }

    public static long getFileSize(File file) {
        try {
            return Files.size(file.toPath());
        }
        catch (IOException e) {
            LOGGER.warn("\u65e0\u6cd5\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f: {}", (Object)file.getName(), (Object)e);
            return 0L;
        }
    }
}

