/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.datapackloaderrorfix.util;

import com.xinian.datapackloaderrorfix.config.ModConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");

    public static boolean createBackup(File originalFile) {
        if (!ModConfig.shouldCreateBackups()) {
            return true;
        }
        try {
            File backupFile = BackupManager.generateBackupFile(originalFile);
            if (!backupFile.exists()) {
                Files.copy(originalFile.toPath(), backupFile.toPath(), new CopyOption[0]);
                LOGGER.info("\u5df2\u521b\u5efa\u5907\u4efd\u6587\u4ef6: {}", (Object)backupFile.getName());
                return true;
            }
            LOGGER.debug("\u5907\u4efd\u6587\u4ef6\u5df2\u5b58\u5728: {}", (Object)backupFile.getName());
            return true;
        }
        catch (IOException e) {
            LOGGER.error("\u521b\u5efa\u5907\u4efd\u6587\u4ef6\u5931\u8d25: {}", (Object)originalFile.getName(), (Object)e);
            return false;
        }
    }

    private static File generateBackupFile(File originalFile) {
        String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMAT);
        String backupName = originalFile.getName() + ".bak_" + timestamp;
        return new File(originalFile.getParentFile(), backupName);
    }

    public static File getSimpleBackupFile(File originalFile) {
        String backupName = originalFile.getName() + ".bak";
        return new File(originalFile.getParentFile(), backupName);
    }
}

