/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.datapackloaderrorfix.service;

import com.xinian.datapackloaderrorfix.config.ModConfig;
import com.xinian.datapackloaderrorfix.processor.impl.ChunkDataProcessor;
import com.xinian.datapackloaderrorfix.processor.impl.DatapackProcessor;
import com.xinian.datapackloaderrorfix.processor.impl.LevelDataProcessor;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CleanupService {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService executorService = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r, "DatapackFixer-Worker");
        thread.setDaemon(true);
        return thread;
    });
    private final LevelDataProcessor levelProcessor = new LevelDataProcessor();
    private final ChunkDataProcessor chunkProcessor = new ChunkDataProcessor();
    private final DatapackProcessor datapackProcessor = new DatapackProcessor();

    public CompletableFuture<Void> cleanupWorldAsync(File worldDir) {
        return CompletableFuture.runAsync(() -> this.cleanupWorld(worldDir), this.executorService);
    }

    public void cleanupWorld(File worldDir) {
        LOGGER.info("\u5f00\u59cb\u6e05\u7406\u4e16\u754c\u6570\u636e: {}", (Object)worldDir.getName());
        try {
            File levelFile;
            if ((ModConfig.cleanDimensions || ModConfig.cleanEntities) && (levelFile = new File(worldDir, "level.dat")).exists()) {
                this.levelProcessor.processLevelData(levelFile);
            }
            if (ModConfig.cleanChunks) {
                this.chunkProcessor.processChunkData(worldDir);
            }
            if (ModConfig.cleanDatapacks) {
                this.datapackProcessor.processDatapacks(worldDir);
            }
            LOGGER.info("\u4e16\u754c\u6570\u636e\u6e05\u7406\u5b8c\u6210: {}", (Object)worldDir.getName());
        }
        catch (Exception e) {
            LOGGER.error("\u6e05\u7406\u4e16\u754c\u6570\u636e\u65f6\u51fa\u9519: {}", (Object)worldDir.getName(), (Object)e);
            throw new RuntimeException("\u6e05\u7406\u5931\u8d25", e);
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

