/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.datapackloaderrorfix.processor.impl;

import com.xinian.datapackloaderrorfix.config.ModConfig;
import com.xinian.datapackloaderrorfix.processor.BaseProcessor;
import com.xinian.datapackloaderrorfix.util.BackupManager;
import com.xinian.datapackloaderrorfix.util.ModDetector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import org.apache.logging.log4j.LogManager;

public class LevelDataProcessor
extends BaseProcessor {
    public LevelDataProcessor() {
        super(LogManager.getLogger());
    }

    public void processLevelData(File levelFile) {
        this.logProcessStart("Level\u6570\u636e", levelFile.getName());
        try {
            if (!BackupManager.createBackup(levelFile)) {
                this.logger.warn("\u65e0\u6cd5\u521b\u5efa\u5907\u4efd\uff0c\u8df3\u8fc7\u5904\u7406: {}", (Object)levelFile.getName());
                return;
            }
            CompoundTag root = NbtIo.m_128937_((File)levelFile);
            CompoundTag data = root.m_128469_("Data");
            boolean hasChanges = false;
            if (ModConfig.cleanDimensions) {
                hasChanges |= this.cleanDimensions(data);
            }
            if (ModConfig.cleanEntities) {
                hasChanges |= this.cleanPlayerData(data);
            }
            if (hasChanges) {
                NbtIo.m_128944_((CompoundTag)root, (File)levelFile);
            }
            this.logProcessComplete("Level\u6570\u636e", levelFile.getName(), hasChanges);
        }
        catch (IOException e) {
            this.logError("\u5904\u7406Level\u6570\u636e", levelFile.getName(), e);
        }
    }

    private boolean cleanDimensions(CompoundTag data) {
        CompoundTag worldGenSettings = data.m_128469_("WorldGenSettings");
        if (!worldGenSettings.m_128441_("dimensions")) {
            return false;
        }
        CompoundTag dimensions = worldGenSettings.m_128469_("dimensions");
        Set keys = dimensions.m_128431_();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : keys) {
            String modId = ModDetector.extractModId(key);
            if (modId == null || ModDetector.isModLoaded(modId)) continue;
            toRemove.add(key);
        }
        boolean changed = false;
        for (String key : toRemove) {
            dimensions.m_128473_(key);
            this.logger.info("\u5df2\u79fb\u9664\u6b8b\u7559\u7684\u7ef4\u5ea6\u6570\u636e: {}", (Object)key);
            changed = true;
        }
        return changed;
    }

    private boolean cleanPlayerData(CompoundTag data) {
        boolean changed = false;
        if (data.m_128441_("Player")) {
            CompoundTag player = data.m_128469_("Player");
            if (ModConfig.cleanPlayerInventory) {
                if (player.m_128441_("Inventory")) {
                    changed |= this.cleanInventory(player.m_128437_("Inventory", 10), "\u80cc\u5305");
                }
                if (player.m_128441_("EnderItems")) {
                    changed |= this.cleanInventory(player.m_128437_("EnderItems", 10), "\u672b\u5f71\u7bb1");
                }
            }
        }
        return changed;
    }

    private boolean cleanInventory(ListTag inventory, String inventoryType) {
        int i;
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (i = 0; i < inventory.size(); ++i) {
            String id;
            String modId;
            CompoundTag item = inventory.m_128728_(i);
            if (!item.m_128441_("id") || (modId = ModDetector.extractModId(id = item.m_128461_("id"))) == null || ModDetector.isModLoaded(modId)) continue;
            toRemove.add(i);
            this.logger.info("\u53d1\u73b0{}\u4e2d\u5f15\u7528\u4e0d\u5b58\u5728\u6a21\u7ec4\u7684\u7269\u54c1: {}", (Object)inventoryType, (Object)id);
        }
        for (i = toRemove.size() - 1; i >= 0; --i) {
            int index = (Integer)toRemove.get(i);
            CompoundTag item = inventory.m_128728_(index);
            String id = item.m_128461_("id");
            inventory.remove(index);
            this.logger.info("\u5df2\u4ece{}\u79fb\u9664\u6b8b\u7559\u7269\u54c1: {}", (Object)inventoryType, (Object)id);
        }
        return !toRemove.isEmpty();
    }
}

