/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.datapackloaderrorfix.processor;

import com.xinian.datapackloaderrorfix.config.ModConfig;
import com.xinian.datapackloaderrorfix.processor.impl.ChunkDataProcessor;
import com.xinian.datapackloaderrorfix.processor.impl.DatapackProcessor;
import com.xinian.datapackloaderrorfix.processor.impl.LevelDataProcessor;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldDataProcessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LevelDataProcessor levelProcessor = new LevelDataProcessor();
    private final ChunkDataProcessor chunkProcessor = new ChunkDataProcessor();
    private final DatapackProcessor datapackProcessor = new DatapackProcessor();

    public void processCurrentWorld(Minecraft minecraft) {
        try {
            File levelFile;
            File worldDir = this.getWorldDirectory(minecraft);
            if (worldDir == null) {
                LOGGER.warn("\u65e0\u6cd5\u83b7\u53d6\u4e16\u754c\u76ee\u5f55\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            LOGGER.info("\u5f00\u59cb\u5904\u7406\u4e16\u754c: {}", (Object)worldDir.getName());
            if ((ModConfig.cleanDimensions || ModConfig.cleanEntities) && (levelFile = new File(worldDir, "level.dat")).exists()) {
                this.levelProcessor.processLevelData(levelFile);
            }
            if (ModConfig.cleanChunks) {
                this.chunkProcessor.processChunkData(worldDir);
            }
            if (ModConfig.cleanDatapacks) {
                this.datapackProcessor.processDatapacks(worldDir);
            }
            LOGGER.info("\u4e16\u754c\u6570\u636e\u5904\u7406\u5b8c\u6210");
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u4e16\u754c\u6570\u636e\u65f6\u51fa\u9519", (Throwable)e);
        }
    }

    private File getWorldDirectory(Minecraft minecraft) {
        try {
            LevelStorageSource levelSource = minecraft.m_91392_();
            String levelId = this.determineLevelId(minecraft);
            if (levelId == null) {
                return null;
            }
            LevelStorageSource.LevelStorageAccess levelAccess = levelSource.m_78260_(levelId);
            File worldDir = levelAccess.getWorldDir().toFile();
            levelAccess.close();
            return worldDir;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4e16\u754c\u76ee\u5f55\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private String determineLevelId(Minecraft minecraft) {
        if (minecraft.m_91089_() != null) {
            return minecraft.m_91089_().f_105362_;
        }
        if (minecraft.m_91092_() != null) {
            return minecraft.m_91092_().m_129910_().m_5462_();
        }
        return null;
    }
}

