/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.menu;

import java.util.ArrayList;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.entity.SharestoneBlockEntity;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.menu.WarpPlateContainer;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.blay09.mods.waystones.menu.WaystoneSettingsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ModMenus {
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> waystoneSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> sharestoneSelection;
    public static DeferredObject<MenuType<WarpPlateContainer>> warpPlate;
    public static DeferredObject<MenuType<WaystoneSettingsMenu>> waystoneSettings;

    public static void initialize(BalmMenus menus) {
        waystoneSelection = menus.registerMenu(ModMenus.id("waystone_selection"), (syncId, inventory, buf) -> {
            WarpMode warpMode = WarpMode.values[buf.readByte()];
            IWaystone fromWaystone = null;
            if (warpMode == WarpMode.WAYSTONE_TO_WAYSTONE) {
                BlockPos pos = buf.m_130135_();
                BlockEntity blockEntity = inventory.f_35978_.m_9236_().m_7702_(pos);
                if (blockEntity instanceof WaystoneBlockEntity) {
                    fromWaystone = ((WaystoneBlockEntity)blockEntity).getWaystone();
                }
            }
            return WaystoneSelectionMenu.createWaystoneSelection(syncId, inventory.f_35978_, warpMode, fromWaystone);
        });
        sharestoneSelection = menus.registerMenu(ModMenus.id("sharestone_selection"), (syncId, inventory, buf) -> {
            BlockPos pos = buf.m_130135_();
            int count = buf.readShort();
            ArrayList<IWaystone> waystones = new ArrayList<IWaystone>(count);
            for (int i = 0; i < count; ++i) {
                waystones.add(Waystone.read(buf));
            }
            BlockEntity blockEntity = inventory.f_35978_.m_9236_().m_7702_(pos);
            if (blockEntity instanceof SharestoneBlockEntity) {
                IWaystone fromWaystone = ((SharestoneBlockEntity)blockEntity).getWaystone();
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)sharestoneSelection.get()), WarpMode.SHARESTONE_TO_SHARESTONE, fromWaystone, syncId, waystones);
            }
            return null;
        });
        warpPlate = menus.registerMenu(ModMenus.id("warp_plate"), (windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            BlockEntity blockEntity = inv.f_35978_.m_9236_().m_7702_(pos);
            if (blockEntity instanceof WarpPlateBlockEntity) {
                WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)blockEntity;
                return new WarpPlateContainer(windowId, warpPlate, warpPlate.getContainerData(), inv);
            }
            return null;
        });
        waystoneSettings = menus.registerMenu(ModMenus.id("waystone_settings"), (windowId, inv, data) -> {
            IWaystone waystone = Waystone.read(data);
            return new WaystoneSettingsMenu((MenuType<WaystoneSettingsMenu>)((MenuType)waystoneSettings.get()), waystone, windowId);
        });
    }

    @NotNull
    private static ResourceLocation id(String name) {
        return new ResourceLocation("waystones", name);
    }
}

