/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.profile;

import com.google.common.collect.Maps;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import customskinloader.fake.FakeMinecraftProfileTexture;
import customskinloader.profile.UserProfile;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ModelManager0 {
    private static HashMap<String, Model> models = new HashMap();
    private static MinecraftProfileTexture.Type typeElytra = null;

    public static Model getEnumModel(String model) {
        return models.get(model);
    }

    public static boolean isSkin(Model model) {
        return model == Model.SKIN_DEFAULT || model == Model.SKIN_SLIM;
    }

    public static boolean isElytraSupported() {
        return typeElytra != null;
    }

    public static UserProfile toUserProfile(Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> profile) {
        MinecraftProfileTexture cape;
        UserProfile userProfile = new UserProfile();
        if (profile == null) {
            return userProfile;
        }
        MinecraftProfileTexture skin = profile.get(MinecraftProfileTexture.Type.SKIN);
        userProfile.skinUrl = skin == null ? null : skin.getUrl();
        String string = userProfile.model = skin == null ? null : skin.getMetadata("model");
        if (StringUtils.isEmpty((CharSequence)userProfile.model)) {
            userProfile.model = "default";
        }
        userProfile.capeUrl = (cape = profile.get(MinecraftProfileTexture.Type.CAPE)) == null ? null : cape.getUrl();
        return userProfile;
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> fromUserProfile(UserProfile profile) {
        HashMap map = Maps.newHashMap();
        if (profile == null) {
            return map;
        }
        if (profile.skinUrl != null) {
            HashMap metadata = null;
            if ("slim".equals(profile.model) || "auto".equals(profile.model)) {
                metadata = Maps.newHashMap();
                metadata.put("model", profile.model);
            }
            map.put(MinecraftProfileTexture.Type.SKIN, ModelManager0.getProfileTexture(profile.skinUrl, metadata));
        }
        if (profile.capeUrl != null) {
            map.put(MinecraftProfileTexture.Type.CAPE, ModelManager0.getProfileTexture(profile.capeUrl, null));
        }
        if (typeElytra != null && profile.elytraUrl != null) {
            map.put(typeElytra, ModelManager0.getProfileTexture(profile.elytraUrl, null));
        }
        return map;
    }

    public static MinecraftProfileTexture getProfileTexture(String url, Map<String, String> metadata) {
        return new FakeMinecraftProfileTexture(url, metadata);
    }

    static {
        for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.Type.values()) {
            if (type.ordinal() != 2) continue;
            typeElytra = type;
        }
        models.put("default", Model.SKIN_DEFAULT);
        models.put("slim", Model.SKIN_SLIM);
        models.put("cape", Model.CAPE);
        if (typeElytra != null) {
            models.put("elytra", Model.ELYTRA);
            models.put("elytron", Model.ELYTRA);
        }
    }

    public static enum Model {
        SKIN_DEFAULT,
        SKIN_SLIM,
        CAPE,
        ELYTRA;

    }
}

