/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import customskinloader.utils.HttpTextureUtil;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FakeMinecraftProfileTexture
extends MinecraftProfileTexture {
    private static final Map<String, String> MODEL_CACHE = new ConcurrentHashMap<String, String>();
    private final HttpTextureUtil.HttpTextureInfo info;
    private final Map<String, String> metadata;

    public FakeMinecraftProfileTexture(String url, Map<String, String> metadata) {
        super(url, metadata);
        this.info = HttpTextureUtil.toHttpTextureInfo(url);
        this.metadata = metadata;
    }

    public String getUrl() {
        return this.info.url;
    }

    public String getMetadata(String key) {
        String model;
        String value = super.getMetadata(key);
        if ("model".equals(key) && "auto".equals(value) && (model = MODEL_CACHE.get(this.getHash())) != null) {
            return model;
        }
        return value;
    }

    public void setModel(String model) {
        if (this.metadata != null) {
            MODEL_CACHE.put(this.getHash(), model);
            this.metadata.put("model", model);
        }
    }

    public String getHash() {
        return this.info.hash == null ? super.getHash() : this.info.hash;
    }

    public File getCacheFile() {
        return this.info.cacheFile;
    }
}

