/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.lich;

import com.cerbon.bosses_of_mass_destruction.config.mob.LichConfig;
import com.cerbon.bosses_of_mass_destruction.entity.ai.action.IActionWithCooldown;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.MinionAction;
import com.cerbon.bosses_of_mass_destruction.entity.util.ProjectileThrower;
import com.cerbon.bosses_of_mass_destruction.projectile.comet.CometProjectile;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.MobUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CometRageAction
implements IActionWithCooldown {
    private final LichEntity entity;
    private final EventScheduler eventScheduler;
    private final Supplier<Boolean> shouldCancel;
    private final Function<Vec3, ProjectileThrower> cometThrower;
    public static final int numCometsDuringRage = 6;
    public static final int initialRageCometDelay = 60;
    public static final int delayBetweenRageComets = 30;
    public static final int rageCometsMoveDuration = 240;

    public CometRageAction(LichEntity entity, EventScheduler eventScheduler, Supplier<Boolean> shouldCancel, LichConfig lichConfig) {
        this.entity = entity;
        this.eventScheduler = eventScheduler;
        this.shouldCancel = shouldCancel;
        this.cometThrower = offset -> new ProjectileThrower(() -> {
            CometProjectile projectile = new CometProjectile((LivingEntity)entity, entity.m_9236_(), vec3 -> entity.m_9236_().m_254849_((Entity)entity, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, lichConfig.comet.explosionStrength, Level.ExplosionInteraction.MOB), Collections.singletonList(MinionAction.summonEntityType));
            MobUtils.setPos((Entity)projectile, (Vec3)MobUtils.eyePos((Entity)entity).m_82549_(offset));
            return new ProjectileThrower.ProjectileData((Projectile)projectile, 1.6f, 0.0f, 0.2);
        });
    }

    @Override
    public int perform() {
        LivingEntity target = this.entity.m_5448_();
        if (!(target instanceof ServerPlayer)) {
            return 240;
        }
        this.performCometThrow((ServerPlayer)target);
        return 240;
    }

    private void performCometThrow(ServerPlayer target) {
        List<Vec3> offsets = CometRageAction.getRageCometOffsets(this.entity);
        for (int i = 0; i < offsets.size(); ++i) {
            Vec3 offset = offsets.get(i);
            this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                Vec3 targetPos = target.m_20191_().m_82399_();
                this.cometThrower.apply(offset).throwProjectile(targetPos);
                SoundUtils.playSound((ServerLevel)target.m_284548_(), (Vec3)this.entity.m_20182_(), (SoundEvent)((SoundEvent)BMDSounds.COMET_SHOOT.get()), (SoundSource)SoundSource.HOSTILE, (float)3.0f, (double)64.0, null);
            }, 60 + i * 30, 1, this.shouldCancel));
        }
        SoundUtils.playSound((ServerLevel)target.m_284548_(), (Vec3)this.entity.m_20182_(), (SoundEvent)((SoundEvent)BMDSounds.RAGE_PREPARE.get()), (SoundSource)SoundSource.HOSTILE, (float)1.0f, (double)64.0, null);
    }

    public static List<Vec3> getRageCometOffsets(LichEntity entity) {
        ArrayList<Vec3> offsets = new ArrayList<Vec3>();
        MathUtils.circleCallback((double)3.0, (int)6, (Vec3)entity.m_20154_(), offsets::add);
        return offsets;
    }
}

