/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.ai.valid_direction;

import com.cerbon.bosses_of_mass_destruction.entity.ai.valid_direction.IValidDirection;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CanMoveThrough
implements IValidDirection {
    private final Entity entity;
    private final double reactionDistance;

    public CanMoveThrough(Entity entity, double reactionDistance) {
        this.entity = entity;
        this.reactionDistance = reactionDistance;
    }

    @Override
    public boolean isValidDirection(Vec3 normedDirection) {
        Vec3 reactionDirection = normedDirection.m_82490_(this.reactionDistance).m_82549_(this.entity.m_20184_());
        Vec3 target = this.entity.m_20182_().m_82549_(reactionDirection);
        boolean noBlockCollisions = MathUtils.willAABBFit((AABB)this.entity.m_20191_(), (Vec3)reactionDirection, box -> !this.entity.m_9236_().m_45756_(this.entity, box));
        ClipContext context = new ClipContext(this.entity.m_20182_().m_82549_(normedDirection.m_82490_(1.0)), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, this.entity);
        BlockHitResult blockCollision = this.entity.m_9236_().m_45547_(context);
        boolean noFluidCollisions = blockCollision.m_6662_() == HitResult.Type.MISS;
        return noFluidCollisions && noBlockCollisions;
    }
}

