/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.datageneration;

import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.block.ControllerBlock;
import com.refinedmods.refinedstorage.block.DetectorBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.datageneration.BlockModels;
import com.refinedmods.refinedstorage.util.ColorMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockModelGenerator
extends BlockStateProvider {
    private static final ResourceLocation BOTTOM = new ResourceLocation("refinedstorage", "block/bottom");
    private final BlockModels models = new BlockModels(this);

    public BlockModelGenerator(PackOutput output, String id, ExistingFileHelper existingFileHelper) {
        super(output, id, existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.genNorthCutoutModels(RSBlocks.GRID, false);
        this.genNorthCutoutModels(RSBlocks.CRAFTING_GRID, false);
        this.genNorthCutoutModels(RSBlocks.PATTERN_GRID, false);
        this.genNorthCutoutModels(RSBlocks.FLUID_GRID, false);
        this.genNorthCutoutModels(RSBlocks.CRAFTING_MONITOR, false);
        this.genNorthCutoutModels(RSBlocks.CRAFTER_MANAGER, false);
        this.genNorthCutoutModels(RSBlocks.DISK_MANIPULATOR, true);
        this.genControllerModels(RSBlocks.CONTROLLER);
        this.genControllerModels(RSBlocks.CREATIVE_CONTROLLER);
        this.genCrafterModels();
        this.genCubeAllCutoutModels(RSBlocks.RELAY);
        this.genCubeAllCutoutModels(RSBlocks.NETWORK_TRANSMITTER);
        this.genCubeAllCutoutModels(RSBlocks.NETWORK_RECEIVER);
        this.genSecurityManagerModels();
        this.genDetectorModels();
        this.genWirelessTransmitterModels();
    }

    private void genWirelessTransmitterModels() {
        RSBlocks.WIRELESS_TRANSMITTER.forEach((color, registryObject) -> {
            Block block = (Block)registryObject.get();
            String folderName = RSBlocks.WIRELESS_TRANSMITTER.get(ColorMap.DEFAULT_COLOR).getId().m_135815_();
            this.models.wirelessTransmitterBlock(block, state -> {
                if (Boolean.FALSE.equals(state.m_61143_((Property)NetworkNodeBlock.CONNECTED))) {
                    return this.models.createWirelessTransmitterNonEmissiveModel("block/" + folderName + "/disconnected", this.resourceLocation(folderName, "cutouts/disconnected"));
                }
                BlockModelBuilder model = this.models.createWirelessTransmitterModel("block/" + folderName + "/" + color, this.resourceLocation(folderName, "cutouts/" + color));
                this.simpleBlockItem(block, (ModelFile)model);
                return model;
            }, 0);
        });
    }

    private void genDetectorModels() {
        RSBlocks.DETECTOR.forEach((color, registryObject) -> {
            Block block = (Block)registryObject.get();
            String folderName = RSBlocks.DETECTOR.get(ColorMap.DEFAULT_COLOR).getId().m_135815_();
            this.models.simpleBlockStateModel(block, state -> {
                if (Boolean.FALSE.equals(state.m_61143_((Property)DetectorBlock.POWERED))) {
                    return this.models.createDetectorNonEmissiveModel("block/" + folderName + "/off", this.resourceLocation(folderName, "cutouts/off"));
                }
                BlockModelBuilder model = this.models.createDetectorModel("block/" + folderName + "/" + color, this.resourceLocation(folderName, "cutouts/" + color));
                this.simpleBlockItem(block, (ModelFile)model);
                return model;
            });
        });
    }

    private void genSecurityManagerModels() {
        RSBlocks.SECURITY_MANAGER.forEach((color, registryObject) -> {
            Block block = (Block)registryObject.get();
            String folderName = RSBlocks.SECURITY_MANAGER.get(ColorMap.DEFAULT_COLOR).getId().m_135815_();
            this.models.horizontalRSBlock(block, state -> {
                if (Boolean.FALSE.equals(state.m_61143_((Property)NetworkNodeBlock.CONNECTED))) {
                    return this.models.createCubeCutoutNonEmissiveModel("block/" + folderName + "/disconnected", BOTTOM, BOTTOM, this.resourceLocation(folderName, "top"), this.resourceLocation(folderName, "cutouts/top_disconnected"), this.resourceLocation(folderName, "right"), this.resourceLocation(folderName, "cutouts/right_disconnected"), this.resourceLocation(folderName, "left"), this.resourceLocation(folderName, "cutouts/left_disconnected"), this.resourceLocation(folderName, "front"), this.resourceLocation(folderName, "cutouts/front_disconnected"), this.resourceLocation(folderName, "back"), this.resourceLocation(folderName, "cutouts/back_disconnected"));
                }
                BlockModelBuilder model = this.models.createCubeCutoutModel("block/" + folderName + "/" + color, BOTTOM, BOTTOM, this.resourceLocation(folderName, "top"), this.resourceLocation(folderName, "cutouts/top_" + color), this.resourceLocation(folderName, "right"), this.resourceLocation(folderName, "cutouts/right_" + color), this.resourceLocation(folderName, "left"), this.resourceLocation(folderName, "cutouts/left_" + color), this.resourceLocation(folderName, "front"), this.resourceLocation(folderName, "cutouts/front_" + color), this.resourceLocation(folderName, "back"), this.resourceLocation(folderName, "cutouts/back_" + color));
                this.simpleBlockItem(block, (ModelFile)model);
                return model;
            }, 180);
        });
    }

    private <T extends Block> void genCubeAllCutoutModels(ColorMap<T> blockMap) {
        blockMap.forEach((color, registryObject) -> {
            Block block = (Block)registryObject.get();
            String folderName = blockMap.get(ColorMap.DEFAULT_COLOR).getId().m_135815_();
            this.models.simpleBlockStateModel(block, state -> {
                if (Boolean.FALSE.equals(state.m_61143_((Property)NetworkNodeBlock.CONNECTED))) {
                    return this.models.createCubeAllCutoutNonEmissiveModel("block/" + folderName + "/disconnected", this.resourceLocation(folderName, folderName), this.resourceLocation(folderName, folderName), this.resourceLocation(folderName, "cutouts/disconnected"));
                }
                BlockModelBuilder model = this.models.createCubeAllCutoutModel("block/" + folderName + "/" + color, this.resourceLocation(folderName, folderName), this.resourceLocation(folderName, folderName), this.resourceLocation(folderName, "cutouts/" + color));
                this.simpleBlockItem(block, (ModelFile)model);
                return model;
            });
        });
    }

    private void genCrafterModels() {
        RSBlocks.CRAFTER.forEach((color, registryObject) -> {
            Block block = (Block)registryObject.get();
            String folderName = RSBlocks.CRAFTER.get(ColorMap.DEFAULT_COLOR).getId().m_135815_();
            this.models.anyDirectionalRSBlock(block, state -> {
                if (Boolean.FALSE.equals(state.m_61143_((Property)NetworkNodeBlock.CONNECTED))) {
                    return this.models.createCubeCutoutNonEmissiveModel("block/" + folderName + "/disconnected", BOTTOM, BOTTOM, this.resourceLocation(folderName, "top"), this.resourceLocation(folderName, "cutouts/top_disconnected"), this.resourceLocation(folderName, "side"), this.resourceLocation(folderName, "cutouts/side_disconnected"), this.resourceLocation(folderName, "side"), this.resourceLocation(folderName, "cutouts/side_disconnected"), this.resourceLocation(folderName, "side"), this.resourceLocation(folderName, "cutouts/side_disconnected"), this.resourceLocation(folderName, "side"), this.resourceLocation(folderName, "cutouts/side_disconnected"));
                }
                BlockModelBuilder model = this.models.createCubeCutoutModel("block/" + folderName + "/" + color, BOTTOM, BOTTOM, this.resourceLocation(folderName, "top"), this.resourceLocation(folderName, "cutouts/top_" + color), this.resourceLocation(folderName, "side"), this.resourceLocation(folderName, "cutouts/side_" + color), this.resourceLocation(folderName, "side"), this.resourceLocation(folderName, "cutouts/side_" + color), this.resourceLocation(folderName, "side"), this.resourceLocation(folderName, "cutouts/side_" + color), this.resourceLocation(folderName, "side"), this.resourceLocation(folderName, "cutouts/side_" + color));
                this.simpleBlockItem(block, (ModelFile)model);
                return model;
            }, 180);
        });
    }

    private <T extends Block> void genControllerModels(ColorMap<T> blockMap) {
        blockMap.forEach((color, registryObject) -> {
            Block block = (Block)registryObject.get();
            String folderName = RSBlocks.CONTROLLER.get(ColorMap.DEFAULT_COLOR).getId().m_135815_();
            this.models.simpleBlockStateModel(block, state -> {
                if (((ControllerBlock.EnergyType)((Object)((Object)((Object)state.m_61143_(ControllerBlock.ENERGY_TYPE))))).equals((Object)ControllerBlock.EnergyType.OFF)) {
                    return this.models.createCubeAllCutoutNonEmissiveModel("block/" + folderName + "/off", this.resourceLocation(folderName, "off"), this.resourceLocation(folderName, "off"), this.resourceLocation(folderName, "cutouts/off"));
                }
                if (((ControllerBlock.EnergyType)((Object)((Object)((Object)state.m_61143_(ControllerBlock.ENERGY_TYPE))))).equals((Object)ControllerBlock.EnergyType.NEARLY_OFF)) {
                    return this.models.createControllerNearlyCutoutModel("block/" + folderName + "/nearly_off", this.resourceLocation(folderName, "off"), this.resourceLocation(folderName, "on"), this.resourceLocation(folderName, "cutouts/nearly_off"), this.resourceLocation(folderName, "cutouts/nearly_off_gray"));
                }
                if (((ControllerBlock.EnergyType)((Object)((Object)((Object)state.m_61143_(ControllerBlock.ENERGY_TYPE))))).equals((Object)ControllerBlock.EnergyType.NEARLY_ON)) {
                    return this.models.createControllerNearlyCutoutModel("block/" + folderName + "/nearly_on", this.resourceLocation(folderName, "off"), this.resourceLocation(folderName, "on"), this.resourceLocation(folderName, "cutouts/nearly_on"), this.resourceLocation(folderName, "cutouts/nearly_on_gray"));
                }
                BlockModelBuilder model = this.models.createCubeAllCutoutModel("block/" + folderName + "/" + color, this.resourceLocation(folderName, "off"), this.resourceLocation(folderName, "on"), this.resourceLocation(folderName, "cutouts/" + color));
                ResourceLocation energyType = new ResourceLocation("refinedstorage", "energy_type");
                ((ItemModelBuilder)this.itemModels().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_())).override().predicate(energyType, 0.0f).model((ModelFile)this.models().getExistingFile(new ResourceLocation("refinedstorage", "block/" + folderName + "/off"))).end().override().predicate(energyType, 1.0f).model((ModelFile)this.models().getExistingFile(new ResourceLocation("refinedstorage", "block/" + folderName + "/nearly_off"))).end().override().predicate(energyType, 2.0f).model((ModelFile)this.models().getExistingFile(new ResourceLocation("refinedstorage", "block/" + folderName + "/nearly_on"))).end().override().predicate(energyType, 3.0f).model((ModelFile)model).end();
                return model;
            });
        });
    }

    private <T extends Block> void genNorthCutoutModels(ColorMap<T> blockMap, boolean useLoader) {
        blockMap.forEach((color, registryObject) -> {
            Block block = (Block)registryObject.get();
            String folderName = blockMap.get(ColorMap.DEFAULT_COLOR).getId().m_135815_();
            BlockModelBuilder disconnected = this.models.createCubeNorthCutoutNonEmissiveModel("block/" + folderName + "/disconnected", BOTTOM, this.resourceLocation(folderName, "top"), this.resourceLocation(folderName, "front"), this.resourceLocation(folderName, "back"), this.resourceLocation(folderName, "right"), this.resourceLocation(folderName, "left"), this.resourceLocation(folderName, "right"), this.resourceLocation(folderName, "cutouts/disconnected"));
            BlockModelBuilder connected = this.models.createCubeNorthCutoutModel("block/" + folderName + "/" + color, BOTTOM, this.resourceLocation(folderName, "top"), this.resourceLocation(folderName, "front"), this.resourceLocation(folderName, "back"), this.resourceLocation(folderName, "right"), this.resourceLocation(folderName, "left"), this.resourceLocation(folderName, "right"), this.resourceLocation(folderName, "cutouts/" + color));
            this.simpleBlockItem(block, (ModelFile)connected);
            if (useLoader) {
                this.models.customLoaderRSBlock(block, this.resourceLocation(folderName, "loader"), (ModelFile)connected, (ModelFile)disconnected);
            } else {
                this.models.horizontalRSBlock(block, arg_0 -> BlockModelGenerator.lambda$genNorthCutoutModels$12((ModelFile)disconnected, (ModelFile)connected, arg_0), 180);
            }
        });
    }

    private ResourceLocation resourceLocation(String folderName, String name) {
        return new ResourceLocation("refinedstorage", "block/" + folderName + "/" + name);
    }

    private static /* synthetic */ ModelFile lambda$genNorthCutoutModels$12(ModelFile disconnected, ModelFile connected, BlockState state) {
        if (Boolean.FALSE.equals(state.m_61143_((Property)NetworkNodeBlock.CONNECTED))) {
            return disconnected;
        }
        return connected;
    }
}

